/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.cdi40.internal.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cdi.internal.interfaces.CDIContainerEventManager;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.event.Shutdown;
import jakarta.enterprise.event.Startup;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.bootstrap.BeanDeploymentModule;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
@Component(name="io.openliberty.cdi40.internal.weld.CDI40ContainerEventManagerImpl", service={CDIContainerEventManager.class}, property={"service.vendor=IBM"}, configurationPolicy=ConfigurationPolicy.IGNORE)
public class CDI40ContainerEventManagerImpl
implements CDIContainerEventManager {
    private static final TraceComponent tc = Tr.register(CDI40ContainerEventManagerImpl.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private static Environment LIBERTY_EE_ENVIRONMENT = new LibertyEEEnvironment();
    static final long serialVersionUID = -4728261810637111019L;

    public void fireStartupEvent(BeanDeploymentModule module) {
        module.fireEvent(Startup.class, (Object)new Startup(), new Annotation[]{Any.Literal.INSTANCE});
    }

    public void fireShutdownEvent(BeanDeploymentModule module) {
        module.fireEvent(Shutdown.class, (Object)new Shutdown(), new Annotation[]{Any.Literal.INSTANCE});
    }

    public Environment getEnvironment() {
        return LIBERTY_EE_ENVIRONMENT;
    }

    public DeploymentException processDeploymentException(WebSphereCDIDeployment webSphereCDIDeployment, DeploymentException e) {
        Collection unversionedBeansXmlURLs;
        if (tc.isWarningEnabled() && (unversionedBeansXmlURLs = webSphereCDIDeployment.getUnversionedBeansXmlURLs()) != null && !unversionedBeansXmlURLs.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"unversioned.beansXML.warning.CWOWB1018W", (Object[])new Object[]{unversionedBeansXmlURLs});
        }
        return e;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class LibertyEEEnvironment
    implements Environment {
        private final Set<Class<? extends Service>> requiredBeanDeploymentArchiveServices = new HashSet<Class<? extends Service>>();
        private final Set<Class<? extends Service>> requiredDeploymentServices = new HashSet<Class<? extends Service>>();
        static final long serialVersionUID = -3640258028692295283L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public LibertyEEEnvironment() {
            this.requiredDeploymentServices.add(TransactionServices.class);
            this.requiredDeploymentServices.add(SecurityServices.class);
            this.requiredBeanDeploymentArchiveServices.add(ResourceLoader.class);
            this.requiredBeanDeploymentArchiveServices.add(InjectionServices.class);
        }

        public boolean automaticallyHandleStartupShutdownEvents() {
            return false;
        }

        public Set<Class<? extends Service>> getRequiredBeanDeploymentArchiveServices() {
            return this.requiredBeanDeploymentArchiveServices;
        }

        public Set<Class<? extends Service>> getRequiredDeploymentServices() {
            return this.requiredDeploymentServices;
        }

        public boolean isEEModulesAware() {
            return true;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.cdi40.internal.weld.CDI40ContainerEventManagerImpl$LibertyEEEnvironment", LibertyEEEnvironment.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
        }
    }
}

