/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.structures;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Objects;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CacheValue {
    private static final TraceComponent tc = Tr.register(CacheValue.class, null, null);
    private Object value;
    private long createdAt = 0L;
    static final long serialVersionUID = -4696109217326769572L;

    public CacheValue(Object value) {
        this(value, 0L);
    }

    public CacheValue(Object value, long clockSkew) {
        this.value = value;
        this.createdAt = System.currentTimeMillis();
        if (clockSkew > 0L) {
            this.createdAt += clockSkew;
        }
    }

    public Object getValue() {
        return this.value;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean isExpired(long timeoutInMilliseconds) {
        long now = System.currentTimeMillis();
        if (now - this.createdAt > timeoutInMilliseconds) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Entry is considered expired; the current time " + now + " - the created at time " + this.createdAt + " was larger than the specified timeout " + timeoutInMilliseconds), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheValue other = (CacheValue)obj;
        return Objects.equals(this.value, other.value);
    }
}

