/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.storage;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.HashUtils;
import io.openliberty.security.oidcclientcore.utils.Utils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcStorageUtils {
    static final long serialVersionUID = -8476297687049704749L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String getStateStorageKey(String state) {
        return "WASOidcState" + Utils.getStrHashCode(state);
    }

    public static String getNonceStorageKey(String clientId, String state) {
        return OidcStorageUtils.getStorageKey("WASOidcNonce", clientId, state);
    }

    public static String getOriginalReqUrlStorageKey(String state) {
        return "WASReqURLOidc" + Utils.getStrHashCode(state);
    }

    @Trivial
    public static String createStateStorageValue(String state, @Sensitive String clientSecret) {
        String newValue = state + clientSecret;
        String hashedStateValue = HashUtils.digest((String)newValue);
        String timestamp = state.substring(0, 15);
        return timestamp + hashedStateValue;
    }

    public static String createNonceStorageValue(String nonceValue, String state, @Sensitive String clientSecret) {
        return HashUtils.digest((String)(nonceValue + state + clientSecret));
    }

    @Sensitive
    @Trivial
    public static String getStorageKey(String prefix, String configId, String state) {
        String newValue = state + configId;
        String newName = Utils.getStrHashCode(newValue);
        return prefix + newName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.oidcclientcore.storage.OidcStorageUtils", OidcStorageUtils.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    }
}

