/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.event.internal.CurrentEvent;
import com.ibm.ws.event.internal.EventImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EventLocal<T> {
    private static final AtomicInteger count;
    private static ConcurrentHashMap<String, EventLocal<?>> eventLocalNames;
    private String name = null;
    private int index = count.getAndIncrement();
    private boolean isInheritable = false;
    static final long serialVersionUID = 3264677994033551289L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static <T> T getContextData(String name) {
        EventImpl event = (EventImpl)CurrentEvent.get();
        if (null != event) {
            return event.getContextData(name);
        }
        return null;
    }

    public static <T> EventLocal<T> getLocal(String name) {
        return eventLocalNames.get(name);
    }

    public static <T> EventLocal<T> createLocal() {
        return new EventLocal<T>(false);
    }

    public static <T> EventLocal<T> createInheritableLocal() {
        return new EventLocal<T>(true);
    }

    public static <T> EventLocal<T> createLocal(String name) {
        return EventLocal.internalCreateNamedLocal(name, false);
    }

    public static <T> EventLocal<T> createInheritableLocal(String name) {
        return EventLocal.internalCreateNamedLocal(name, true);
    }

    private static <T> EventLocal<T> internalCreateNamedLocal(String name, boolean inheritable) {
        EventLocal<?> prev;
        EventLocal<Object> local = eventLocalNames.get(name);
        if (local == null && (prev = eventLocalNames.putIfAbsent(name, local = new EventLocal<T>(name, inheritable))) != null) {
            local = prev;
        }
        return local;
    }

    public EventLocal(boolean inheritable) {
        this.isInheritable = inheritable;
    }

    private EventLocal(String name, boolean inheritable) {
        this(inheritable);
        this.name = name;
    }

    public boolean isInheritable() {
        return this.isInheritable;
    }

    public T initialValue() {
        return null;
    }

    public T get() {
        EventImpl event = (EventImpl)CurrentEvent.get();
        if (null == event) {
            return null;
        }
        return event.get(this);
    }

    public void set(T value) {
        EventImpl event = (EventImpl)CurrentEvent.get();
        if (null != event) {
            event.set(this, value);
        }
    }

    public T remove() {
        EventImpl event = (EventImpl)CurrentEvent.get();
        if (null != event) {
            if (this.name != null) {
                event.removeEventLocalName(this.name);
            }
            return event.remove(this);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (null == o || !(o instanceof EventLocal)) {
            return false;
        }
        return ((EventLocal)o).index == this.index;
    }

    public int hashCode() {
        return this.index;
    }

    public String toString() {
        return this.name;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.websphere.event.EventLocal", EventLocal.class, (String)"EventEngine", null);
        count = new AtomicInteger(0);
        eventLocalNames = new ConcurrentHashMap();
    }
}

