/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.annocache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annocache.FragmentAnnotations;
import com.ibm.ws.container.service.annocache.WebAnnotations;
import com.ibm.ws.container.service.annocache.internal.AnnotationsAdapterImpl;
import com.ibm.ws.container.service.annocache.internal.FragmentAnnotationsImpl;
import com.ibm.ws.container.service.annocache.internal.ModuleAnnotationsImpl;
import com.ibm.ws.container.service.annocache.internal.WebEJBAnnotationsImpl;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.LibraryClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.extended.LibraryContainerInfo;
import com.ibm.ws.container.service.config.WebFragmentInfo;
import com.ibm.ws.container.service.config.WebFragmentsInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.javaee.dd.web.common.AbsoluteOrdering;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_Factory;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebAnnotationsImpl
extends ModuleAnnotationsImpl
implements WebAnnotations {
    private final String webModuleName;
    private final WebFragmentsInfo webFragments;
    private final Map<String, WebFragmentInfo> pathToFragments;
    private final Map<WebFragmentInfo, String> fragmentToPath;
    protected final List<String> internalContainers = new ArrayList<String>();
    protected final List<String> extraContainers = new ArrayList<String>(0);
    protected boolean isSetExcludes;
    protected boolean isMetadataComplete;
    protected boolean hasExcludes;
    private final WebEJBAnnotationsLock webEJBAnnotationsLock = new WebEJBAnnotationsLock();
    private volatile WebAnnotationsImpl webEJBAnnotations;
    static final long serialVersionUID = 5879038312249982612L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebAnnotationsImpl(AnnotationsAdapterImpl annotationsAdapter, Container rootContainer, OverlayContainer rootOverlayContainer, ArtifactContainer rootArtifactContainer, Container rootAdaptableContainer, WebModuleInfo webModuleInfo) throws UnableToAdaptException {
        super(annotationsAdapter, rootContainer, rootOverlayContainer, rootArtifactContainer, rootAdaptableContainer, webModuleInfo);
        this.webModuleName = webModuleInfo.getName();
        this.webFragments = (WebFragmentsInfo)rootAdaptableContainer.adapt(WebFragmentsInfo.class);
        this.fragmentToPath = new IdentityHashMap<WebFragmentInfo, String>();
        this.pathToFragments = new HashMap<String, WebFragmentInfo>();
    }

    protected WebAnnotationsImpl(WebAnnotationsImpl webAnnotations, String catName) throws UnableToAdaptException {
        super(webAnnotations.getAnnotationsAdapter(), webAnnotations.getRootContainer(), webAnnotations.getRootOverlayContainer(), webAnnotations.getRootDelegateContainer(), webAnnotations.getContainer(), webAnnotations.getModuleInfo(), catName);
        this.webModuleName = webAnnotations.webModuleName;
        this.webFragments = webAnnotations.webFragments;
        this.fragmentToPath = webAnnotations.fragmentToPath;
        this.pathToFragments = webAnnotations.pathToFragments;
    }

    @Override
    public WebModuleInfo getModuleInfo() {
        return (WebModuleInfo)super.getModuleInfo();
    }

    @Override
    public String getWebModuleName() {
        return this.webModuleName;
    }

    @Override
    public WebFragmentsInfo getWebFragments() {
        return this.webFragments;
    }

    @Override
    public List<WebFragmentInfo> getOrderedItems() {
        return this.getWebFragments().getOrderedFragments();
    }

    @Override
    public List<WebFragmentInfo> getExcludedItems() {
        return this.getWebFragments().getExcludedFragments();
    }

    @Override
    public FragmentAnnotations getFragmentAnnotations(WebFragmentInfo fragment) {
        AnnotationTargets_Targets useTargets = this.getTargets();
        if (useTargets == null) {
            return null;
        }
        return new FragmentAnnotationsImpl(useTargets, this.getFragmentPath(fragment));
    }

    private String getFragmentPath(WebFragmentInfo fragment) {
        return this.fragmentToPath.get(fragment);
    }

    private String getUniquePath(String fragmentPath) {
        String uniquePath = fragmentPath;
        int count = 1;
        while (this.pathToFragments.containsKey(uniquePath)) {
            uniquePath = fragmentPath + "_" + count;
            ++count;
        }
        return uniquePath;
    }

    private String putUniquePath(WebFragmentInfo fragment, String fragmentPath) {
        String uniqueFragmentPath = this.getUniquePath(fragmentPath);
        this.fragmentToPath.put(fragment, uniqueFragmentPath);
        this.pathToFragments.put(uniqueFragmentPath, fragment);
        return uniqueFragmentPath;
    }

    protected void addInternalContainer(String path) {
        this.internalContainers.add(path);
    }

    public List<String> getInternalContainers() {
        return this.internalContainers;
    }

    protected void addExtraContainer(String path) {
        this.extraContainers.add(path);
    }

    public List<String> getExtraContainers() {
        return this.extraContainers;
    }

    @Override
    protected void addInternalToClassSource() {
        Container nextContainer;
        String nextUri;
        String methodName = "addInternalToClassSource";
        boolean isDebug = tc.isDebugEnabled();
        if (this.rootClassSource == null) {
            return;
        }
        ClassSource_Factory classSourceFactory = this.getClassSourceFactory();
        if (classSourceFactory == null) {
            return;
        }
        for (WebFragmentInfo nextFragment : this.getOrderedItems()) {
            String nextPath;
            String nextPrefix;
            boolean nextIsMetadataComplete;
            ClassSource_Aggregate.ScanPolicy nextPolicy;
            nextUri = nextFragment.getLibraryURI();
            nextContainer = nextFragment.getFragmentContainer();
            if (nextFragment.isSeedFragment()) {
                nextPolicy = ClassSource_Aggregate.ScanPolicy.SEED;
                nextIsMetadataComplete = false;
            } else {
                nextPolicy = ClassSource_Aggregate.ScanPolicy.PARTIAL;
                nextIsMetadataComplete = true;
            }
            if (isDebug) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Fragment [ " + nextFragment + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": URI [ " + nextUri + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Container [ " + nextContainer + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Metadata Complete [ " + nextIsMetadataComplete + " ]"), (Object[])new Object[0]);
            }
            if (nextUri.equals("WEB-INF/classes")) {
                nextContainer = nextContainer.getEnclosingContainer().getEnclosingContainer();
                nextPrefix = "WEB-INF/classes/";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + ": Assigned Prefix [ " + nextPrefix + " ]"), (Object[])new Object[0]);
                }
            } else {
                nextPrefix = null;
            }
            if ((nextPath = this.getContainerPath(nextContainer)) == null) {
                return;
            }
            nextPath = this.putUniquePath(nextFragment, nextPath);
            if (isDebug) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Fragment [ " + nextFragment + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Path [ " + nextPath + " ]"), (Object[])new Object[0]);
            }
            if (!this.addContainerClassSource(nextPath, nextContainer, nextPrefix, nextPolicy)) {
                return;
            }
            this.addInternalContainer(nextPath);
        }
        for (WebFragmentInfo nextFragment : this.getExcludedItems()) {
            String nextPath2;
            nextUri = nextFragment.getLibraryURI();
            nextContainer = nextFragment.getFragmentContainer();
            if (isDebug) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Fragment [ " + nextFragment + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": URI [ " + nextUri + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Container [ " + nextContainer + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Excluded [ true ]"), (Object[])new Object[0]);
            }
            if ((nextPath2 = this.getContainerPath(nextContainer)) == null) {
                return;
            }
            nextPath2 = this.putUniquePath(nextFragment, nextPath2);
            if (isDebug) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Fragment [ " + nextFragment + " ]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Path [ " + nextPath2 + " ]"), (Object[])new Object[0]);
            }
            if (!this.addContainerClassSource(nextPath2, nextContainer, ClassSource_Aggregate.ScanPolicy.EXCLUDED)) {
                return;
            }
            this.addInternalContainer(nextPath2);
        }
        if (this.getExtendScans() && !this.getHasExcludes()) {
            ClassSource_Aggregate.ScanPolicy extraPolicy = this.getIsMetadataComplete() ? ClassSource_Aggregate.ScanPolicy.PARTIAL : ClassSource_Aggregate.ScanPolicy.SEED;
            for (Container extraLibContainer : this.getApplicationExtendedContainers()) {
                String nextPath;
                try {
                    nextPath = WebAnnotationsImpl.getPath(extraLibContainer);
                }
                catch (UnableToAdaptException nextPath2) {
                    FFDCFilter.processException((Throwable)nextPath2, (String)"com.ibm.ws.container.service.annocache.internal.WebAnnotationsImpl", (String)"361", (Object)this, (Object[])new Object[0]);
                    return;
                }
                if (isDebug) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + ": Extra container [ " + nextPath + " ]"), (Object[])new Object[0]);
                }
                if (!this.addContainerClassSource(nextPath, extraLibContainer, extraPolicy)) {
                    return;
                }
                this.addExtraContainer(nextPath);
            }
        }
    }

    private static boolean isMetadataCompleteSupported(String schemaVersion) {
        int vLen = schemaVersion.length();
        if (vLen == 0) {
            return false;
        }
        char c0 = schemaVersion.charAt(0);
        if (!Character.isDigit(c0)) {
            return false;
        }
        if (c0 >= '3') {
            return true;
        }
        if (c0 == '0') {
            return false;
        }
        if (vLen == 1) {
            return false;
        }
        if (schemaVersion.charAt(1) != '.') {
            return true;
        }
        if (c0 == '1' || vLen == 2) {
            return false;
        }
        char c2 = schemaVersion.charAt(2);
        return Character.isDigit(c2) && c2 >= '5';
    }

    protected void setExcludes() {
        String exReason;
        String mcReason;
        String methodName = "setExcludes";
        if (this.isSetExcludes) {
            return;
        }
        WebApp webApp = this.adapt(this.getContainer(), WebApp.class);
        if (webApp == null) {
            this.isMetadataComplete = false;
            this.hasExcludes = false;
            mcReason = "No WebApp";
            exReason = "No WebApp";
        } else {
            String schemaVersion = webApp.getVersion();
            if (WebAnnotationsImpl.isMetadataCompleteSupported(schemaVersion)) {
                this.isMetadataComplete = webApp.isSetMetadataComplete() && webApp.isMetadataComplete();
                mcReason = "WebApp";
            } else {
                this.isMetadataComplete = true;
                mcReason = "WebApp Version";
            }
            if (!this.isMetadataComplete) {
                AbsoluteOrdering absOrder = webApp.getAbsoluteOrdering();
                this.hasExcludes = absOrder != null && !absOrder.isSetOthers();
                exReason = "WebApp";
            } else {
                this.hasExcludes = false;
                exReason = "isMetadataComplete";
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": isMetadataComplete [ " + this.isMetadataComplete + " ]: (" + mcReason + ")"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + ": hasExcludes [ " + this.hasExcludes + " ]: (" + exReason + ")"), (Object[])new Object[0]);
        }
        this.isSetExcludes = true;
    }

    protected boolean getIsMetadataComplete() {
        this.setExcludes();
        return this.isMetadataComplete;
    }

    protected boolean getHasExcludes() {
        this.setExcludes();
        return this.hasExcludes;
    }

    protected boolean getExtendScans() {
        Set<ModuleAnnotationsImpl.EnterpriseApplicationLibraryType> appScanOptions = this.getAppScanOptions();
        boolean scanManifestJars = appScanOptions.contains((Object)ModuleAnnotationsImpl.EnterpriseApplicationLibraryType.MANIFEST_LIB);
        boolean scanEarLibJars = appScanOptions.contains((Object)ModuleAnnotationsImpl.EnterpriseApplicationLibraryType.EAR_LIB);
        boolean scanSharedLibs = false;
        return scanManifestJars || scanEarLibJars || scanSharedLibs;
    }

    private List<Container> getApplicationExtendedContainers() {
        LinkedList<Container> sharedLibContainers;
        ApplicationClassesContainerInfo appClassesInfo = this.getAppClassesContainerInfo();
        if (appClassesInfo == null) {
            return Collections.emptyList();
        }
        Set<ModuleAnnotationsImpl.EnterpriseApplicationLibraryType> appScanOptions = this.getAppScanOptions();
        boolean scanManifestJars = appScanOptions.contains((Object)ModuleAnnotationsImpl.EnterpriseApplicationLibraryType.MANIFEST_LIB);
        boolean scanEarLibJars = appScanOptions.contains((Object)ModuleAnnotationsImpl.EnterpriseApplicationLibraryType.EAR_LIB);
        boolean scanSharedLibs = false;
        LinkedList<Container> manifestContainers = scanManifestJars ? new LinkedList<Container>() : null;
        LinkedList<Container> earLibContainers = scanEarLibJars ? new LinkedList<Container>() : null;
        LinkedList<Container> linkedList = sharedLibContainers = scanSharedLibs ? new LinkedList<Container>() : null;
        if (scanManifestJars) {
            for (ModuleClassesContainerInfo moduleClassesInfo : appClassesInfo.getModuleClassesContainerInfo()) {
                for (ContainerInfo containerInfo : moduleClassesInfo.getClassesContainerInfo()) {
                    Container container;
                    if (containerInfo.getType() != ContainerInfo.Type.MANIFEST_CLASSPATH || (container = containerInfo.getContainer()) == null) continue;
                    manifestContainers.add(container);
                }
            }
        }
        if (scanEarLibJars || scanSharedLibs) {
            for (ContainerInfo containerInfo : appClassesInfo.getLibraryClassesContainerInfo()) {
                LibraryClassesContainerInfo libContainerInfo;
                Container container;
                if (scanEarLibJars && containerInfo.getType() == ContainerInfo.Type.EAR_LIB && (container = containerInfo.getContainer()) != null) {
                    earLibContainers.add(container);
                }
                if (!scanSharedLibs || !(containerInfo instanceof LibraryClassesContainerInfo) || (libContainerInfo = (LibraryClassesContainerInfo)containerInfo).getLibraryType() != LibraryContainerInfo.LibraryType.COMMON_LIB) continue;
                for (ContainerInfo classesContainerInfo : libContainerInfo.getClassesContainerInfo()) {
                    Container container2 = classesContainerInfo.getContainer();
                    if (container2 == null) continue;
                    sharedLibContainers.add(container2);
                }
            }
        }
        LinkedList<Container> appLibraryContainers = new LinkedList<Container>();
        if (scanManifestJars) {
            appLibraryContainers.addAll(manifestContainers);
        }
        if (scanEarLibJars) {
            appLibraryContainers.addAll(earLibContainers);
        }
        if (scanSharedLibs) {
            appLibraryContainers.addAll(sharedLibContainers);
        }
        return appLibraryContainers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebAnnotationsImpl asEJBAnnotations() throws UnableToAdaptException {
        if (this.webEJBAnnotations == null) {
            WebEJBAnnotationsLock webEJBAnnotationsLock = this.webEJBAnnotationsLock;
            synchronized (webEJBAnnotationsLock) {
                this.webEJBAnnotations = this.getAppScanOptions().isEmpty() ? this : new WebEJBAnnotationsImpl(this);
            }
        }
        return this.webEJBAnnotations;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.annocache.internal.WebAnnotationsImpl", WebAnnotationsImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class WebEJBAnnotationsLock {
        static final long serialVersionUID = -2601387856279635128L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected WebEJBAnnotationsLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.annocache.internal.WebAnnotationsImpl$WebEJBAnnotationsLock", WebEJBAnnotationsLock.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
        }
    }
}

