/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLinkReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPLinkRemoteMessagePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPVirtualLinkControllable;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;

public final class LinkChangeListener
implements com.ibm.ws.sib.trm.links.LinkChangeListener {
    private static final TraceComponent tc = SibTr.register(LinkChangeListener.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor _messageProcessor;
    private DestinationManager _destinationManager;
    private HashMap<SIBUuid12, Boolean> linkStarted = new HashMap();

    public LinkChangeListener(MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LinkChangeListener", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        this._destinationManager = messageProcessor.getDestinationManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LinkChangeListener", (Object)this);
        }
    }

    public void linkChange(SIBUuid12 linkUuid, SIBUuid8 outboundMEUuid, SIBUuid8 inboundMEUuid) {
        DestinationHandler dh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"linkChange", (Object)new Object[]{linkUuid, outboundMEUuid, inboundMEUuid});
        }
        if ((dh = this._destinationManager.getDestinationInternal(linkUuid, false)) != null && dh instanceof LinkHandler) {
            boolean connectionDown;
            LinkHandler linkHandler;
            block23: {
                linkHandler = (LinkHandler)dh;
                connectionDown = false;
                if (outboundMEUuid != null) {
                    String linkType = linkHandler.getType();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Changing a link of type: " + linkType));
                    }
                    try {
                        if (linkType.equals("SIBVirtualMQLink")) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Drive updateLocalisationSet for an MQLinkHandler");
                            }
                            linkHandler.updateLocalisationSet(outboundMEUuid, null);
                            if (this.linkStarted.get(linkUuid) == null || !this.linkStarted.get(linkUuid).booleanValue()) {
                                linkHandler.requestReallocation();
                                if (!linkHandler.isMQLink()) {
                                    SIMPIterator it = ((SIMPVirtualLinkControllable)linkHandler.getControlAdapter()).getLinkRemoteQueuePointControllableIterator();
                                    while (it.hasNext()) {
                                        ((HealthStateListener)((SIMPLinkRemoteMessagePointControllable)it.next()).getOutboundTransmit().getHealthState()).updateHealth(HealthStateListener.CONNECTION_UNAVAILABLE_STATE, 2);
                                    }
                                }
                                this.linkStarted.put(linkUuid, Boolean.TRUE);
                            }
                            break block23;
                        }
                        if (inboundMEUuid != null) {
                            SIBUuid8 existingInboundUuid = linkHandler.updateLocalisationSet(inboundMEUuid, outboundMEUuid);
                            if (this.linkStarted.get(linkUuid) == null || !this.linkStarted.get(linkUuid).booleanValue() || !existingInboundUuid.equals((Object)inboundMEUuid)) {
                                if (outboundMEUuid.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
                                    this._messageProcessor.getProxyHandler().linkStarted(linkHandler.getBusName(), inboundMEUuid);
                                }
                                linkHandler.requestReallocation();
                                SIMPIterator it = ((SIMPVirtualLinkControllable)linkHandler.getControlAdapter()).getLinkRemoteQueuePointControllableIterator();
                                while (it.hasNext()) {
                                    ((HealthStateListener)((SIMPLinkRemoteMessagePointControllable)it.next()).getOutboundTransmit().getHealthState()).updateHealth(HealthStateListener.CONNECTION_UNAVAILABLE_STATE, 2);
                                }
                                it = ((SIMPVirtualLinkControllable)linkHandler.getControlAdapter()).getLinkReceiverControllableIterator();
                                while (it.hasNext()) {
                                    ((HealthStateListener)((SIMPLinkReceiverControllable)it.next()).getHealthState()).updateHealth(HealthStateListener.CONNECTION_UNAVAILABLE_STATE, 2);
                                }
                                this.linkStarted.put(linkUuid, Boolean.TRUE);
                            }
                            break block23;
                        }
                        connectionDown = true;
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.LinkChangeListener.linkChange", (String)"1:219:1.28", (Object)this);
                    }
                } else {
                    connectionDown = true;
                }
            }
            if (connectionDown) {
                SIMPIterator it;
                this.linkStarted.put(linkUuid, Boolean.FALSE);
                if (!linkHandler.isMQLink()) {
                    it = ((SIMPVirtualLinkControllable)linkHandler.getControlAdapter()).getLinkRemoteQueuePointControllableIterator();
                    while (it.hasNext()) {
                        ((HealthStateListener)((SIMPLinkRemoteMessagePointControllable)it.next()).getOutboundTransmit().getHealthState()).updateHealth(HealthStateListener.CONNECTION_UNAVAILABLE_STATE, 0);
                    }
                }
                if (!linkHandler.getType().equals("SIBVirtualMQLink")) {
                    it = ((SIMPVirtualLinkControllable)linkHandler.getControlAdapter()).getLinkReceiverControllableIterator();
                    while (it.hasNext()) {
                        ((HealthStateListener)((SIMPLinkReceiverControllable)it.next()).getHealthState()).updateHealth(HealthStateListener.CONNECTION_UNAVAILABLE_STATE, 0);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"linkChange");
        }
    }
}

