/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.cdi.BatchXMLMapper;
import com.ibm.jbatch.container.cdi.CDIBatchArtifactFactory;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.util.DependencyInjectionUtility;
import com.ibm.jbatch.container.ws.JoblogUtil;
import com.ibm.jbatch.spi.services.IBatchArtifactFactory;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamConstants;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class DelegatingBatchArtifactFactoryImpl
implements IBatchArtifactFactory,
XMLStreamConstants {
    private static final Logger logger = Logger.getLogger(DelegatingBatchArtifactFactoryImpl.class.getName());
    protected CDIBatchArtifactFactory cdiBatchArtifactFactory;
    private static final Set<Class<?>> classIssuedMessagesSet = Collections.newSetFromMap(new WeakHashMap());
    static final long serialVersionUID = 5815943756711210559L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DelegatingBatchArtifactFactoryImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCDIBatchArtifactFactory(CDIBatchArtifactFactory preferredArtifactFactory) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "setCDIBatchArtifactFactory", new Object[]{preferredArtifactFactory});
        }
        this.cdiBatchArtifactFactory = preferredArtifactFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "setCDIBatchArtifactFactory");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetCDIBatchArtifactFactory(CDIBatchArtifactFactory preferredArtifactFactory) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "unsetCDIBatchArtifactFactory", new Object[]{preferredArtifactFactory});
        }
        if (this.cdiBatchArtifactFactory == preferredArtifactFactory) {
            this.cdiBatchArtifactFactory = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "unsetCDIBatchArtifactFactory");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static synchronized void addClassToIssuedMessage(Class<?> clazz) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "addClassToIssuedMessage", new Object[]{clazz});
        }
        classIssuedMessagesSet.add(clazz);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "addClassToIssuedMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static synchronized boolean classExistsInIssuedMessage(Class<?> clazz) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "classExistsInIssuedMessage", new Object[]{clazz});
        }
        boolean bl = classIssuedMessagesSet.contains(clazz);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "classExistsInIssuedMessage", bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object load(String batchId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "load", new Object[]{batchId});
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        BatchXMLMapper batchXMLMapper = new BatchXMLMapper(tccl);
        if (this.cdiBatchArtifactFactory != null) {
            Object artifact = null;
            artifact = this.cdiBatchArtifactFactory.load(batchId);
            if (artifact != null) {
                Object object = artifact;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    object = object;
                    logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "load", object);
                }
                return object;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "load: Artifact not referenced using CDI, will search through Batch.xml: ", tccl);
        }
        Object loadedArtifact = null;
        Class<?> clazz = batchXMLMapper.getArtifactById(batchId);
        if (clazz != null) {
            try {
                loadedArtifact = clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                void e;
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", (String)"107", (Object)this, (Object[])new Object[]{batchId});
                throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + batchId, (Throwable)e);
            }
            catch (InstantiationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", (String)"109", (Object)this, (Object[])new Object[]{batchId});
                throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + batchId, e);
            }
        }
        clazz = null;
        if (loadedArtifact == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "load: Artifact not found in batch.xml, trying thread context classloader: ", tccl);
            }
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(batchId);
                if (clazz != null) {
                    loadedArtifact = clazz.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", (String)"125", (Object)this, (Object[])new Object[]{batchId});
                throw new BatchContainerRuntimeException("Failed to load artifact with id: " + batchId, e);
            }
            catch (InstantiationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", (String)"127", (Object)this, (Object[])new Object[]{batchId});
                throw new BatchContainerRuntimeException("Failed to load artifact with id: " + batchId, e);
            }
            catch (IllegalAccessException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", (String)"129", (Object)this, (Object[])new Object[]{batchId});
                throw new BatchContainerRuntimeException("Failed to load artifact with id: " + batchId, e);
            }
        }
        if (this.cdiBatchArtifactFactory != null && !DelegatingBatchArtifactFactoryImpl.classExistsInIssuedMessage(clazz)) {
            DelegatingBatchArtifactFactoryImpl.addClassToIssuedMessage(clazz);
            Object[] arr = new Object[]{this.getClass().getName()};
            JoblogUtil.logToJobLogAndTrace(Level.WARNING, "cdi.ambiguous.artifact.names", arr, logger);
        }
        DependencyInjectionUtility.injectReferences(loadedArtifact, ProxyFactory.getInjectionReferences());
        Object v1 = loadedArtifact;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            v1 = v1;
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "load", v1);
        }
        return v1;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "init", new Object[]{batchConfig});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "init");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() throws BatchContainerServiceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "shutdown", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "shutdown");
        }
    }
}

