/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.EntityManagerBuilder;
import io.openliberty.data.internal.persistence.Util;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import jakarta.data.exceptions.MappingException;
import jakarta.persistence.Inheritance;
import java.io.PrintWriter;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EntityInfo {
    public static final String RECORD_ENTITY_SUFFIX = "Entity";
    static final String FAILED = "ERROR!";
    final Map<String, List<Member>> attributeAccessors;
    final Map<String, String> attributeNames;
    final SortedSet<String> attributeNamesForEntityUpdate;
    final SortedMap<String, Class<?>> attributeTypes;
    final EntityManagerBuilder builder;
    final Map<String, Class<?>> collectionElementTypes;
    final Class<?> entityClass;
    final Class<?> idType;
    final SortedMap<String, Member> idClassAttributeAccessors;
    final boolean inheritance;
    final String name;
    final Class<?> recordClass;
    final String versionAttributeName;
    final Map<Class<?>, List<String>> relationAttributeNames;
    static final long serialVersionUID = -4618475343110308965L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    EntityInfo(String entityName, Class<?> entityClass, Class<?> recordClass, Map<String, List<Member>> attributeAccessors, Map<String, String> attributeNames, SortedSet<String> attributeNamesForUpdate, SortedMap<String, Class<?>> attributeTypes, Map<String, Class<?>> collectionElementTypes, Map<Class<?>, List<String>> relationAttributeNames, Class<?> idType, SortedMap<String, Member> idClassAttributeAccessors, String versionAttributeName, EntityManagerBuilder entityManagerBuilder) {
        this.name = entityName;
        this.builder = entityManagerBuilder;
        this.entityClass = entityClass;
        this.attributeAccessors = attributeAccessors;
        this.attributeNames = attributeNames;
        this.attributeNamesForEntityUpdate = attributeNamesForUpdate;
        this.attributeTypes = attributeTypes;
        this.collectionElementTypes = collectionElementTypes;
        this.relationAttributeNames = relationAttributeNames;
        this.idType = idType;
        this.idClassAttributeAccessors = idClassAttributeAccessors;
        this.recordClass = recordClass;
        this.versionAttributeName = versionAttributeName;
        this.inheritance = entityClass.getAnnotation(Inheritance.class) != null;
        this.validate();
    }

    @Trivial
    Collection<String> getAttributeNames() {
        return this.attributeNames.values();
    }

    List<String> getExampleMethodNames() {
        ArrayList<String> examples = new ArrayList<String>(5);
        String[] prefixes = new String[]{"find", "delete", "count", "exists"};
        String[] numSuffixes = new String[]{"LessThanEqual(max)", "Between(min, max)", "GreaterThan(exclusiveMin)", "NotIn(setOfValues)"};
        String[] strSuffixes = new String[]{"StartsWith(prefix)", "IgnoreCaseContains(pattern)", "EndsWith(suffix)", "NotLike(pattern)"};
        int b = 0;
        int e = 0;
        int n = 0;
        int p = 0;
        int s = 0;
        for (Map.Entry<String, Class<?>> attrClass : this.attributeTypes.entrySet()) {
            String attrName = attrClass.getKey();
            Class<?> attrType = attrClass.getValue();
            if (attrName.length() > 2 && !attrName.toLowerCase().contains("version") && attrName.indexOf(46) < 0 && attrName.indexOf(95) < 0) {
                if (CharSequence.class.isAssignableFrom(attrType)) {
                    examples.add(prefixes[p++] + "By" + Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1) + strSuffixes[s++]);
                } else if (Boolean.TYPE.equals(attrType) || Boolean.class.equals(attrType)) {
                    examples.add(prefixes[p++] + "By" + Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1) + (b++ % 2 == 0 ? "False()" : "True()"));
                } else if (attrType.isPrimitive() || Number.class.isAssignableFrom(attrType) || Temporal.class.isAssignableFrom(attrType)) {
                    examples.add(prefixes[p++] + "By" + Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1) + numSuffixes[n++]);
                } else if (attrType.isEnum()) {
                    examples.add(prefixes[p++] + "By" + Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1) + (e++ % 2 == 0 ? "NotIn(setOfValues)" : "In(setOfValues)"));
                }
            }
            if (p < 4) continue;
            break;
        }
        if (p == 0) {
            examples.add("findById(id)");
            examples.add("deleteByIdNotIn(setOfValues)");
        }
        return examples;
    }

    @Trivial
    Class<?> getType() {
        return this.recordClass == null ? this.entityClass : this.recordClass;
    }

    @Trivial
    public void introspect(PrintWriter writer, String indent) {
        writer.println(indent + "EntityInfo@" + Integer.toHexString(this.hashCode()));
        writer.println(indent + "  name: " + this.name);
        writer.println(indent + "  entity class: " + this.entityClass.getName());
        writer.println(indent + "  record class: " + (this.recordClass == null ? null : this.recordClass.getName()));
        writer.println(indent + "  builder: " + String.valueOf(this.builder));
        writer.println(indent + "  idType: " + (this.idType == null ? null : this.idType.getName()));
        if (this.idClassAttributeAccessors != null) {
            this.idClassAttributeAccessors.forEach((idAttrName, member) -> {
                writer.println(indent + "  id attribute: " + idAttrName);
                writer.println(indent + "    accessor: " + String.valueOf(member));
            });
        }
        writer.println(indent + "  version attribute: " + this.versionAttributeName);
        writer.println(indent + "  attribute types");
        this.attributeTypes.forEach((name, type) -> writer.println(indent + "    " + name + ": " + type.getTypeName()));
        if (!this.collectionElementTypes.isEmpty()) {
            writer.println(indent + "  collection types");
            this.collectionElementTypes.forEach((name, type) -> writer.println(indent + "    " + name + ": " + type.getTypeName()));
        }
        writer.println(indent + "  attribute accessors");
        this.attributeAccessors.forEach((name, accessors) -> {
            writer.print(indent + "    " + name + ": ");
            writer.println(accessors.size() == 1 ? accessors.get(0) : accessors);
        });
        writer.println(indent + "  lower case attribute name to JPQL attribute name:");
        this.attributeNames.forEach((lower, name) -> writer.println(indent + "    " + lower + " -> " + name));
        if (!this.relationAttributeNames.isEmpty()) {
            writer.println(indent + "    relation attributes:");
            this.relationAttributeNames.forEach((relationClass, relAttrNames) -> writer.println(indent + "    " + relationClass.getName() + ": " + String.valueOf(relAttrNames)));
        }
        writer.println(indent + "  attributes for entity update: " + String.valueOf(this.attributeNamesForEntityUpdate));
    }

    @Trivial
    public static CompletableFuture<EntityInfo> newFuture(Class<?> entityClass) {
        return new CompletableFuture<EntityInfo>();
    }

    @Trivial
    final Object toRecord(Object entity) throws Exception {
        Method toRecord = entity.getClass().getMethod("toRecord", new Class[0]);
        return toRecord.invoke(entity, new Object[0]);
    }

    @Trivial
    public String toString() {
        return "EntityInfo@" + Integer.toHexString(this.hashCode()) + ' ' + this.name + ' ' + this.attributeTypes.keySet();
    }

    @Trivial
    private void validate() {
        if (this.builder.convertibleTypes == null) {
            return;
        }
        for (Map.Entry<String, Class<?>> attrTypeEntry : this.attributeTypes.entrySet()) {
            Class<?> attrType = attrTypeEntry.getValue();
            if (this.builder.convertibleTypes.contains(attrType) || !Util.UNSUPPORTED_ATTR_TYPES.contains(attrType)) continue;
            throw DataExtension.exc(MappingException.class, "CWWKD1055.unsupported.entity.attr", attrTypeEntry.getKey(), this.entityClass.getName(), attrType.getName(), Util.SUPPORTED_TEMPORAL_TYPES, Util.SUPPORTED_BASIC_TYPES, "@Convert(converter=YourOwnAttributeConverter.class)");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.data.internal.persistence.EntityInfo", EntityInfo.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    }
}

