/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec.identitystore;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.storage.CookieBasedStorage;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import io.openliberty.security.oidcclientcore.storage.SessionBasedStorage;
import io.openliberty.security.oidcclientcore.storage.Storage;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import jakarta.security.enterprise.identitystore.openid.IdentityToken;
import jakarta.security.enterprise.identitystore.openid.OpenIdClaims;
import jakarta.security.enterprise.identitystore.openid.OpenIdContext;
import jakarta.security.enterprise.identitystore.openid.RefreshToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenIdContextImpl
implements OpenIdContext {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(OpenIdContextImpl.class, (String)"OpenIdConnect", (String)"io.openliberty.security.jakartasec.internal.resources.JakartaSecurity30Messages");
    private String subjectIdentifier;
    private String tokenType;
    private AccessToken accessToken;
    private IdentityToken identityToken;
    private OpenIdClaims userinfoClaims;
    private transient JsonObject userinfoClaimsAsJson = null;
    private transient JsonObject providerMetadata;
    private String state;
    private boolean useSession;
    private String clientId;
    private RefreshToken refreshToken;
    private Long expiresIn;

    public OpenIdContextImpl() {
        this(null, null, null, null, null, null, null, false, null);
    }

    public OpenIdContextImpl(String subjectIdentifier, String tokenType, AccessToken accessToken, IdentityToken identityToken, OpenIdClaims userinfoClaims, JsonObject providerMetadata, String state, boolean useSession, String clientId) {
        this.subjectIdentifier = subjectIdentifier;
        this.tokenType = tokenType;
        this.accessToken = accessToken;
        this.identityToken = identityToken;
        this.userinfoClaims = userinfoClaims;
        this.providerMetadata = providerMetadata;
        this.state = state;
        this.useSession = useSession;
        this.clientId = clientId;
    }

    public String getSubject() {
        return this.subjectIdentifier;
    }

    public void setSubject(String subjectIdentifier) {
        this.subjectIdentifier = subjectIdentifier;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public IdentityToken getIdentityToken() {
        return this.identityToken;
    }

    public void setIdentityToken(IdentityToken identityToken) {
        this.identityToken = identityToken;
    }

    public Optional<RefreshToken> getRefreshToken() {
        if (this.refreshToken != null) {
            return Optional.of(this.refreshToken);
        }
        return Optional.empty();
    }

    public void setRefreshToken(RefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Optional<Long> getExpiresIn() {
        if (this.expiresIn != null) {
            return Optional.of(this.expiresIn);
        }
        return Optional.empty();
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public JsonObject getClaimsJson() {
        if (this.userinfoClaimsAsJson == null) {
            this.userinfoClaimsAsJson = this.createClaimsJson();
        }
        return this.userinfoClaimsAsJson;
    }

    private JsonObject createClaimsJson() {
        JsonObjectBuilder builder;
        block25: {
            builder = Json.createObjectBuilder();
            if (this.userinfoClaims == null) {
                return null;
            }
            try {
                if (this.userinfoClaims.getSubject() != null && !this.userinfoClaims.getSubject().isEmpty()) {
                    builder.add("sub", this.userinfoClaims.getSubject());
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"JAKARTASEC_WARNING_MISSING_SUBJECT_CLAIMS", (Object[])new Object[]{this.clientId});
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"io.openliberty.security.jakartasec.identitystore.OpenIdContextImpl", (String)"168", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isWarningEnabled()) break block25;
                Tr.warning((TraceComponent)tc, (String)"JAKARTASEC_WARNING_MISSING_SUBJECT_CLAIMS", (Object[])new Object[]{this.clientId});
            }
        }
        if (this.userinfoClaims.getAddress().isPresent()) {
            builder.add("address", (String)this.userinfoClaims.getAddress().get());
        }
        if (this.userinfoClaims.getBirthdate().isPresent()) {
            builder.add("birthdate", (String)this.userinfoClaims.getBirthdate().get());
        }
        if (this.userinfoClaims.getEmail().isPresent()) {
            builder.add("email", (String)this.userinfoClaims.getEmail().get());
        }
        if (this.userinfoClaims.getEmailVerified().isPresent()) {
            builder.add("email_verified", (String)this.userinfoClaims.getEmailVerified().get());
        }
        if (this.userinfoClaims.getFamilyName().isPresent()) {
            builder.add("family_name", (String)this.userinfoClaims.getFamilyName().get());
        }
        if (this.userinfoClaims.getGender().isPresent()) {
            builder.add("gender", (String)this.userinfoClaims.getGender().get());
        }
        if (this.userinfoClaims.getGivenName().isPresent()) {
            builder.add("given_name", (String)this.userinfoClaims.getGivenName().get());
        }
        if (this.userinfoClaims.getLocale().isPresent()) {
            builder.add("locale", (String)this.userinfoClaims.getLocale().get());
        }
        if (this.userinfoClaims.getMiddleName().isPresent()) {
            builder.add("middle_name", (String)this.userinfoClaims.getMiddleName().get());
        }
        if (this.userinfoClaims.getName().isPresent()) {
            builder.add("name", (String)this.userinfoClaims.getName().get());
        }
        if (this.userinfoClaims.getNickname().isPresent()) {
            builder.add("nickname", (String)this.userinfoClaims.getNickname().get());
        }
        if (this.userinfoClaims.getPhoneNumber().isPresent()) {
            builder.add("phone_number", (String)this.userinfoClaims.getPhoneNumber().get());
        }
        if (this.userinfoClaims.getPhoneNumberVerified().isPresent()) {
            builder.add("phone_number_verified", (String)this.userinfoClaims.getPhoneNumberVerified().get());
        }
        if (this.userinfoClaims.getPicture().isPresent()) {
            builder.add("picture", (String)this.userinfoClaims.getPicture().get());
        }
        if (this.userinfoClaims.getPreferredUsername().isPresent()) {
            builder.add("preferred_username", (String)this.userinfoClaims.getPreferredUsername().get());
        }
        if (this.userinfoClaims.getProfile().isPresent()) {
            builder.add("profile", (String)this.userinfoClaims.getProfile().get());
        }
        if (this.userinfoClaims.getUpdatedAt().isPresent()) {
            builder.add("updated_at", (String)this.userinfoClaims.getUpdatedAt().get());
        }
        if (this.userinfoClaims.getWebsite().isPresent()) {
            builder.add("website", (String)this.userinfoClaims.getWebsite().get());
        }
        if (this.userinfoClaims.getZoneinfo().isPresent()) {
            builder.add("zoneinfo", (String)this.userinfoClaims.getZoneinfo().get());
        }
        JsonObject json = builder.build();
        return json;
    }

    public OpenIdClaims getClaims() {
        return this.userinfoClaims;
    }

    public void setClaims(OpenIdClaims userinfoClaims) {
        this.userinfoClaims = userinfoClaims;
    }

    public JsonObject getProviderMetadata() {
        if (this.providerMetadata == null) {
            return null;
        }
        return Json.createReader((Reader)new StringReader(this.providerMetadata.toString())).readObject();
    }

    public void setProviderMetadata(JsonObject providerMetadata) {
        this.providerMetadata = providerMetadata;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean isUseSession() {
        return this.useSession;
    }

    public void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public <T> Optional<T> getStoredValue(HttpServletRequest request, HttpServletResponse response, String key) {
        String value = null;
        Storage storage = this.getStorage(request, response);
        if ("oidc.original.request".equals(key)) {
            String storageName = OidcStorageUtils.getOriginalReqUrlStorageKey((String)this.state);
            value = storage.get(storageName);
        }
        return value != null ? Optional.of(value) : Optional.empty();
    }

    private Storage getStorage(HttpServletRequest request, HttpServletResponse response) {
        if (this.useSession) {
            return new SessionBasedStorage(request);
        }
        return new CookieBasedStorage(request, response);
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        boolean providerMetadataExists = input.readBoolean();
        this.providerMetadata = providerMetadataExists ? Json.createReader((Reader)new StringReader((String)input.readObject())).readObject() : null;
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        if (this.providerMetadata == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeObject(this.providerMetadata.toString());
        }
    }
}

