/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.event.internal;

import com.ibm.websphere.event.Topic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.event.internal.EventEngineImpl;
import com.ibm.ws.event.internal.HandlerHolder;
import com.ibm.ws.event.internal.TopicData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class TopicBasedCache {
    private static final long serialVersionUID = -1668099068630434622L;
    static final String DEFAULT_STAGE_NAME = "Events";
    final Map<ServiceReference<?>, HandlerHolder> serviceReferenceMap = new HashMap();
    final Map<String, List<HandlerHolder>> discreteEventHandlers = new HashMap<String, List<HandlerHolder>>();
    final Map<String, List<HandlerHolder>> wildcardEventHandlers = new HashMap<String, List<HandlerHolder>>();
    final Map<String, String> discreteStageTopics = new HashMap<String, String>();
    final Map<String, String> wildcardStageTopics = new HashMap<String, String>();
    final Map<String, TopicData> topicDataCache = new ConcurrentHashMap<String, TopicData>();
    EventEngineImpl eventEngine;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    TopicBasedCache(EventEngineImpl eventEngine) {
        this.eventEngine = eventEngine;
    }

    synchronized void setStageTopics(String stageName, String[] topics) {
        for (String t : topics) {
            if (t.equals("*")) {
                this.wildcardStageTopics.put("", stageName);
                continue;
            }
            if (t.endsWith("/*")) {
                this.wildcardStageTopics.put(t.substring(0, t.length() - 1), stageName);
                continue;
            }
            this.discreteStageTopics.put(t, stageName);
        }
        this.clearTopicDataCache();
    }

    synchronized ExecutorService getExecutor(String topic) {
        String stageName = this.discreteStageTopics.get(topic);
        if (stageName == null) {
            String candidateTopic = null;
            for (Map.Entry<String, String> entry : this.wildcardStageTopics.entrySet()) {
                String key = entry.getKey();
                if (!topic.startsWith(key)) continue;
                if (candidateTopic == null) {
                    candidateTopic = key;
                    stageName = entry.getValue();
                    continue;
                }
                if (key.length() <= candidateTopic.length()) continue;
                candidateTopic = key;
                stageName = entry.getValue();
            }
        }
        if (stageName == null) {
            stageName = DEFAULT_STAGE_NAME;
        }
        return this.eventEngine.getExecutorService(stageName);
    }

    synchronized void addHandler(ServiceReference<?> serviceReference, boolean osgiHandler) {
        HandlerHolder holder = new HandlerHolder(this.eventEngine, serviceReference, osgiHandler);
        this.serviceReferenceMap.put(serviceReference, holder);
        for (String topic : holder.getDiscreteTopics()) {
            this.addTopicHandlerToMap(topic, holder, this.discreteEventHandlers);
        }
        for (String topic : holder.getWildcardTopics()) {
            this.addTopicHandlerToMap(topic, holder, this.wildcardEventHandlers);
        }
        this.clearTopicDataCache();
    }

    synchronized void removeHandler(ServiceReference<?> serviceReference) {
        HandlerHolder holder = this.serviceReferenceMap.remove(serviceReference);
        if (holder != null) {
            for (String topic : holder.getDiscreteTopics()) {
                this.removeTopicHandlerFromMap(topic, holder, this.discreteEventHandlers);
            }
            for (String topic : holder.getWildcardTopics()) {
                this.removeTopicHandlerFromMap(topic, holder, this.wildcardEventHandlers);
            }
        }
        this.clearTopicDataCache();
    }

    synchronized void updateHandler(ServiceReference<?> serviceReference, boolean osgiHandler) {
        this.removeHandler(serviceReference);
        this.addHandler(serviceReference, osgiHandler);
    }

    synchronized List<HandlerHolder> findHandlers(String topic) {
        ArrayList<HandlerHolder> handlers = new ArrayList<HandlerHolder>();
        List<HandlerHolder> discreteHandlers = this.discreteEventHandlers.get(topic);
        if (discreteHandlers != null) {
            handlers.addAll(discreteHandlers);
        }
        for (Map.Entry<String, List<HandlerHolder>> entry : this.wildcardEventHandlers.entrySet()) {
            if (!topic.startsWith(entry.getKey())) continue;
            handlers.addAll((Collection<HandlerHolder>)entry.getValue());
        }
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TopicData getTopicData(Topic topic, String topicName) {
        TopicData topicData = null;
        if (topic != null) {
            topicData = topic.getTopicData();
        }
        if (topicData == null) {
            topicData = this.topicDataCache.get(topicName);
            if (topic != null && topicData != null) {
                topic.setTopicDataReference(topicData.getReference());
            }
        }
        if (topicData == null) {
            TopicBasedCache topicBasedCache = this;
            synchronized (topicBasedCache) {
                topicData = this.buildTopicData(topicName);
                if (topic != null) {
                    topic.setTopicDataReference(topicData.getReference());
                }
            }
        }
        return topicData;
    }

    private synchronized TopicData buildTopicData(String topicName) {
        ExecutorService executorService = this.getExecutor(topicName);
        List<HandlerHolder> handlers = this.findHandlers(topicName);
        TopicData topicData = new TopicData(topicName, executorService, handlers);
        this.topicDataCache.put(topicName, topicData);
        return topicData;
    }

    private synchronized void clearTopicDataCache() {
        for (TopicData topicData : this.topicDataCache.values()) {
            topicData.clearReference();
        }
        this.topicDataCache.clear();
    }

    private synchronized void addTopicHandlerToMap(String topic, HandlerHolder holder, Map<String, List<HandlerHolder>> map) {
        List<HandlerHolder> handlers = map.get(topic);
        if (handlers == null) {
            handlers = new ArrayList<HandlerHolder>();
            map.put(topic, handlers);
        }
        if (!handlers.contains(holder)) {
            handlers.add(holder);
        }
        Collections.sort(handlers);
    }

    private synchronized void removeTopicHandlerFromMap(String topic, HandlerHolder holder, Map<String, List<HandlerHolder>> map) {
        List<HandlerHolder> handlers = map.get(topic);
        if (handlers != null) {
            handlers.remove(holder);
            if (handlers.isEmpty()) {
                map.remove(topic);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";serviceReferenceMap=").append(this.serviceReferenceMap);
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.event.internal.TopicBasedCache", TopicBasedCache.class, (String)"EventEngine", null);
    }
}

