/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.logging;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.AbstractDelegatingLogger;

public final class LogUtils {
    private static final Object[] NO_PARAMETERS = new Object[0];
    private static Class<?> loggerClass;
    private static String loggerClassbackup;
    private static boolean loggerBackedUp;
    private static boolean loggerRestored;
    private static final String CXFLOGGERFAILED = "CXFLogger failed!";
    private static final TraceComponent tc;

    private LogUtils() {
    }

    public static void setLoggerClass(Class<? extends AbstractDelegatingLogger> cls) {
        loggerClass = cls;
    }

    public static Logger getLogger(Class<?> cls) {
        Logger logger = LogUtils.createLogger(cls, null, cls.getName() + LogUtils.getClassLoader(cls));
        return logger;
    }

    public static Logger getLogger(Class<?> cls, String resourcename) {
        Logger logger = LogUtils.createLogger(cls, resourcename, cls.getName() + LogUtils.getClassLoader(cls));
        return logger;
    }

    public static Logger getLogger(Class<?> cls, String resourcename, String loggerName) {
        Logger logger = LogUtils.createLogger(cls, resourcename, loggerName);
        return logger;
    }

    public static Logger getL7dLogger(Class<?> cls) {
        Logger logger = LogUtils.createLogger(cls, null, cls.getName() + LogUtils.getClassLoader(cls));
        return logger;
    }

    public static Logger getL7dLogger(Class<?> cls, String resourcename) {
        Logger logger = LogUtils.createLogger(cls, resourcename, cls.getName() + LogUtils.getClassLoader(cls));
        return logger;
    }

    public static Logger getL7dLogger(Class<?> cls, String resourcename, String loggerName) {
        Logger logger = LogUtils.createLogger(cls, resourcename, loggerName);
        return logger;
    }

    /*
     * Exception decompiling
     */
    @FFDCIgnore(value={MissingResourceException.class, IllegalArgumentException.class})
    protected static Logger createLogger(Class<?> cls, String name, String loggerName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK], 6[TRYBLOCK], 18[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setContextClassLoader(final ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        } else {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return cl;
                }
            });
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl;
    }

    private static ClassLoader getClassLoader(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable, Object parameter) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), parameter);
            LogUtils.doLog(logger, level, formattedMessage, throwable);
        }
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable, Object ... parameters) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), parameters);
            LogUtils.doLog(logger, level, formattedMessage, throwable);
        }
    }

    public static void log(Logger logger, Level level, String message) {
        LogUtils.log(logger, level, message, NO_PARAMETERS);
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable) {
        LogUtils.log(logger, level, message, throwable, NO_PARAMETERS);
    }

    public static void log(Logger logger, Level level, String message, Object parameter) {
        LogUtils.log(logger, level, message, new Object[]{parameter});
    }

    public static void log(Logger logger, Level level, String message, Object[] parameters) {
        if (logger.isLoggable(level)) {
            String msg = LogUtils.localize(logger, message);
            try {
                msg = MessageFormat.format(msg, parameters);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            LogUtils.doLog(logger, level, msg, null);
        }
    }

    private static void doLog(Logger log, Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(log.getName());
        record.setResourceBundleName(log.getResourceBundleName());
        record.setResourceBundle(log.getResourceBundle());
        if (t != null) {
            record.setThrown(t);
        }
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String cname = LogUtils.class.getName();
        for (int x = 0; x < stack.length; ++x) {
            StackTraceElement frame = stack[x];
            if (frame.getClassName().equals(cname)) continue;
            record.setSourceClassName(frame.getClassName());
            record.setSourceMethodName(frame.getMethodName());
            break;
        }
        log.log(record);
    }

    private static String localize(Logger logger, String message) {
        String newMsg = "";
        ResourceBundle bundle = logger.getResourceBundle();
        try {
            newMsg = bundle != null ? bundle.getString(message) : message;
        }
        catch (MissingResourceException ex) {
            newMsg = message;
        }
        return newMsg;
    }

    private static void backupLoggerClass(Class<?> originalCls, Class<?> newCls) {
        if (!LogUtils.isLoggerBackedUp()) {
            LogUtils.setLoggerClassbackup(LogUtils.getLoggerClass() != null ? LogUtils.getLoggerClass().getName() : null);
            loggerClass = newCls;
            LogUtils.setLoggerBackedUp(true);
        }
    }

    private static boolean restoreLoggerClass() {
        if (LogUtils.isLoggerRestored()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Logger is restored once already. Returning.", (Object[])new Object[0]);
            }
            return true;
        }
        if (LogUtils.getLoggerClassbackup() == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"loggerClassbackup is not found. Returning.", (Object[])new Object[0]);
            }
            return false;
        }
        if (!LogUtils.isLoggerBackedUp()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"loggerClass is not backed up. Returning.", (Object[])new Object[0]);
            }
            return false;
        }
        try {
            loggerClass = Class.forName(LogUtils.getLoggerClassbackup());
            LogUtils.setLoggerClassbackup(null);
            return true;
        }
        catch (ClassNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception restoring backup logger class: " + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
    }

    private static void throwFallBackToOriginalLoggerException() throws Exception {
        throw new Exception(CXFLOGGERFAILED);
    }

    private static String getLoggerClassbackup() {
        return loggerClassbackup;
    }

    private static void setLoggerClassbackup(String loggerClassbackup) {
        LogUtils.loggerClassbackup = loggerClassbackup;
    }

    private static boolean isLoggerBackedUp() {
        return loggerBackedUp;
    }

    private static void setLoggerBackedUp(boolean isLoggerBackedUp) {
        loggerBackedUp = isLoggerBackedUp;
    }

    private static boolean isLoggerRestored() {
        return loggerRestored;
    }

    private static void setLoggerRestored(boolean isLoggerRestored) {
        loggerRestored = isLoggerRestored;
    }

    private static Class<?> getLoggerClass() {
        return loggerClass;
    }

    static {
        loggerBackedUp = false;
        loggerRestored = false;
        tc = Tr.register(LogUtils.class);
    }
}

