/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.IdAllocatorException;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ShortIdAllocator {
    private static String CLASS_NAME = ShortIdAllocator.class.getName();
    private static final TraceComponent tc = SibTr.register(ShortIdAllocator.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final short NULL_ID = -1;
    private static final short MAX_SHORT_ID = Short.MAX_VALUE;
    private short maxId = Short.MAX_VALUE;
    private boolean allowZero = false;
    private short nextId = (short)-1;
    private short lastFreeId = (short)-1;
    private byte[] allocMap = null;

    public ShortIdAllocator(boolean allowZero) {
        this(allowZero, Short.MAX_VALUE);
    }

    public ShortIdAllocator(boolean allowZero, short maxValueToAllocate) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{"" + allowZero, "" + maxValueToAllocate});
        }
        if (maxValueToAllocate < 0) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INVALID_MAX_VALUE_SICO1058", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".<init>"), (String)"2-013-0001", (Object)this);
            throw e;
        }
        this.allowZero = allowZero;
        this.maxId = maxValueToAllocate;
        this.allocMap = new byte[(this.maxId + 1) / 8];
        this.nextId = allowZero ? (short)0 : 1;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public synchronized short allocateId() throws IdAllocatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"allocateId");
        }
        int nextAllocatedId = -1;
        if (this.lastFreeId != -1) {
            nextAllocatedId = this.lastFreeId;
            this.lastFreeId = (short)-1;
        } else if (this.nextId != -1) {
            nextAllocatedId = this.nextId;
            this.nextId = this.nextId == this.maxId ? (short)-1 : (short)(this.nextId + 1);
        } else {
            for (int x = 0; x < this.allocMap.length; x = (int)((short)(x + 1))) {
                byte oneByte = this.allocMap[x];
                if (oneByte != -1) {
                    if ((oneByte & 0x80) == 0) {
                        nextAllocatedId = (short)((x + 1) * 8 - 1);
                        continue;
                    }
                    if ((oneByte & 0x40) == 0) {
                        nextAllocatedId = (short)((x + 1) * 8 - 2);
                        continue;
                    }
                    if ((oneByte & 0x20) == 0) {
                        nextAllocatedId = (short)((x + 1) * 8 - 3);
                        continue;
                    }
                    if ((oneByte & 0x10) == 0) {
                        nextAllocatedId = (short)((x + 1) * 8 - 4);
                        continue;
                    }
                    if ((oneByte & 8) == 0) {
                        nextAllocatedId = (short)((x + 1) * 8 - 5);
                        continue;
                    }
                    if ((oneByte & 4) == 0) {
                        nextAllocatedId = (short)((x + 1) * 8 - 6);
                        continue;
                    }
                    if ((oneByte & 2) == 0) {
                        nextAllocatedId = (short)((x + 1) * 8 - 7);
                        continue;
                    }
                    if ((oneByte & 1) != 0 || (nextAllocatedId = (short)((x + 1) * 8 - 8)) != 0 || this.allowZero) continue;
                    nextAllocatedId = -1;
                    continue;
                }
                if (nextAllocatedId != -1) break;
            }
        }
        if (nextAllocatedId == -1) {
            throw new IdAllocatorException();
        }
        this.allocate((short)nextAllocatedId);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"allocateId", (Object)("" + this.nextId));
        }
        return (short)nextAllocatedId;
    }

    public synchronized void releaseId(short id) throws IdAllocatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"releaseId", (Object)("" + id));
        }
        this.deallocate(id);
        if (id == this.nextId - 1) {
            this.nextId = id;
            if (this.nextId == this.lastFreeId) {
                this.lastFreeId = (short)-1;
            }
        } else {
            this.lastFreeId = id;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"releaseId");
        }
    }

    private void allocate(short id) throws IdAllocatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"allocate", (Object)("" + id));
        }
        int bitToSet = id % 8 + 1;
        int allocMapPos = (int)Math.floor((float)id / 8.0f);
        byte currentMapSetting = this.allocMap[allocMapPos];
        if (bitToSet == 1) {
            if ((currentMapSetting & 1) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 1);
        } else if (bitToSet == 2) {
            if ((currentMapSetting & 2) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 2);
        } else if (bitToSet == 3) {
            if ((currentMapSetting & 4) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 4);
        } else if (bitToSet == 4) {
            if ((currentMapSetting & 8) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 8);
        } else if (bitToSet == 5) {
            if ((currentMapSetting & 0x10) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 0x10);
        } else if (bitToSet == 6) {
            if ((currentMapSetting & 0x20) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 0x20);
        } else if (bitToSet == 7) {
            if ((currentMapSetting & 0x40) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 0x40);
        } else if (bitToSet == 8) {
            if ((currentMapSetting & 0x80) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 0x80);
        }
        this.allocMap[allocMapPos] = currentMapSetting;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"allocate");
        }
    }

    private void deallocate(short id) throws IdAllocatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deallocate", (Object)("" + id));
        }
        int bitToSet = id % 8 + 1;
        int allocMapPos = (int)Math.floor((float)id / 8.0f);
        byte currentMapSetting = this.allocMap[allocMapPos];
        currentMapSetting = (byte)(currentMapSetting ^ 0xFF);
        if (bitToSet == 1) {
            if ((currentMapSetting & 1) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 1);
        } else if (bitToSet == 2) {
            if ((currentMapSetting & 2) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 2);
        } else if (bitToSet == 3) {
            if ((currentMapSetting & 4) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 4);
        } else if (bitToSet == 4) {
            if ((currentMapSetting & 8) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 8);
        } else if (bitToSet == 5) {
            if ((currentMapSetting & 0x10) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 0x10);
        } else if (bitToSet == 6) {
            if ((currentMapSetting & 0x20) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 0x20);
        } else if (bitToSet == 7) {
            if ((currentMapSetting & 0x40) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 0x40);
        } else if (bitToSet == 8) {
            if ((currentMapSetting & 0x80) != 0) {
                throw new IdAllocatorException();
            }
            currentMapSetting = (byte)(currentMapSetting | 0x80);
        }
        this.allocMap[allocMapPos] = (byte)(currentMapSetting ^ 0xFF);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deallocate");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/impl/ShortIdAllocator.java, SIB.comms, WASX.SIB, uu1215.01 1.11");
        }
    }
}

