/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class WeakValueHashMap
extends HashMap {
    private static final long serialVersionUID = -1200413598564584640L;
    private final ReferenceQueue queue = new ReferenceQueue();

    private final void clearUnreferencedEntries() {
        WeakEntry entry = (WeakEntry)this.queue.poll();
        while (entry != null) {
            WeakEntry removedEntry = (WeakEntry)super.remove(entry.key);
            if (removedEntry != entry) {
                super.put(entry.key, removedEntry);
            }
            entry = (WeakEntry)this.queue.poll();
        }
    }

    @Override
    public final int size() {
        this.clearUnreferencedEntries();
        return super.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final Object get(Object key) {
        this.clearUnreferencedEntries();
        WeakEntry weakEntry = (WeakEntry)super.get(key);
        if (weakEntry == null) {
            return null;
        }
        return weakEntry.get();
    }

    @Override
    public final Object put(Object key, Object value) {
        this.clearUnreferencedEntries();
        WeakEntry weakEntry = super.put(key, new WeakEntry(key, value));
        Object existingValue = null;
        if (weakEntry != null) {
            existingValue = weakEntry.get();
            weakEntry.clear();
        }
        return existingValue;
    }

    @Override
    public final Object remove(Object key) {
        WeakEntry weakEntry = (WeakEntry)super.remove(key);
        Object value = null;
        if (weakEntry != null) {
            value = weakEntry.get();
            weakEntry.clear();
        }
        this.clearUnreferencedEntries();
        return value;
    }

    @Override
    public final void clear() {
        while (this.queue.poll() != null) {
        }
        super.clear();
    }

    private final class WeakEntry
    extends WeakReference {
        private Object key;

        WeakEntry(Object key, Object value) {
            super(value, WeakValueHashMap.this.queue);
            this.key = key;
        }
    }
}

