/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.jose4j;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.plugins.jose4j.JWTData;
import com.ibm.ws.security.oauth20.plugins.jose4j.JWTTokenException;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwsSigner {
    private static TraceComponent tc = Tr.register(JwsSigner.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    static final long serialVersionUID = 4598014343786902075L;

    @FFDCIgnore(value={Exception.class})
    public static String getSignedJwt(JwtClaims claims, OidcServerConfig oidcServerConfig, JWTData jwtData) throws JWTTokenException {
        String typ;
        String jwt = null;
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        Key key = jwtData.getSigningKey();
        if (key == null && !"none".equals(jwtData.getSignatureAlgorithm())) {
            throw jwtData.getNoKeyException();
        }
        jws.setKey(key);
        String keyId = jwtData.getKeyID();
        if (keyId != null) {
            jws.setKeyIdHeaderValue(keyId);
        }
        if ((typ = jwtData.getTypHeader()) != null) {
            jws.setHeader("typ", typ);
        }
        jws.setAlgorithmHeaderValue(oidcServerConfig.getSignatureAlgorithm());
        jws.setDoKeyValidation(false);
        Object token = ThreadIdentityManager.runAsServer();
        try {
            jwt = jws.getCompactSerialization();
        }
        catch (Exception e) {
            Object[] objs = new Object[]{oidcServerConfig.getProviderId(), e.getLocalizedMessage()};
            Tr.error((TraceComponent)tc, (String)"JWT_CANNOT_GENERATE_JWT", (Object[])objs);
            throw new JWTTokenException(Tr.formatMessage((TraceComponent)tc, (String)"JWT_CANNOT_GENERATE_JWT", (Object[])objs), e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JWT=", (Object[])new Object[]{jwt});
        }
        return jwt;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -1632085777342507419L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.setProperty("org.jose4j.jws.default-allow-none", "true");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.plugins.jose4j.JwsSigner$1", 1.class, null, null);
            }
        });
    }
}

