/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.granttype.impl;

import com.ibm.oauth.core.api.attributes.Attribute;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.InvalidGrantException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandler;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OAuth20GrantTypeHandlerAppTokenAndPasswordImpl
implements OAuth20GrantTypeHandler {
    static final String CLASS = OAuth20GrantTypeHandlerAppTokenAndPasswordImpl.class.getName();
    private static Logger _log = Logger.getLogger(CLASS);
    static final ArrayList<String> _emptyList = new ArrayList();
    String grant_type;
    OAuth20Provider oauth20Config;

    public OAuth20GrantTypeHandlerAppTokenAndPasswordImpl(String gt, OAuth20Provider config) {
        this.grant_type = gt;
        this.oauth20Config = config;
    }

    @Override
    public List<String> getKeysGrantType(@Sensitive AttributeList attributeList) throws OAuthException {
        return _emptyList;
    }

    @Override
    @FFDCIgnore(value={InvalidGrantException.class})
    public void validateRequestGrantType(@Sensitive AttributeList attributeList, List<OAuth20Token> tokens) throws OAuthException {
        String methodName = "validateRequestGrantType";
        boolean finestLoggable = _log.isLoggable(Level.FINEST);
        _log.entering(CLASS, methodName);
        if (finestLoggable) {
            List<Attribute> attributes = attributeList.getAllAttributes();
            for (Attribute attribute : attributes) {
                _log.logp(Level.FINEST, CLASS, methodName, "attrib: " + attribute.getName() + " :" + attribute.toString());
            }
        }
        String clientId = attributeList.getAttributeValueByName("client_id");
        String client_secret = attributeList.getAttributeValueByName("client_secret");
        OidcServerConfig oidcServerConfig = this.getOidcServerConfig(attributeList);
        String tokenString = this.getTokenString(attributeList);
        try {
            this.verifyAccessToken(tokenString);
        }
        catch (InvalidGrantException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.isEmpty()) {
                message = e.toString();
            }
            throw new InvalidGrantException(message, e);
        }
    }

    private boolean verifyAccessToken(String tokenString) throws InvalidGrantException {
        return true;
    }

    @Override
    public List<OAuth20Token> buildTokensGrantType(AttributeList attributeList, OAuth20TokenFactory tokenFactory, List<OAuth20Token> tokens) {
        String methodName = "buildTokensGrantType";
        boolean finestLoggable = _log.isLoggable(Level.FINEST);
        ArrayList<OAuth20Token> tokenList = new ArrayList<OAuth20Token>();
        String clientId = attributeList.getAttributeValueByName("client_id");
        String username = attributeList.getAttributeValueByName("username");
        String[] scope = attributeList.getAttributeValuesByNameAndType("scope", "urn:ibm:names:oauth:param:request");
        String stateId = null;
        if ("app_password".equals(this.grant_type)) {
            stateId = "iamapppasswordstateid";
        } else if ("app_token".equals(this.grant_type)) {
            stateId = "iamapptokenstateid";
        }
        String[] redirectUris = attributeList.getAttributeValuesByNameAndType("redirect_uri", "urn:ibm:names:oauth:param");
        String redirectUri = redirectUris == null ? null : (redirectUris.length > 0 ? redirectUris[0] : null);
        Map<String, String[]> accessTokenMap = tokenFactory.buildTokenMap(clientId, username, redirectUri, stateId, scope, null, this.grant_type);
        if (this.oauth20Config != null) {
            String appid = OAuth20Util.getRandom(this.oauth20Config.getAccessTokenLength());
            String key = "com.ibm.wsspi.security.oidc.external.claims:app_id";
            accessTokenMap.put(key, new String[]{appid});
            if ("app_password".equals(this.grant_type)) {
                accessTokenMap.put("LIFETIME", new String[]{"" + this.oauth20Config.getAppPasswordLifetime()});
            } else {
                accessTokenMap.put("LIFETIME", new String[]{"" + this.oauth20Config.getAppTokenLifetime()});
            }
        }
        OAuth20Util.populateJwtAccessTokenData(attributeList, accessTokenMap);
        String proxy = attributeList.getAttributeValueByName("X-Forwarded-Host");
        accessTokenMap.put("X-Forwarded-Host", new String[]{proxy});
        OAuth20TokenHelper.getExternalClaims(accessTokenMap, attributeList);
        OAuth20Token access = tokenFactory.createAccessTokenAsAppPasswordOrToken(accessTokenMap);
        if (finestLoggable) {
            _log.logp(Level.FINEST, CLASS, methodName, "access token is " + access);
        }
        if (access != null) {
            tokenList.add(access);
        }
        return tokenList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildResponseGrantType(AttributeList attributeList, List<OAuth20Token> tokens) {
        String methodName = "buildResponseGrantType";
        boolean finestLoggable = _log.isLoggable(Level.FINEST);
        try {
            for (OAuth20Token token : tokens) {
                String strTokenType = token.getType();
                if ("access_token".equals(strTokenType)) {
                    this.handleAccessToken(attributeList, token);
                    continue;
                }
                _log.logp(Level.FINEST, CLASS, methodName, "Unknown token type:'" + strTokenType + "'");
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }

    public void handleAccessToken(AttributeList attributeList, OAuth20Token token) {
        String accessToken = token.getTokenString();
        attributeList.setAttribute(this.grant_type, "urn:ibm:names:oauth:response:attribute", new String[]{accessToken});
        String[] id = token.getExtensionProperty("com.ibm.wsspi.security.oidc.external.claims:app_id");
        attributeList.setAttribute("app_id", "urn:ibm:names:oauth:response:attribute", new String[]{id[0]});
        String created = "" + token.getCreatedAt();
        attributeList.setAttribute("created_at", "urn:ibm:names:oauth:response:attribute", new String[]{created});
        long expiresAt = token.getCreatedAt() + (long)token.getLifetimeSeconds() * 1000L;
        String expires = "" + expiresAt;
        attributeList.setAttribute("expires_at", "urn:ibm:names:oauth:response:attribute", new String[]{expires});
    }

    protected String convertToString(String[] scopes) {
        StringBuffer st = new StringBuffer("");
        boolean bFirst = true;
        for (String scope : scopes) {
            if (!bFirst) {
                st.append(" ");
            }
            st.append(scope);
            bFirst = false;
        }
        return st.toString();
    }

    protected void verifyJwtSub(String user) throws OAuth20Exception {
        if (user == null) {
            throw new InvalidGrantException("JWT_TOKEN_MISS_REQUIRED_CLAIM_ERR", null);
        }
    }

    public String getString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof String[]) {
            String[] strings = (String[])obj;
            if (strings.length > 0) {
                return strings[0];
            }
            return null;
        }
        return obj.toString();
    }

    protected OidcServerConfig getOidcServerConfig(AttributeList attributeList) throws OAuthException {
        OidcServerConfig oidcServerConfig = null;
        String requestType = attributeList.getAttributeValueByName("request_feature");
        if ("oauth2".equals(requestType)) {
            return null;
        }
        return oidcServerConfig;
    }

    protected String getTokenString(AttributeList attributeList) throws OAuthException {
        String tokenString = null;
        String ACCESS_TOKEN = "access_token";
        String[] tokenStrings = attributeList.getAttributeValuesByName(ACCESS_TOKEN);
        if (tokenStrings == null || tokenStrings.length < 1 || tokenStrings[0].isEmpty()) {
            throw new InvalidGrantException("JWT_TOKEN_NO_TOKEN_EXTERNAL_ERR", null);
        }
        if (tokenStrings.length > 1) {
            throw new InvalidGrantException("JWT_TOKEN_TOO_MANY_TOKENS_ERR", null);
        }
        tokenString = tokenStrings[0];
        return tokenString;
    }

    protected String[] getStrings(Object obj) {
        if (obj == null || obj instanceof String[]) {
            return (String[])obj;
        }
        if (obj instanceof String) {
            return new String[]{(String)obj};
        }
        if (obj instanceof List) {
            List list = (List)obj;
            String[] result = new String[list.size()];
            int iCnt = 0;
            for (Object aObj : list) {
                result[iCnt++] = aObj.toString();
            }
            return result;
        }
        if (obj instanceof Object) {
            return new String[]{obj.toString()};
        }
        return new String[0];
    }
}

