/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.PasswordEncryptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandler;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class AbstractWSS4JInterceptor
extends WSHandler
implements SoapInterceptor,
PhaseInterceptor<SoapMessage> {
    private static final Set<QName> HEADERS = new HashSet<QName>();
    private Map<String, Object> properties;
    private final Set<String> before;
    private final Set<String> after;
    private String phase;
    private String id;
    private static final Logger LOG;
    static final long serialVersionUID = -7649328916743231109L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractWSS4JInterceptor() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "<init>", new Object[0]);
        }
        this.properties = new ConcurrentHashMap<String, Object>();
        this.before = new HashSet<String>();
        this.after = new HashSet<String>();
        this.id = ((Object)((Object)this)).getClass().getName();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<URI> getRoles() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getRoles", new Object[0]);
        }
        Set<URI> set = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getRoles", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleFault(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "handleFault", new Object[]{message});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "handleFault");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void postHandleMessage(SoapMessage message) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "postHandleMessage", new Object[]{message});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "postHandleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getAdditionalInterceptors", new Object[0]);
        }
        Collection<PhaseInterceptor<? extends Message>> collection = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            collection = collection;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getAdditionalInterceptors", collection);
        }
        return collection;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPhase() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getPhase", new Object[0]);
        }
        String string = this.phase;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getPhase", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setPhase(String phase) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setPhase", new Object[]{phase});
        }
        this.phase = phase;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setPhase");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getOption(String key) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getOption", new Object[]{key});
        }
        Object object = this.properties.get(key);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getOption", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProperty(String key, String value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setProperty", new Object[]{key, value});
        }
        this.properties.put(key, value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setProperty");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPassword(Object msgContext) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getPassword", new Object[]{msgContext});
        }
        String string = (String)((Message)msgContext).getContextualProperty("password");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getPassword", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getProperty(Object msgContext, String key) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getProperty", new Object[]{msgContext, key});
        }
        if (msgContext == null) {
            Object v0 = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                v0 = v0;
                LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getProperty", v0);
            }
            return v0;
        }
        Object obj = SecurityUtils.getSecurityPropertyValue((String)key, (Message)((Message)msgContext));
        if (obj == null) {
            obj = this.getOption(key);
        }
        Object object = obj;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getProperty", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setPassword(Object msgContext, String password) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setPassword", new Object[]{msgContext, password});
        }
        ((Message)msgContext).put((Object)"password", (Object)password);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setPassword");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProperty(Object msgContext, String key, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setProperty", new Object[]{msgContext, key, value});
        }
        ((Message)msgContext).put((Object)key, value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setProperty");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getId() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getId", new Object[0]);
        }
        String string = this.id;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getId", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setId(String id) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setId", new Object[]{id});
        }
        this.id = id;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setId");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<QName> getUnderstoodHeaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getUnderstoodHeaders", new Object[0]);
        }
        Set<QName> set = HEADERS;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getUnderstoodHeaders", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getProperties", new Object[0]);
        }
        Map<String, Object> map = this.properties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getProperties", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProperties(Map<String, Object> properties) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setProperties", new Object[]{properties});
        }
        this.properties = properties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "setProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getAfter() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getAfter", new Object[0]);
        }
        Set<String> set = this.after;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getAfter", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getBefore() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getBefore", new Object[0]);
        }
        Set<String> set = this.before;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "getBefore", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isRequestor(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "isRequestor", new Object[]{message});
        }
        boolean bl = MessageUtils.isRequestor((Message)message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "isRequestor", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void translateProperties(SoapMessage msg) {
        String mustunderstand;
        String certConstraintsSeparator;
        String certConstraints;
        String utTTL;
        String utFutureTTL;
        String ttl;
        String futureTTL;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "translateProperties", new Object[]{msg});
        }
        String bspCompliant = (String)msg.getContextualProperty("ws-security.is-bsp-compliant");
        if (bspCompliant != null) {
            msg.put((Object)"isBSPCompliant", (Object)bspCompliant);
        }
        if ((futureTTL = (String)msg.getContextualProperty("ws-security.timestamp.futureTimeToLive")) != null) {
            msg.put((Object)"futureTimeToLive", (Object)futureTTL);
        }
        if ((ttl = (String)msg.getContextualProperty("ws-security.timestamp.timeToLive")) != null) {
            msg.put((Object)"timeToLive", (Object)ttl);
        }
        if ((utFutureTTL = (String)msg.getContextualProperty("ws-security.usernametoken.futureTimeToLive")) != null) {
            msg.put((Object)"utFutureTimeToLive", (Object)utFutureTTL);
        }
        if ((utTTL = (String)msg.getContextualProperty("ws-security.usernametoken.timeToLive")) != null) {
            msg.put((Object)"utTimeToLive", (Object)utTTL);
        }
        if ((certConstraints = (String)SecurityUtils.getSecurityPropertyValue((String)"security.subject.cert.constraints", (Message)msg)) != null) {
            msg.put((Object)"sigSubjectCertConstraints", (Object)certConstraints);
        }
        if ((certConstraintsSeparator = (String)SecurityUtils.getSecurityPropertyValue((String)"security.cert.constraints.separator", (Message)msg)) != null && !certConstraintsSeparator.isEmpty()) {
            msg.put((Object)"sigCertConstraintsSeparator", (Object)certConstraintsSeparator);
        }
        String valSAMLSubjectConf = (String)SecurityUtils.getSecurityPropertyValue((String)"security.validate.saml.subject.conf", (Message)msg);
        boolean validateSAMLSubjectConf = true;
        if (valSAMLSubjectConf != null) {
            validateSAMLSubjectConf = Boolean.parseBoolean(valSAMLSubjectConf);
        }
        msg.put((Object)"validateSamlSubjectConfirmation", (Object)Boolean.toString(validateSAMLSubjectConf));
        PasswordEncryptor passwordEncryptor = (PasswordEncryptor)msg.getContextualProperty("ws-security.password.encryptor.instance");
        if (passwordEncryptor != null) {
            msg.put((Object)"passwordEncryptorInstance", (Object)passwordEncryptor);
        }
        if ((mustunderstand = (String)msg.getContextualProperty("ws-security.must-understand")) != null && !mustunderstand.isEmpty()) {
            msg.put((Object)"mustUnderstand", (Object)mustunderstand);
            boolean doDebug = LOG.isLoggable(Level.FINE);
            if (doDebug) {
                LOG.fine("AbstractWSS4JInterceptor: OLGH23255 - mustUnderstand is set = " + mustunderstand);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "translateProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Crypto loadCryptoFromPropertiesFile(String propFilename, RequestData reqData) throws WSSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "loadCryptoFromPropertiesFile", new Object[]{propFilename, reqData});
        }
        Message message = (Message)reqData.getMsgContext();
        ClassLoader classLoader = this.getClassLoader();
        PasswordEncryptor passwordEncryptor = this.getPasswordEncryptor(reqData);
        Crypto crypto = WSS4JUtils.loadCryptoFromPropertiesFile(message, propFilename, classLoader, passwordEncryptor);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            crypto = crypto;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor", "loadCryptoFromPropertiesFile", crypto);
        }
        return crypto;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        HEADERS.add(new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"));
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "EncryptedHeader"));
        LOG = LogUtils.getL7dLogger(AbstractWSS4JInterceptor.class);
    }
}

