/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser;

import com.ibm.ws.jain.protocol.ip.sip.extensions.AlertInfoHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.CallInfoHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.ContentDispositionHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.ContentLanguageHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.ErrorInfoHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.IbmRetransmissionIntervalHeader;
import com.ibm.ws.jain.protocol.ip.sip.extensions.IbmRetransmissionMaxIntervalHeader;
import com.ibm.ws.jain.protocol.ip.sip.extensions.IbmTransactionTimeoutHeader;
import com.ibm.ws.jain.protocol.ip.sip.extensions.InReplyToHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.JoinHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.MimeVersionHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.PAssertedIdentityHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.PPreferredIdentityHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.PathHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.RAckHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.RSeqHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.ReferToHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.ReplacesHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.SupportedHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.simple.AllowEventsHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.simple.EventHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.simple.SubscriptionStateHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.AcceptEncodingHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.AcceptHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.AcceptLanguageHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.AllowHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.AuthorizationHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.CSeqHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.CallIdHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ContactHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ContentEncodingHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ContentLengthHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ContentTypeHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.DateHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.EncryptionHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ExpiresHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ExtendedHeader;
import com.ibm.ws.jain.protocol.ip.sip.header.FromHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.HideHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.MaxForwardsHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.OrganizationHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.PriorityHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ProxyAuthenticateHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ProxyAuthorizationHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ProxyRequireHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.RecordRouteHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.RequireHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ResponseKeyHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.RetryAfterHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.RouteHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ServerHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.SubjectHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.TimeStampHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ToHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.UnsupportedHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.UserAgentHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ViaHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.WWWAuthenticateHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.WarningHeaderImpl;

public class HeaderCreator {
    public static HeaderImpl createHeader(String name) {
        if (name.length() == 1) {
            return HeaderCreator.createShortNameHeader(name);
        }
        char firstChar = name.charAt(0);
        switch (firstChar) {
            case 'C': 
            case 'c': {
                return HeaderCreator.createCHeader(name);
            }
            case 'E': 
            case 'e': {
                return HeaderCreator.createEHeader(name);
            }
            case 'F': 
            case 'f': {
                if (!name.equalsIgnoreCase("From")) break;
                return new FromHeaderImpl();
            }
            case 'J': 
            case 'j': {
                if (!name.equalsIgnoreCase("Join")) break;
                return new JoinHeaderImpl();
            }
            case 'S': 
            case 's': {
                return HeaderCreator.createSHeader(name);
            }
            case 'T': 
            case 't': {
                if (name.equalsIgnoreCase("To")) {
                    return new ToHeaderImpl();
                }
                if (!name.equalsIgnoreCase("Timestamp")) break;
                return new TimeStampHeaderImpl();
            }
            case 'V': 
            case 'v': {
                if (!name.equalsIgnoreCase("Via")) break;
                return new ViaHeaderImpl();
            }
            case 'P': 
            case 'p': {
                return HeaderCreator.createPHeader(name);
            }
            case 'U': 
            case 'u': {
                if (name.equalsIgnoreCase("User-Agent")) {
                    return new UserAgentHeaderImpl();
                }
                if (!name.equalsIgnoreCase("Unsupported")) break;
                return new UnsupportedHeaderImpl();
            }
            case 'A': 
            case 'a': {
                return HeaderCreator.createAHeader(name);
            }
            case 'R': 
            case 'r': {
                return HeaderCreator.createRHeader(name);
            }
            case 'W': 
            case 'w': {
                if (name.equalsIgnoreCase("WWW-Authenticate")) {
                    return new WWWAuthenticateHeaderImpl();
                }
                if (!name.equalsIgnoreCase("Warning")) break;
                return new WarningHeaderImpl();
            }
            case 'I': 
            case 'i': {
                return HeaderCreator.createIHeader(name);
            }
            case 'O': 
            case 'o': {
                if (!name.equalsIgnoreCase("Organization")) break;
                return new OrganizationHeaderImpl();
            }
            case 'H': 
            case 'h': {
                if (!name.equalsIgnoreCase("Hide")) break;
                return new HideHeaderImpl();
            }
            case 'M': 
            case 'm': {
                if (name.equalsIgnoreCase("Max-Forwards")) {
                    return new MaxForwardsHeaderImpl();
                }
                if (!name.equalsIgnoreCase("Mime-Version")) break;
                return new MimeVersionHeaderImpl();
            }
            case 'D': 
            case 'd': {
                if (!name.equalsIgnoreCase("Date")) break;
                return new DateHeaderImpl();
            }
        }
        return new ExtendedHeader(name);
    }

    private static HeaderImpl createCHeader(String name) {
        switch (name.charAt(1)) {
            case 'O': 
            case 'o': {
                if (name.equalsIgnoreCase("Contact")) {
                    return new ContactHeaderImpl();
                }
                if (name.equalsIgnoreCase("Content-Type")) {
                    return new ContentTypeHeaderImpl();
                }
                if (name.equalsIgnoreCase("Content-Disposition")) {
                    return new ContentDispositionHeaderImpl();
                }
                if (name.equalsIgnoreCase("Content-Language")) {
                    return new ContentLanguageHeaderImpl();
                }
                if (name.equalsIgnoreCase("Content-Encoding")) {
                    return new ContentEncodingHeaderImpl();
                }
                if (!name.equalsIgnoreCase("Content-Length")) break;
                return new ContentLengthHeaderImpl();
            }
            case 'A': 
            case 'a': {
                if (name.equalsIgnoreCase("Call-Info")) {
                    return new CallInfoHeaderImpl();
                }
                if (!name.equalsIgnoreCase("Call-ID")) break;
                return new CallIdHeaderImpl();
            }
            case 'S': 
            case 's': {
                if (!name.equalsIgnoreCase("CSeq")) break;
                return new CSeqHeaderImpl();
            }
        }
        return new ExtendedHeader(name);
    }

    private static HeaderImpl createAHeader(String name) {
        switch (name.charAt(1)) {
            case 'L': 
            case 'l': {
                if (name.equalsIgnoreCase("Allow-Events")) {
                    return new AllowEventsHeaderImpl();
                }
                if (name.equalsIgnoreCase("Allow")) {
                    return new AllowHeaderImpl();
                }
                if (!name.equalsIgnoreCase("Alert-Info")) break;
                return new AlertInfoHeaderImpl();
            }
            case 'C': 
            case 'c': {
                if (name.equalsIgnoreCase("Accept")) {
                    return new AcceptHeaderImpl();
                }
                if (name.equalsIgnoreCase("Accept-Encoding")) {
                    return new AcceptEncodingHeaderImpl();
                }
                if (!name.equalsIgnoreCase("Accept-Language")) break;
                return new AcceptLanguageHeaderImpl();
            }
            case 'U': 
            case 'u': {
                if (!name.equalsIgnoreCase("Authorization")) break;
                return new AuthorizationHeaderImpl();
            }
        }
        return new ExtendedHeader(name);
    }

    private static HeaderImpl createSHeader(String name) {
        switch (name.charAt(1)) {
            case 'U': 
            case 'u': {
                if (name.equalsIgnoreCase("Supported")) {
                    return new SupportedHeaderImpl();
                }
                if (name.equalsIgnoreCase("Subject")) {
                    return new SubjectHeaderImpl();
                }
                if (!name.equalsIgnoreCase("Subscription-State")) break;
                return new SubscriptionStateHeaderImpl();
            }
            case 'E': 
            case 'e': {
                if (!name.equalsIgnoreCase("Server")) break;
                return new ServerHeaderImpl();
            }
        }
        return new ExtendedHeader(name);
    }

    private static HeaderImpl createRHeader(String name) {
        switch (name.charAt(1)) {
            case 'E': 
            case 'e': {
                if (name.equalsIgnoreCase("Response-Key")) {
                    return new ResponseKeyHeaderImpl();
                }
                if (name.equalsIgnoreCase("Record-Route")) {
                    return new RecordRouteHeaderImpl();
                }
                if (name.equalsIgnoreCase("Require")) {
                    return new RequireHeaderImpl();
                }
                if (name.equalsIgnoreCase("Retry-After")) {
                    return new RetryAfterHeaderImpl();
                }
                if (name.equalsIgnoreCase("Replaces")) {
                    return new ReplacesHeaderImpl();
                }
                if (!name.equalsIgnoreCase("Refer-To")) break;
                return new ReferToHeaderImpl();
            }
            case 'O': 
            case 'o': {
                if (!name.equalsIgnoreCase("Route")) break;
                return new RouteHeaderImpl();
            }
            case 'A': 
            case 'a': {
                if (!name.equalsIgnoreCase("RAck")) break;
                return new RAckHeaderImpl();
            }
            case 'S': 
            case 's': {
                if (!name.equalsIgnoreCase("RSeq")) break;
                return new RSeqHeaderImpl();
            }
        }
        return new ExtendedHeader(name);
    }

    private static HeaderImpl createEHeader(String name) {
        switch (name.charAt(1)) {
            case 'X': 
            case 'x': {
                if (!name.equalsIgnoreCase("Expires")) break;
                return new ExpiresHeaderImpl();
            }
            case 'V': 
            case 'v': {
                if (!name.equalsIgnoreCase("Event")) break;
                return new EventHeaderImpl();
            }
            case 'N': 
            case 'n': {
                if (!name.equalsIgnoreCase("Encryption")) break;
                return new EncryptionHeaderImpl();
            }
            case 'R': 
            case 'r': {
                if (!name.equalsIgnoreCase("Error-Info")) break;
                return new ErrorInfoHeaderImpl();
            }
        }
        return new ExtendedHeader(name);
    }

    private static HeaderImpl createPHeader(String name) {
        switch (name.charAt(1)) {
            case 'A': 
            case 'a': {
                if (!name.equalsIgnoreCase("Path")) break;
                return new PathHeaderImpl();
            }
            case 'R': 
            case 'r': {
                if (name.length() < 3) break;
                switch (name.charAt(2)) {
                    case 'O': 
                    case 'o': {
                        if (name.equalsIgnoreCase("Proxy-Authorization")) {
                            return new ProxyAuthorizationHeaderImpl();
                        }
                        if (name.equalsIgnoreCase("Proxy-Authenticate")) {
                            return new ProxyAuthenticateHeaderImpl();
                        }
                        if (!name.equalsIgnoreCase("Proxy-Require")) break;
                        return new ProxyRequireHeaderImpl();
                    }
                    case 'I': 
                    case 'i': {
                        if (!name.equalsIgnoreCase("Priority")) break;
                        return new PriorityHeaderImpl();
                    }
                }
                break;
            }
            case '-': {
                if (name.equalsIgnoreCase("P-Asserted-Identity")) {
                    return new PAssertedIdentityHeaderImpl();
                }
                if (!name.equalsIgnoreCase("P-Preferred-Identity")) break;
                return new PPreferredIdentityHeaderImpl();
            }
        }
        return new ExtendedHeader(name);
    }

    private static HeaderImpl createIHeader(String name) {
        if (name.equalsIgnoreCase("In-Reply-To")) {
            return new InReplyToHeaderImpl();
        }
        if (name.equalsIgnoreCase("IBM-TransactionTimeout")) {
            return new IbmTransactionTimeoutHeader(true);
        }
        if (name.equalsIgnoreCase("IBM-RetransmissionInterval")) {
            return new IbmRetransmissionIntervalHeader(true);
        }
        if (name.equalsIgnoreCase("IBM-RetransmissionMaxInterval")) {
            return new IbmRetransmissionMaxIntervalHeader(true);
        }
        return new ExtendedHeader(name);
    }

    private static HeaderImpl createShortNameHeader(String name) {
        char first = name.charAt(0);
        switch (first) {
            case 'T': 
            case 't': {
                return new ToHeaderImpl(true);
            }
            case 'F': 
            case 'f': {
                return new FromHeaderImpl(true);
            }
            case 'I': 
            case 'i': {
                return new CallIdHeaderImpl(true);
            }
            case 'M': 
            case 'm': {
                return new ContactHeaderImpl(true);
            }
            case 'L': 
            case 'l': {
                return new ContentLengthHeaderImpl(true);
            }
            case 'V': 
            case 'v': {
                return new ViaHeaderImpl(true);
            }
            case 'E': 
            case 'e': {
                return new ContentEncodingHeaderImpl(true);
            }
            case 'C': 
            case 'c': {
                return new ContentTypeHeaderImpl(true);
            }
            case 'K': 
            case 'k': {
                return new SupportedHeaderImpl(true);
            }
            case 'S': 
            case 's': {
                return new SubjectHeaderImpl(true);
            }
            case 'O': 
            case 'o': {
                return new EventHeaderImpl(true);
            }
            case 'U': 
            case 'u': {
                return new AllowEventsHeaderImpl(true);
            }
            case 'R': 
            case 'r': {
                return new ReferToHeaderImpl(true);
            }
        }
        return new ExtendedHeader(name);
    }

    public static HeaderImpl createHeader(char[] name, int length) {
        if (length == 1) {
            return HeaderCreator.createShortNameHeader(name, length);
        }
        char firstChar = name[0];
        switch (firstChar) {
            case 'C': 
            case 'c': {
                return HeaderCreator.createCHeader(name, length);
            }
            case 'E': 
            case 'e': {
                return HeaderCreator.createEHeader(name, length);
            }
            case 'F': 
            case 'f': {
                if (length != 4 || name[1] != 'R' && name[1] != 'r' || name[2] != 'O' && name[2] != 'o' || name[3] != 'M' && name[3] != 'm') break;
                return new FromHeaderImpl();
            }
            case 'S': 
            case 's': {
                return HeaderCreator.createSHeader(name, length);
            }
            case 'T': 
            case 't': {
                if (length == 2 && (name[1] == 'O' || name[1] == 'o')) {
                    return new ToHeaderImpl();
                }
                if (length != 9 || name[1] != 'I' && name[1] != 'i' || name[2] != 'M' && name[2] != 'm' || name[3] != 'E' && name[3] != 'e' || name[4] != 'S' && name[4] != 's' || name[5] != 'T' && name[5] != 't' || name[6] != 'A' && name[6] != 'a' || name[7] != 'M' && name[7] != 'm' || name[8] != 'P' && name[8] != 'p') break;
                return new TimeStampHeaderImpl();
            }
            case 'V': 
            case 'v': {
                if (length != 3 || name[1] != 'I' && name[1] != 'i' || name[2] != 'A' && name[2] != 'a') break;
                return new ViaHeaderImpl();
            }
            case 'P': 
            case 'p': {
                return HeaderCreator.createPHeader(name, length);
            }
            case 'U': 
            case 'u': {
                if (!(length != 10 || name[1] != 'S' && name[1] != 's' || name[2] != 'E' && name[2] != 'e' || name[3] != 'R' && name[3] != 'r' || name[4] != '-' || name[5] != 'A' && name[5] != 'a' || name[6] != 'G' && name[6] != 'g' || name[7] != 'E' && name[7] != 'e' || name[8] != 'N' && name[8] != 'n' || name[9] != 'T' && name[9] != 't')) {
                    return new UserAgentHeaderImpl();
                }
                if (length != 11 || name[1] != 'N' && name[1] != 'n' || name[2] != 'S' && name[2] != 's' || name[3] != 'U' && name[3] != 'u' || name[4] != 'P' && name[4] != 'p' || name[5] != 'P' && name[5] != 'p' || name[6] != 'O' && name[6] != 'o' || name[7] != 'R' && name[7] != 'r' || name[8] != 'T' && name[8] != 't' || name[9] != 'E' && name[9] != 'e' || name[10] != 'D' && name[10] != 'd') break;
                return new UnsupportedHeaderImpl();
            }
            case 'A': 
            case 'a': {
                return HeaderCreator.createAHeader(name, length);
            }
            case 'R': 
            case 'r': {
                return HeaderCreator.createRHeader(name, length);
            }
            case 'W': 
            case 'w': {
                if (!(length != 16 || name[1] != 'W' && name[1] != 'w' || name[2] != 'W' && name[2] != 'w' || name[3] != '-' || name[4] != 'A' && name[4] != 'a' || name[5] != 'U' && name[5] != 'u' || name[6] != 'T' && name[6] != 't' || name[7] != 'H' && name[7] != 'h' || name[8] != 'E' && name[8] != 'e' || name[9] != 'N' && name[9] != 'n' || name[10] != 'T' && name[10] != 't' || name[11] != 'I' && name[11] != 'i' || name[12] != 'C' && name[12] != 'c' || name[13] != 'A' && name[13] != 'a' || name[14] != 'T' && name[14] != 't' || name[15] != 'E' && name[15] != 'e')) {
                    return new WWWAuthenticateHeaderImpl();
                }
                if (length != 7 || name[1] != 'A' && name[1] != 'a' || name[2] != 'R' && name[2] != 'r' || name[3] != 'N' && name[3] != 'n' || name[4] != 'I' && name[4] != 'i' || name[5] != 'N' && name[5] != 'n' || name[6] != 'G' && name[6] != 'g') break;
                return new WarningHeaderImpl();
            }
            case 'I': 
            case 'i': {
                return HeaderCreator.createIHeader(name, length);
            }
            case 'J': 
            case 'j': {
                if (!(length != 4 || name[1] != 'O' && name[1] != 'o' || name[2] != 'I' && name[2] != 'i' || name[3] != 'N' && name[3] != 'n')) {
                    return new JoinHeaderImpl();
                }
            }
            case 'O': 
            case 'o': {
                if (length != 12 || name[1] != 'R' && name[1] != 'r' || name[2] != 'G' && name[2] != 'g' || name[3] != 'A' && name[3] != 'a' || name[4] != 'N' && name[4] != 'n' || name[5] != 'I' && name[5] != 'i' || name[6] != 'Z' && name[6] != 'z' || name[7] != 'A' && name[7] != 'a' || name[8] != 'T' && name[8] != 't' || name[9] != 'I' && name[9] != 'i' || name[10] != 'O' && name[10] != 'o' || name[11] != 'N' && name[11] != 'n') break;
                return new OrganizationHeaderImpl();
            }
            case 'H': 
            case 'h': {
                if (length != 4 || name[1] != 'I' && name[1] != 'i' || name[2] != 'D' && name[2] != 'd' || name[3] != 'E' && name[3] != 'e') break;
                return new HideHeaderImpl();
            }
            case 'M': 
            case 'm': {
                if (!(length != 12 || name[1] != 'A' && name[1] != 'a' || name[2] != 'X' && name[2] != 'x' || name[3] != '-' || name[4] != 'F' && name[4] != 'f' || name[5] != 'O' && name[5] != 'o' || name[6] != 'R' && name[6] != 'r' || name[7] != 'W' && name[7] != 'w' || name[8] != 'A' && name[8] != 'a' || name[9] != 'R' && name[9] != 'r' || name[10] != 'D' && name[10] != 'd' || name[11] != 'S' && name[11] != 's')) {
                    return new MaxForwardsHeaderImpl();
                }
                if (length != 12 || name[1] != 'I' && name[1] != 'i' || name[2] != 'M' && name[2] != 'm' || name[3] != 'E' && name[3] != 'e' || name[4] != '-' || name[5] != 'V' && name[5] != 'v' || name[6] != 'E' && name[6] != 'e' || name[7] != 'R' && name[7] != 'r' || name[8] != 'S' && name[8] != 's' || name[9] != 'I' && name[9] != 'i' || name[10] != 'O' && name[10] != 'o' || name[11] != 'N' && name[11] != 'n') break;
                return new MimeVersionHeaderImpl();
            }
            case 'D': 
            case 'd': {
                if (length != 4 || name[1] != 'A' && name[1] != 'a' || name[2] != 'T' && name[2] != 't' || name[3] != 'E' && name[3] != 'e') break;
                return new DateHeaderImpl();
            }
        }
        return new ExtendedHeader(String.valueOf(name, 0, length));
    }

    private static HeaderImpl createCHeader(char[] name, int length) {
        switch (name[1]) {
            case 'O': 
            case 'o': {
                if (!(length != 7 || name[2] != 'N' && name[2] != 'n' || name[3] != 'T' && name[3] != 't' || name[4] != 'A' && name[4] != 'a' || name[5] != 'C' && name[5] != 'c' || name[6] != 'T' && name[6] != 't')) {
                    return new ContactHeaderImpl();
                }
                if (length <= 8 || name[2] != 'N' && name[2] != 'n' || name[3] != 'T' && name[3] != 't' || name[4] != 'E' && name[4] != 'e' || name[5] != 'N' && name[5] != 'n' || name[6] != 'T' && name[6] != 't' || name[7] != '-') break;
                if (!(length != 14 || name[8] != 'L' && name[8] != 'l' || name[9] != 'E' && name[9] != 'e' || name[10] != 'N' && name[10] != 'n' || name[11] != 'G' && name[11] != 'g' || name[12] != 'T' && name[12] != 't' || name[13] != 'H' && name[13] != 'h')) {
                    return new ContentLengthHeaderImpl();
                }
                if (!(length != 12 || name[8] != 'T' && name[8] != 't' || name[9] != 'Y' && name[9] != 'y' || name[10] != 'P' && name[10] != 'p' || name[11] != 'E' && name[11] != 'e')) {
                    return new ContentTypeHeaderImpl();
                }
                if (!(length != 16 || name[8] != 'L' && name[8] != 'l' || name[9] != 'A' && name[9] != 'a' || name[10] != 'N' && name[10] != 'n' || name[11] != 'G' && name[11] != 'g' || name[12] != 'U' && name[12] != 'u' || name[13] != 'A' && name[13] != 'a' || name[14] != 'G' && name[14] != 'g' || name[15] != 'E' && name[15] != 'e')) {
                    return new ContentLanguageHeaderImpl();
                }
                if (!(length != 16 || name[8] != 'E' && name[8] != 'e' || name[9] != 'N' && name[9] != 'n' || name[10] != 'C' && name[10] != 'c' || name[11] != 'O' && name[11] != 'o' || name[12] != 'D' && name[12] != 'd' || name[13] != 'I' && name[13] != 'i' || name[14] != 'N' && name[14] != 'n' || name[15] != 'G' && name[15] != 'g')) {
                    return new ContentEncodingHeaderImpl();
                }
                if (length != 19 || name[8] != 'D' && name[8] != 'd' || name[9] != 'I' && name[9] != 'i' || name[10] != 'S' && name[10] != 's' || name[11] != 'P' && name[11] != 'p' || name[12] != 'O' && name[12] != 'o' || name[13] != 'S' && name[13] != 's' || name[14] != 'I' && name[14] != 'i' || name[15] != 'T' && name[15] != 't' || name[16] != 'I' && name[16] != 'i' || name[17] != 'O' && name[17] != 'o' || name[18] != 'N' && name[18] != 'n') break;
                return new ContentDispositionHeaderImpl();
            }
            case 'A': 
            case 'a': {
                if (!(length != 9 || name[2] != 'L' && name[2] != 'l' || name[3] != 'L' && name[3] != 'l' || name[4] != '-' || name[5] != 'I' && name[5] != 'i' || name[6] != 'N' && name[6] != 'n' || name[7] != 'F' && name[7] != 'f' || name[8] != 'O' && name[8] != 'o')) {
                    return new CallInfoHeaderImpl();
                }
                if (length != 7 || name[2] != 'L' && name[2] != 'l' || name[3] != 'L' && name[3] != 'l' || name[4] != '-' || name[5] != 'I' && name[5] != 'i' || name[6] != 'D' && name[6] != 'd') break;
                return new CallIdHeaderImpl();
            }
            case 'S': 
            case 's': {
                if (length != 4 || name[2] != 'E' && name[2] != 'e' || name[3] != 'Q' && name[3] != 'q') break;
                return new CSeqHeaderImpl();
            }
        }
        return new ExtendedHeader(String.valueOf(name, 0, length));
    }

    private static HeaderImpl createAHeader(char[] name, int length) {
        switch (name[1]) {
            case 'L': 
            case 'l': {
                if (!(length != 12 || name[2] != 'L' && name[2] != 'l' || name[3] != 'O' && name[3] != 'o' || name[4] != 'W' && name[4] != 'w' || name[5] != '-' || name[6] != 'E' && name[6] != 'e' || name[7] != 'V' && name[7] != 'v' || name[8] != 'E' && name[8] != 'e' || name[9] != 'N' && name[9] != 'n' || name[10] != 'T' && name[10] != 't' || name[11] != 'S' && name[11] != 's')) {
                    return new AllowEventsHeaderImpl();
                }
                if (!(length != 5 || name[2] != 'L' && name[2] != 'l' || name[3] != 'O' && name[3] != 'o' || name[4] != 'W' && name[4] != 'w')) {
                    return new AllowHeaderImpl();
                }
                if (length != 10 || name[2] != 'E' && name[2] != 'e' || name[3] != 'R' && name[3] != 'r' || name[4] != 'T' && name[4] != 't' || name[5] != '-' || name[6] != 'I' && name[6] != 'i' || name[7] != 'N' && name[7] != 'n' || name[8] != 'F' && name[8] != 'f' || name[9] != 'O' && name[9] != 'o') break;
                return new AlertInfoHeaderImpl();
            }
            case 'C': 
            case 'c': {
                if (length <= 5 || name[2] != 'C' && name[2] != 'c' || name[3] != 'E' && name[3] != 'e' || name[4] != 'P' && name[4] != 'p' || name[5] != 'T' && name[5] != 't') break;
                if (length == 6) {
                    return new AcceptHeaderImpl();
                }
                if (length != 15 || name[6] != '-') break;
                if (!(name[7] != 'E' && name[7] != 'e' || name[8] != 'N' && name[8] != 'n' || name[9] != 'C' && name[9] != 'c' || name[10] != 'O' && name[10] != 'o' || name[11] != 'D' && name[11] != 'd' || name[12] != 'I' && name[12] != 'i' || name[13] != 'N' && name[13] != 'n' || name[14] != 'G' && name[14] != 'g')) {
                    return new AcceptEncodingHeaderImpl();
                }
                if (name[7] != 'L' && name[7] != 'l' || name[8] != 'A' && name[8] != 'a' || name[9] != 'N' && name[9] != 'n' || name[10] != 'G' && name[10] != 'g' || name[11] != 'U' && name[11] != 'u' || name[12] != 'A' && name[12] != 'a' || name[13] != 'G' && name[13] != 'g' || name[14] != 'E' && name[14] != 'e') break;
                return new AcceptLanguageHeaderImpl();
            }
            case 'U': 
            case 'u': {
                if (length != 13 || name[2] != 'T' && name[2] != 't' || name[3] != 'H' && name[3] != 'h' || name[4] != 'O' && name[4] != 'o' || name[5] != 'R' && name[5] != 'r' || name[6] != 'I' && name[6] != 'i' || name[7] != 'Z' && name[7] != 'z' || name[8] != 'A' && name[8] != 'a' || name[9] != 'T' && name[9] != 't' || name[10] != 'I' && name[10] != 'i' || name[11] != 'O' && name[11] != 'o' || name[12] != 'N' && name[12] != 'n') break;
                return new AuthorizationHeaderImpl();
            }
        }
        return new ExtendedHeader(String.valueOf(name, 0, length));
    }

    private static HeaderImpl createSHeader(char[] name, int length) {
        switch (name[1]) {
            case 'U': 
            case 'u': {
                if (!(length != 9 || name[2] != 'P' && name[2] != 'p' || name[3] != 'P' && name[3] != 'p' || name[4] != 'O' && name[4] != 'o' || name[5] != 'R' && name[5] != 'r' || name[6] != 'T' && name[6] != 't' || name[7] != 'E' && name[7] != 'e' || name[8] != 'D' && name[8] != 'd')) {
                    return new SupportedHeaderImpl();
                }
                if (!(length != 7 || name[2] != 'B' && name[2] != 'b' || name[3] != 'J' && name[3] != 'j' || name[4] != 'E' && name[4] != 'e' || name[5] != 'C' && name[5] != 'c' || name[6] != 'T' && name[6] != 't')) {
                    return new SubjectHeaderImpl();
                }
                if (length != 18 || name[2] != 'B' && name[2] != 'b' || name[3] != 'S' && name[3] != 's' || name[4] != 'C' && name[4] != 'c' || name[5] != 'R' && name[5] != 'r' || name[6] != 'I' && name[6] != 'i' || name[7] != 'P' && name[7] != 'p' || name[8] != 'T' && name[8] != 't' || name[9] != 'I' && name[9] != 'i' || name[10] != 'O' && name[10] != 'o' || name[11] != 'N' && name[11] != 'n' || name[12] != '-' || name[13] != 'S' && name[13] != 's' || name[14] != 'T' && name[14] != 't' || name[15] != 'A' && name[15] != 'a' || name[16] != 'T' && name[16] != 't' || name[17] != 'E' && name[17] != 'e') break;
                return new SubscriptionStateHeaderImpl();
            }
            case 'E': 
            case 'e': {
                if (length != 6 || name[2] != 'R' && name[2] != 'r' || name[3] != 'V' && name[3] != 'v' || name[4] != 'E' && name[4] != 'e' || name[5] != 'R' && name[5] != 'r') break;
                return new ServerHeaderImpl();
            }
        }
        return new ExtendedHeader(String.valueOf(name, 0, length));
    }

    private static HeaderImpl createRHeader(char[] name, int length) {
        switch (name[1]) {
            case 'E': 
            case 'e': {
                if (!(length != 12 || name[2] != 'S' && name[2] != 's' || name[3] != 'P' && name[3] != 'p' || name[4] != 'O' && name[4] != 'o' || name[5] != 'N' && name[5] != 'n' || name[6] != 'S' && name[6] != 's' || name[7] != 'E' && name[7] != 'e' || name[8] != '-' || name[9] != 'K' && name[9] != 'k' || name[10] != 'E' && name[10] != 'e' || name[11] != 'Y' && name[11] != 'y')) {
                    return new ResponseKeyHeaderImpl();
                }
                if (!(length != 12 || name[2] != 'C' && name[2] != 'c' || name[3] != 'O' && name[3] != 'o' || name[4] != 'R' && name[4] != 'r' || name[5] != 'D' && name[5] != 'd' || name[6] != '-' || name[7] != 'R' && name[7] != 'r' || name[8] != 'O' && name[8] != 'o' || name[9] != 'U' && name[9] != 'u' || name[10] != 'T' && name[10] != 't' || name[11] != 'E' && name[11] != 'e')) {
                    return new RecordRouteHeaderImpl();
                }
                if (!(length != 7 || name[2] != 'Q' && name[2] != 'q' || name[3] != 'U' && name[3] != 'u' || name[4] != 'I' && name[4] != 'i' || name[5] != 'R' && name[5] != 'r' || name[6] != 'E' && name[6] != 'e')) {
                    return new RequireHeaderImpl();
                }
                if (!(length != 11 || name[2] != 'T' && name[2] != 't' || name[3] != 'R' && name[3] != 'r' || name[4] != 'Y' && name[4] != 'y' || name[5] != '-' || name[6] != 'A' && name[6] != 'a' || name[7] != 'F' && name[7] != 'f' || name[8] != 'T' && name[8] != 't' || name[9] != 'E' && name[9] != 'e' || name[10] != 'R' && name[10] != 'r')) {
                    return new RetryAfterHeaderImpl();
                }
                if (!(length != 8 || name[2] != 'P' && name[2] != 'p' || name[3] != 'L' && name[3] != 'l' || name[4] != 'A' && name[4] != 'a' || name[5] != 'C' && name[5] != 'c' || name[6] != 'E' && name[6] != 'e' || name[7] != 'S' && name[7] != 's')) {
                    return new ReplacesHeaderImpl();
                }
                if (length != 8 || name[2] != 'F' && name[2] != 'f' || name[3] != 'E' && name[3] != 'e' || name[4] != 'R' && name[4] != 'r' || name[5] != '-' || name[6] != 'T' && name[6] != 't' || name[7] != 'O' && name[7] != 'o') break;
                return new ReferToHeaderImpl();
            }
            case 'O': 
            case 'o': {
                if (length != 5 || name[2] != 'U' && name[2] != 'u' || name[3] != 'T' && name[3] != 't' || name[4] != 'E' && name[4] != 'e') break;
                return new RouteHeaderImpl();
            }
            case 'A': 
            case 'a': {
                if (length != 4 || name[2] != 'C' && name[2] != 'c' || name[3] != 'K' && name[3] != 'k') break;
                return new RAckHeaderImpl();
            }
            case 'S': 
            case 's': {
                if (length != 4 || name[2] != 'E' && name[2] != 'e' || name[3] != 'Q' && name[3] != 'q') break;
                return new RSeqHeaderImpl();
            }
        }
        return new ExtendedHeader(String.valueOf(name, 0, length));
    }

    private static HeaderImpl createEHeader(char[] name, int length) {
        switch (name[1]) {
            case 'X': 
            case 'x': {
                if (length != 7 || name[2] != 'P' && name[2] != 'p' || name[3] != 'I' && name[3] != 'i' || name[4] != 'R' && name[4] != 'r' || name[5] != 'E' && name[5] != 'e' || name[6] != 'S' && name[6] != 's') break;
                return new ExpiresHeaderImpl();
            }
            case 'V': 
            case 'v': {
                if (length != 5 || name[2] != 'E' && name[2] != 'e' || name[3] != 'N' && name[3] != 'n' || name[4] != 'T' && name[4] != 't') break;
                return new EventHeaderImpl();
            }
            case 'N': 
            case 'n': {
                if (length != 10 || name[2] != 'C' && name[2] != 'c' || name[3] != 'R' && name[3] != 'r' || name[4] != 'Y' && name[4] != 'y' || name[5] != 'P' && name[5] != 'p' || name[6] != 'T' && name[6] != 't' || name[7] != 'I' && name[7] != 'i' || name[8] != 'O' && name[8] != 'o' || name[9] != 'N' && name[9] != 'n') break;
                return new EncryptionHeaderImpl();
            }
            case 'R': 
            case 'r': {
                if (length != 10 || name[2] != 'R' && name[2] != 'r' || name[3] != 'O' && name[3] != 'o' || name[4] != 'R' && name[4] != 'r' || name[5] != '-' || name[6] != 'I' && name[6] != 'i' || name[7] != 'N' && name[7] != 'n' || name[8] != 'F' && name[8] != 'f' || name[9] != 'O' && name[9] != 'o') break;
                return new ErrorInfoHeaderImpl();
            }
        }
        return new ExtendedHeader(String.valueOf(name, 0, length));
    }

    private static HeaderImpl createPHeader(char[] name, int length) {
        switch (name[1]) {
            case 'A': 
            case 'a': {
                if (length != 4 || name[2] != 'T' && name[2] != 't' || name[3] != 'H' && name[3] != 'h') break;
                return new PathHeaderImpl();
            }
            case 'R': 
            case 'r': {
                if (length < 3) break;
                switch (name[2]) {
                    case 'O': 
                    case 'o': {
                        if (length <= 6 || name[3] != 'X' && name[3] != 'x' || name[4] != 'Y' && name[4] != 'y' || name[5] != '-') break;
                        if (!(length != 19 || name[6] != 'A' && name[6] != 'a' || name[7] != 'U' && name[7] != 'u' || name[8] != 'T' && name[8] != 't' || name[9] != 'H' && name[9] != 'h' || name[10] != 'O' && name[10] != 'o' || name[11] != 'R' && name[11] != 'r' || name[12] != 'I' && name[12] != 'i' || name[13] != 'Z' && name[13] != 'z' || name[14] != 'A' && name[14] != 'a' || name[15] != 'T' && name[15] != 't' || name[16] != 'I' && name[16] != 'i' || name[17] != 'O' && name[17] != 'o' || name[18] != 'N' && name[18] != 'n')) {
                            return new ProxyAuthorizationHeaderImpl();
                        }
                        if (!(length != 18 || name[6] != 'A' && name[6] != 'a' || name[7] != 'U' && name[7] != 'u' || name[8] != 'T' && name[8] != 't' || name[9] != 'H' && name[9] != 'h' || name[10] != 'E' && name[10] != 'e' || name[11] != 'N' && name[11] != 'n' || name[12] != 'T' && name[12] != 't' || name[13] != 'I' && name[13] != 'i' || name[14] != 'C' && name[14] != 'c' || name[15] != 'A' && name[15] != 'a' || name[16] != 'T' && name[16] != 't' || name[17] != 'E' && name[17] != 'e')) {
                            return new ProxyAuthenticateHeaderImpl();
                        }
                        if (length != 13 || name[6] != 'R' && name[6] != 'r' || name[7] != 'E' && name[7] != 'e' || name[8] != 'Q' && name[8] != 'q' || name[9] != 'U' && name[9] != 'u' || name[10] != 'I' && name[10] != 'i' || name[11] != 'R' && name[11] != 'r' || name[12] != 'E' && name[12] != 'e') break;
                        return new ProxyRequireHeaderImpl();
                    }
                    case 'I': 
                    case 'i': {
                        if (length != 8 || name[3] != 'O' && name[3] != 'o' || name[4] != 'R' && name[4] != 'r' || name[5] != 'I' && name[5] != 'i' || name[6] != 'T' && name[6] != 't' || name[7] != 'Y' && name[7] != 'y') break;
                        return new PriorityHeaderImpl();
                    }
                }
                break;
            }
            case '-': {
                if (!(length != 19 || name[2] != 'A' && name[2] != 'a' || name[3] != 'S' && name[3] != 's' || name[4] != 'S' && name[4] != 's' || name[5] != 'E' && name[5] != 'e' || name[6] != 'R' && name[6] != 'r' || name[7] != 'T' && name[7] != 't' || name[8] != 'E' && name[8] != 'e' || name[9] != 'D' && name[9] != 'd' || name[10] != '-' || name[11] != 'I' && name[11] != 'i' || name[12] != 'D' && name[12] != 'd' || name[13] != 'E' && name[13] != 'e' || name[14] != 'N' && name[14] != 'n' || name[15] != 'T' && name[15] != 't' || name[16] != 'I' && name[16] != 'i' || name[17] != 'T' && name[17] != 't' || name[18] != 'Y' && name[18] != 'y')) {
                    return new PAssertedIdentityHeaderImpl();
                }
                if (length != 20 || name[2] != 'P' && name[2] != 'p' || name[3] != 'R' && name[3] != 'r' || name[4] != 'E' && name[4] != 'e' || name[5] != 'F' && name[5] != 'f' || name[6] != 'E' && name[6] != 'e' || name[7] != 'R' && name[7] != 'r' || name[8] != 'R' && name[8] != 'r' || name[9] != 'E' && name[9] != 'e' || name[10] != 'D' && name[10] != 'd' || name[11] != '-' || name[12] != 'I' && name[12] != 'i' || name[13] != 'D' && name[13] != 'd' || name[14] != 'E' && name[14] != 'e' || name[15] != 'N' && name[15] != 'n' || name[16] != 'T' && name[16] != 't' || name[17] != 'I' && name[17] != 'i' || name[18] != 'T' && name[18] != 't' || name[19] != 'Y' && name[19] != 'y') break;
                return new PPreferredIdentityHeaderImpl();
            }
        }
        return new ExtendedHeader(String.valueOf(name, 0, length));
    }

    private static HeaderImpl createIHeader(char[] name, int length) {
        if (!(length != 11 || name[1] != 'N' && name[1] != 'n' || name[2] != '-' || name[3] != 'R' && name[3] != 'r' || name[4] != 'E' && name[4] != 'e' || name[5] != 'P' && name[5] != 'p' || name[6] != 'L' && name[6] != 'l' || name[7] != 'Y' && name[7] != 'y' || name[8] != '-' || name[9] != 'T' && name[9] != 't' || name[10] != 'O' && name[10] != 'o')) {
            return new InReplyToHeaderImpl();
        }
        if (!(length != 22 || name[1] != 'B' && name[1] != 'b' || name[2] != 'M' && name[2] != 'm' || name[3] != '-' || name[4] != 'T' && name[4] != 't' || name[5] != 'R' && name[5] != 'r' || name[6] != 'A' && name[6] != 'a' || name[7] != 'N' && name[7] != 'n' || name[8] != 'S' && name[8] != 's' || name[9] != 'A' && name[9] != 'a' || name[10] != 'C' && name[10] != 'c' || name[11] != 'T' && name[11] != 't' || name[12] != 'I' && name[12] != 'i' || name[13] != 'O' && name[13] != 'o' || name[14] != 'N' && name[14] != 'n' || name[15] != 'T' && name[15] != 't' || name[16] != 'I' && name[16] != 'i' || name[17] != 'M' && name[17] != 'm' || name[18] != 'E' && name[18] != 'e' || name[19] != 'O' && name[19] != 'o' || name[20] != 'U' && name[20] != 'u' || name[21] != 'T' && name[21] != 't')) {
            return new IbmTransactionTimeoutHeader(false);
        }
        if (!(length != 26 || name[1] != 'B' && name[1] != 'b' || name[2] != 'M' && name[2] != 'm' || name[3] != '-' || name[4] != 'R' && name[4] != 'r' || name[5] != 'E' && name[5] != 'e' || name[6] != 'T' && name[6] != 't' || name[7] != 'R' && name[7] != 'r' || name[8] != 'A' && name[8] != 'a' || name[9] != 'N' && name[9] != 'n' || name[10] != 'S' && name[10] != 's' || name[11] != 'M' && name[11] != 'm' || name[12] != 'I' && name[12] != 'i' || name[13] != 'S' && name[13] != 's' || name[14] != 'S' && name[14] != 's' || name[15] != 'I' && name[15] != 'i' || name[16] != 'O' && name[16] != 'o' || name[17] != 'N' && name[17] != 'n' || name[18] != 'I' && name[18] != 'i' || name[19] != 'N' && name[19] != 'n' || name[20] != 'T' && name[20] != 't' || name[21] != 'E' && name[21] != 'e' || name[22] != 'R' && name[22] != 'r' || name[23] != 'V' && name[23] != 'v' || name[24] != 'A' && name[24] != 'a' || name[25] != 'L' && name[25] != 'l')) {
            return new IbmRetransmissionIntervalHeader(false);
        }
        if (!(length != 29 || name[1] != 'B' && name[1] != 'b' || name[2] != 'M' && name[2] != 'm' || name[3] != '-' || name[4] != 'R' && name[4] != 'r' || name[5] != 'E' && name[5] != 'e' || name[6] != 'T' && name[6] != 't' || name[7] != 'R' && name[7] != 'r' || name[8] != 'A' && name[8] != 'a' || name[9] != 'N' && name[9] != 'n' || name[10] != 'S' && name[10] != 's' || name[11] != 'M' && name[11] != 'm' || name[12] != 'I' && name[12] != 'i' || name[13] != 'S' && name[13] != 's' || name[14] != 'S' && name[14] != 's' || name[15] != 'I' && name[15] != 'i' || name[16] != 'O' && name[16] != 'o' || name[17] != 'N' && name[17] != 'n' || name[18] != 'M' && name[18] != 'm' || name[19] != 'A' && name[19] != 'a' || name[20] != 'X' && name[20] != 'x' || name[21] != 'I' && name[21] != 'i' || name[22] != 'N' && name[22] != 'n' || name[23] != 'T' && name[23] != 't' || name[24] != 'E' && name[24] != 'e' || name[25] != 'R' && name[25] != 'r' || name[26] != 'V' && name[26] != 'v' || name[27] != 'A' && name[27] != 'a' || name[28] != 'L' && name[28] != 'l')) {
            return new IbmRetransmissionMaxIntervalHeader(false);
        }
        return new ExtendedHeader(String.valueOf(name, 0, length));
    }

    private static HeaderImpl createShortNameHeader(char[] name, int length) {
        char first = name[0];
        switch (first) {
            case 'T': 
            case 't': {
                return new ToHeaderImpl(true);
            }
            case 'F': 
            case 'f': {
                return new FromHeaderImpl(true);
            }
            case 'I': 
            case 'i': {
                return new CallIdHeaderImpl(true);
            }
            case 'M': 
            case 'm': {
                return new ContactHeaderImpl(true);
            }
            case 'L': 
            case 'l': {
                return new ContentLengthHeaderImpl(true);
            }
            case 'V': 
            case 'v': {
                return new ViaHeaderImpl(true);
            }
            case 'E': 
            case 'e': {
                return new ContentEncodingHeaderImpl(true);
            }
            case 'C': 
            case 'c': {
                return new ContentTypeHeaderImpl(true);
            }
            case 'K': 
            case 'k': {
                return new SupportedHeaderImpl(true);
            }
            case 'S': 
            case 's': {
                return new SubjectHeaderImpl(true);
            }
            case 'O': 
            case 'o': {
                return new EventHeaderImpl(true);
            }
            case 'U': 
            case 'u': {
                return new AllowEventsHeaderImpl(true);
            }
            case 'R': 
            case 'r': {
                return new ReferToHeaderImpl(true);
            }
        }
        return new ExtendedHeader(String.valueOf(name, 0, length));
    }
}

