/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl.netty;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.bytebuffer.internal.ByteBufferConfiguration;
import com.ibm.ws.sip.channel.resolver.dns.impl.netty.DnsMessage;
import com.ibm.ws.sip.channel.resolver.dns.impl.netty.OPTRecord;
import com.ibm.ws.sip.channel.resolver.dns.impl.netty.ResourceRecord;
import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverEvent;
import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverEventsCounter;
import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverListener;
import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverTcpTransport;
import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverTransport;
import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverTransportListener;
import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverUdpTransport;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupException;
import io.netty.buffer.ByteBuf;
import io.openliberty.netty.internal.NettyFramework;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

public class SipResolver
implements SipResolverTransportListener {
    private static final LogMgr c_logger = Log.get(SipResolver.class);
    public static final int MAX_REQUEST_CACHE_SIZE = 5000;
    private static final String SIP_RFC3263_DNS_FAILURE_DETECTION_SINGLE_QUERY_TIMEOUT_SEC = "SIP_RFC3263_DNS_FAILURE_DETECTION_SINGLE_QUERY_TIMEOUT_SEC";
    private static final String SIP_RFC3263_DNS_FAILURE_DETECTION_ALLOWED_FAILURES = "SIP_RFC3263_DNS_FAILURE_DETECTION_ALLOWED_FAILURES";
    private static final String SIP_RFC3263_DNS_FAILURE_DETECTION_WINDOW_SIZE_MIN = "SIP_RFC3263_DNS_FAILURE_DETECTION_WINDOW_SIZE_MIN";
    private static final String SIP_RFC3263_DNS_FAILURE_DETECTION_WINDOW_SIZE_INTERVAL_SEC = "SIP_RFC3263_DNS_FAILURE_DETECTION_WINDOW_SIZE_INTERVAL_SEC";
    private static final String SIP_USE_PRECISE_SYSTEM_TIMER = "SIP_USE_PRECISE_SYSTEM_TIMER";
    private static SipResolver _resolver;
    private static SipResolverTcpTransport _tcpTransport;
    private static SipResolverUdpTransport _udpTransport;
    private short _UDPpayloadSize = (short)1280;
    private static boolean _bEDNS;
    private boolean _shutdown = false;
    private static int UDP_TRANSPORT;
    private static int TCP_TRANSPORT;
    private static int ROLLOVER_TO_TCP;
    private static int transportToTry;
    private int COUNT_BEFORE_TRANSPORT_ROLLBACK = 1000;
    private int requestCount = 0;
    private static NettyFramework framework;
    private ByteBufferConfiguration wsbbmgr = null;
    private static boolean _enableSecondaryDNS;
    private static SipResolverEventsCounter _eventsCounter;
    private static long _dnsRequestTimeout;
    private static int _allowed_failures;
    private static int _window_size_min;
    private static int _window_interval_sec;
    private static boolean usePreciseSystemTimer;
    private Hashtable<Integer, RequestPending> _requestPending = new Hashtable();

    @Reference(service=ByteBufferConfiguration.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setByteBufferConfig(ByteBufferConfiguration bbConfig) {
        this.wsbbmgr = bbConfig;
    }

    protected void unsetByteBufferConfig(ByteBufferConfiguration bbConfig) {
    }

    protected ByteBufferConfiguration getByteBufferConfiguration() {
        if (c_logger.isEventEnabled()) {
            c_logger.event("wsbbmgr = " + this.wsbbmgr, new Object[0]);
        }
        return this.wsbbmgr;
    }

    protected NettyFramework getNettyBundle() {
        if (c_logger.isEventEnabled()) {
            c_logger.event("framework = " + framework, new Object[0]);
        }
        return framework;
    }

    public static synchronized SipResolver createResolver(Vector<InetSocketAddress> nameServers, Properties containerProps, NettyFramework f) {
        framework = f;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipResolver.class, "SipResolver: createResolver: entry");
        }
        if (_resolver == null) {
            Object tempObject;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: createResolver: instantiate the SipResolver");
            }
            if (nameServers != null && nameServers.size() > 1) {
                _enableSecondaryDNS = true;
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: secondary DNS is disabled.");
            }
            _resolver = new SipResolver();
            if (_bEDNS) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: initializing UdpTransport");
                }
                _udpTransport = new SipResolverUdpTransport(nameServers, _resolver, framework);
                transportToTry = UDP_TRANSPORT;
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: do NOT initialize UdpTransport");
                }
                transportToTry = TCP_TRANSPORT;
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: initializing TcpTransport");
            }
            _tcpTransport = new SipResolverTcpTransport(nameServers, _resolver, framework);
            String val = containerProps.getProperty(SIP_RFC3263_DNS_FAILURE_DETECTION_SINGLE_QUERY_TIMEOUT_SEC);
            if (val != null && val.length() > 0) {
                block38: {
                    try {
                        long l = Long.parseLong(val);
                        if (l > 0L) {
                            _dnsRequestTimeout = l * 1000L;
                        }
                    }
                    catch (NumberFormatException e2) {
                        if (!c_logger.isTraceDebugEnabled()) break block38;
                        c_logger.traceDebug("SipResolverService: initialize: invalid SIP_RFC3263_DNS_FAILURE_DETECTION_SINGLE_QUERY_TIMEOUT_SEC " + val);
                    }
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverService: initialize: SIP_RFC3263_DNS_FAILURE_DETECTION_SINGLE_QUERY_TIMEOUT_SEC " + _dnsRequestTimeout / 1000L);
                }
            }
            if ((val = containerProps.getProperty(SIP_RFC3263_DNS_FAILURE_DETECTION_ALLOWED_FAILURES)) != null && val.length() > 0) {
                block39: {
                    try {
                        int i = Integer.parseInt(val);
                        if (i > 0) {
                            _allowed_failures = i;
                        }
                    }
                    catch (NumberFormatException e3) {
                        if (!c_logger.isTraceDebugEnabled()) break block39;
                        c_logger.traceDebug("SipResolverService: initialize: invalid SIP_RFC3263_DNS_FAILURE_DETECTION_ALLOWED_FAILURES " + val);
                    }
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverService: initialize: SIP_RFC3263_DNS_FAILURE_DETECTION_ALLOWED_FAILURES " + _allowed_failures);
                }
            }
            if ((val = containerProps.getProperty(SIP_RFC3263_DNS_FAILURE_DETECTION_WINDOW_SIZE_MIN)) != null && val.length() > 0) {
                block40: {
                    try {
                        int i = Integer.parseInt(val);
                        if (i > 0) {
                            _window_interval_sec = i;
                        }
                    }
                    catch (NumberFormatException e4) {
                        if (!c_logger.isTraceDebugEnabled()) break block40;
                        c_logger.traceDebug("SipResolverService: initialize: invalid SIP_RFC3263_DNS_FAILURE_DETECTION_WINDOW_SIZE_MIN " + val);
                    }
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverService: initialize: SIP_RFC3263_DNS_FAILURE_DETECTION_WINDOW_SIZE_MIN " + _window_interval_sec);
                }
            }
            if ((val = containerProps.getProperty(SIP_RFC3263_DNS_FAILURE_DETECTION_WINDOW_SIZE_INTERVAL_SEC)) != null && val.length() > 0) {
                block41: {
                    try {
                        int i = Integer.parseInt(val);
                        if (i > 0) {
                            _window_size_min = i;
                        }
                    }
                    catch (NumberFormatException e5) {
                        if (!c_logger.isTraceDebugEnabled()) break block41;
                        c_logger.traceDebug("SipResolverService: initialize: invalid SIP_RFC3263_DNS_FAILURE_DETECTION_WINDOW_SIZE_INTERVAL_SEC " + val);
                    }
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverService: initialize: SIP_RFC3263_DNS_FAILURE_DETECTION_WINDOW_SIZE_INTERVAL_SEC " + _window_size_min);
                }
            }
            if ((tempObject = containerProps.get(SIP_USE_PRECISE_SYSTEM_TIMER)) != null) {
                boolean bl = usePreciseSystemTimer = tempObject instanceof Boolean ? (Boolean)tempObject : false;
                if (c_logger.isTraceDebugEnabled()) {
                    if (tempObject instanceof Boolean) {
                        c_logger.traceDebug("SipResolver: createResolver:  <SIP_USE_PRECISE_SYSTEM_TIMER>  is a Boolean");
                    } else {
                        c_logger.traceDebug("SipResolver: createResolver:  <SIP_USE_PRECISE_SYSTEM_TIMER>  is NOT a Boolean");
                    }
                    c_logger.traceDebug("SipResolver: createResolver:  <SIP_USE_PRECISE_SYSTEM_TIMER>  is set to " + tempObject);
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: createResolver:  <SIP_USE_PRECISE_SYSTEM_TIMER>  is not set");
            }
            SipResolverEventsCounter.setUsePreciseSystemTimer(usePreciseSystemTimer);
            _eventsCounter = new SipResolverEventsCounter(_window_size_min, _window_interval_sec);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(SipResolver.class, "SipResolver: createResolver: exit");
        }
        return _resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void shutdown() {
        if (!this._shutdown) {
            Hashtable<Integer, RequestPending> hashtable = this._requestPending;
            synchronized (hashtable) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: shutdown clear _requestPending");
                }
                this._requestPending.clear();
            }
            _tcpTransport.shutdown();
            if (_bEDNS) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: shutdown UdpTransport");
                }
                _udpTransport.shutdown();
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: do not shutdown UdpTransport");
            }
            _resolver = null;
            this._shutdown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipResolverEvent resolve(DnsMessage dnsRequest, SipResolverListener listener, boolean doTCP) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolver: resolve: entry id=" + this.hashCode());
        }
        SipResolverEvent event = null;
        try {
            Hashtable<Integer, RequestPending> hashtable = this._requestPending;
            synchronized (hashtable) {
                if (this._requestPending.size() > 5000) {
                    IllegalStateException e2 = new IllegalStateException("Request Cache overflowed. Shutdown SIP Resolver service.");
                    this.transportFailed(e2, null);
                    throw e2;
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: resolve put in _requestPending: " + new Integer(dnsRequest.getId()));
                }
                this._requestPending.put(new Integer(dnsRequest.getId()), new RequestPending(listener));
            }
            if (transportToTry == UDP_TRANSPORT && !doTCP) {
                OPTRecord opt = (OPTRecord)ResourceRecord.createRecord((short)41);
                opt.setUdpPayloadSize(this._UDPpayloadSize);
                dnsRequest.addAdditional(opt);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: resolve: dns request using UDP");
                }
                _udpTransport.writeRequest(dnsRequest.toBuffer());
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: resolve: dns request using TCP");
                }
                _tcpTransport.writeRequest(dnsRequest.toBuffer());
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: resolve: dns request = " + dnsRequest.toString());
            }
        }
        catch (IOException e3) {
            Hashtable<Integer, RequestPending> hashtable = this._requestPending;
            synchronized (hashtable) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: resolve remove from _requestPending: " + new Integer(dnsRequest.getId()));
                }
                this._requestPending.remove(new Integer(dnsRequest.getId()));
            }
            this.transportError(e3, null);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolver: resolve: exit");
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReceived(ByteBuf byteBuffer) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolver: responseReceived: entry id=" + this.hashCode());
        }
        try {
            RequestPending request;
            DnsMessage dnsResponse = new DnsMessage(byteBuffer);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: responseReceived: dns response = " + dnsResponse.toString());
            }
            Hashtable<Integer, RequestPending> hashtable = this._requestPending;
            synchronized (hashtable) {
                if (transportToTry == ROLLOVER_TO_TCP) {
                    ++this.requestCount;
                    if (this.requestCount >= this.COUNT_BEFORE_TRANSPORT_ROLLBACK) {
                        transportToTry = UDP_TRANSPORT;
                    }
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: responseReceived: remove from _requestPending: " + new Integer(dnsResponse.getId()));
                }
                request = this._requestPending.remove(new Integer(dnsResponse.getId()));
            }
            if (request != null) {
                long startTime;
                long endTime = 0L;
                endTime = usePreciseSystemTimer ? System.nanoTime() / 1000000L : System.currentTimeMillis();
                if (endTime - (startTime = request.getStartTime()) > _dnsRequestTimeout) {
                    int total;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolver: responseReceived: DNS responded after : " + (endTime - startTime) + " millisec");
                    }
                    if ((total = _eventsCounter.reportEvent()) > _allowed_failures && _enableSecondaryDNS) {
                        if (c_logger.isInfoEnabled()) {
                            c_logger.info("SipResolver: switching to secondary DNS");
                        }
                        _eventsCounter.reset();
                        _udpTransport.destroyFromTimeout(new SipURILookupException("No Response from DNS Server"));
                    }
                }
                SipResolverListener listener = request.getListener();
                int rcode = dnsResponse.getRCODE();
                if (dnsResponse.getTC() && rcode != 3) {
                    rcode = 6;
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: responseReceived: RC received: " + rcode);
                }
                switch (rcode) {
                    case 0: {
                        SipResolverEvent event = new SipResolverEvent();
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipResolver: responseReceived: Good Response");
                        }
                        event.setType((short)1);
                        event.setResponse(dnsResponse);
                        listener.handleSipResolverEvent(event);
                        break;
                    }
                    case 3: {
                        SipResolverEvent event = new SipResolverEvent();
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipResolver: responseReceived: notify listener with NAMING_EXCEPTION event");
                        }
                        event.setType((short)2);
                        event.setResponse(dnsResponse);
                        listener.handleSipResolverEvent(event);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: {
                        SipResolverEvent event = new SipResolverEvent();
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipResolver: responseReceived: notify listener with NAMING_EXCEPTION event");
                        }
                        event.setType((short)6);
                        event.setResponse(dnsResponse);
                        listener.handleSipResolverEvent(event);
                        break;
                    }
                    case 6: {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipResolver: responseReceived: retry case received");
                            c_logger.traceDebug("SipResolver: responseReceived: return event with type: NAMING_TRY_TCP");
                        }
                        SipResolverEvent event2 = new SipResolverEvent();
                        event2.setType((short)5);
                        event2.setResponse(dnsResponse);
                        listener.handleSipResolverEvent(event2);
                    }
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: responseReceived: no matching dns request for response");
            }
        }
        catch (Exception e2) {
            c_logger.traceDebug("SipResolver: responseReceived: Error: " + e2.getMessage());
            e2.printStackTrace();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolver: responseReceived: exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transportError(Exception exception, SipResolverTransport transport) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolver: transportError: entry id=" + this.hashCode());
        }
        try {
            Hashtable toRetry;
            Hashtable<Integer, RequestPending> hashtable = this._requestPending;
            synchronized (hashtable) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: transportError: clearing out pending events - # events: " + this._requestPending.size());
                }
                toRetry = (Hashtable)this._requestPending.clone();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: transportError: clear _requestPending: ");
                }
                this._requestPending.clear();
                if (transport != null) {
                    transport.prepareForReConnect();
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: transportError: sending NAMING_TRANSPORT_RETRY to listeners");
            }
            Enumeration e2 = toRetry.elements();
            while (e2.hasMoreElements()) {
                RequestPending request = (RequestPending)e2.nextElement();
                SipResolverListener listener = request.getListener();
                SipResolverEvent event = new SipResolverEvent();
                event.setType((short)3);
                event.setResponse(null);
                listener.handleSipResolverEvent(event);
            }
        }
        catch (Exception e3) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: transportError: Exception caught: " + e3);
            }
            this.transportFailed(e3, null);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolver: transportError: exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(DnsMessage msg, boolean isTimeout) {
        RequestPending request;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolver: cancelRequest: entry id=" + this.hashCode());
        }
        Hashtable<Integer, RequestPending> hashtable = this._requestPending;
        synchronized (hashtable) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: cancelRequest: remove from _requestPending: " + new Integer(msg.getId()));
            }
            request = this._requestPending.remove(new Integer(msg.getId()));
        }
        if (isTimeout && request != null) {
            long startTime;
            long endTime = 0L;
            endTime = usePreciseSystemTimer ? System.nanoTime() / 1000000L : System.currentTimeMillis();
            if (endTime - (startTime = request.getStartTime()) > _dnsRequestTimeout) {
                int total;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: responseReceived: DNS responded after : " + (endTime - startTime) + " millisec");
                }
                if ((total = _eventsCounter.reportEvent()) > _allowed_failures && _enableSecondaryDNS) {
                    if (c_logger.isInfoEnabled()) {
                        c_logger.info("SipResolver: switching to secondary DNS");
                    }
                    _eventsCounter.reset();
                    _udpTransport.destroyFromTimeout(new SipURILookupException("No Response from DNS Server"));
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolver: cancelRequest: exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transportFailed(Exception exception, SipResolverTransport transport) {
        Hashtable toFail;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolver: transportFailed: entry id=" + this.hashCode());
        }
        Hashtable<Integer, RequestPending> hashtable = this._requestPending;
        synchronized (hashtable) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: transportFailed: clearing out pending events - # events: " + this._requestPending.size());
            }
            if (transportToTry == UDP_TRANSPORT) {
                transportToTry = ROLLOVER_TO_TCP;
                this.requestCount = 0;
            } else if (transportToTry == ROLLOVER_TO_TCP) {
                transportToTry = UDP_TRANSPORT;
                this.requestCount = 0;
            }
            toFail = (Hashtable)this._requestPending.clone();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolver: transportFailed: clear _requestPending: ");
            }
            this._requestPending.clear();
            if (transport != null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolver: transportFailed: tell transport to prepare for re-connect");
                }
                transport.prepareForReConnect();
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolver: transportFailed: sending NAMING_TRANSPORT_FAILURE to listeners");
        }
        Enumeration e2 = toFail.elements();
        while (e2.hasMoreElements()) {
            RequestPending req = (RequestPending)e2.nextElement();
            SipResolverListener listener = req.getListener();
            SipResolverEvent event = new SipResolverEvent();
            event.setType((short)4);
            event.setResponse(null);
            listener.handleSipResolverEvent(event);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolver: transportFailed: exit id=" + this.hashCode());
        }
    }

    protected void setUdpPayloadSize(short size) {
        this._UDPpayloadSize = size;
    }

    protected static void setEDNS(boolean bool) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipResolver.class, "SipResolver: setENDS(boolean) setter: " + bool);
        }
        _bEDNS = bool;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(SipResolver.class, "SipResolver: setENDS(boolean)");
        }
    }

    static /* synthetic */ boolean access$000() {
        return usePreciseSystemTimer;
    }

    static {
        _bEDNS = true;
        UDP_TRANSPORT = 0;
        TCP_TRANSPORT = 1;
        ROLLOVER_TO_TCP = 2;
        transportToTry = UDP_TRANSPORT;
        _enableSecondaryDNS = false;
        _dnsRequestTimeout = 5000L;
        _allowed_failures = 5;
        _window_size_min = 600;
        _window_interval_sec = 10;
        usePreciseSystemTimer = false;
    }

    private class RequestPending {
        private long _startTime = SipResolver.access$000() ? System.nanoTime() / 1000000L : System.currentTimeMillis();
        private SipResolverListener _listener;

        public RequestPending(SipResolverListener listener) {
            this._listener = listener;
        }

        public SipResolverListener getListener() {
            return this._listener;
        }

        public long getStartTime() {
            return this._startTime;
        }
    }
}

