/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.message;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import java.util.NoSuchElementException;

abstract class HeaderIteratorImpl
implements HeaderIterator {
    protected MessageImpl.HeaderEntry m_entry;
    protected HeaderIteratorListener m_listener;

    HeaderIteratorImpl(MessageImpl.HeaderEntry entry, HeaderIteratorListener listener) {
        this.m_entry = entry;
        this.m_listener = listener;
    }

    @Override
    public boolean hasNext() {
        return this.m_entry != null;
    }

    @Override
    public Header remove() throws NoSuchElementException {
        MessageImpl.HeaderEntry currentEntry = this.getCurrentEntry();
        if (currentEntry == null) {
            throw new NoSuchElementException();
        }
        if (this.m_listener != null) {
            this.m_listener.onEntryDeleted(currentEntry);
        }
        return currentEntry.getHeader();
    }

    protected abstract MessageImpl.HeaderEntry getCurrentEntry();

    public static interface HeaderIteratorListener {
        public void onEntryDeleted(MessageImpl.HeaderEntry var1);
    }

    static class UnparsedSpecific
    extends Unparsed {
        UnparsedSpecific(MessageImpl.HeaderEntry entry, HeaderIteratorListener listener) {
            super(entry, listener);
        }

        @Override
        public Header next() throws HeaderParseException, NoSuchElementException {
            if (this.m_entry == null) {
                throw new NoSuchElementException();
            }
            HeaderImpl currHeader = this.m_entry.getHeader();
            MessageImpl.HeaderEntry nextEntry = this.m_entry.getNext();
            this.m_entry = nextEntry != null && !HeaderImpl.headerNamesEqual(currHeader.getName(), nextEntry.getHeader().getName()) ? null : nextEntry;
            return currHeader;
        }
    }

    static class Unparsed
    extends HeaderIteratorImpl {
        Unparsed(MessageImpl.HeaderEntry entry, HeaderIteratorListener listener) {
            super(entry, listener);
        }

        @Override
        public Header next() throws HeaderParseException, NoSuchElementException {
            if (this.m_entry == null) {
                throw new NoSuchElementException();
            }
            HeaderImpl header = this.m_entry.getHeader();
            this.m_entry = this.m_entry.getNext();
            return header;
        }

        @Override
        protected MessageImpl.HeaderEntry getCurrentEntry() {
            if (this.m_entry == null) {
                return null;
            }
            return this.m_entry.getPrev();
        }
    }

    static class Specific
    extends General {
        Specific(MessageImpl.HeaderEntry entry, HeaderIteratorListener listener) {
            super(entry, listener);
        }

        @Override
        public Header next() throws HeaderParseException, NoSuchElementException {
            HeaderImpl h;
            Header header = super.next();
            MessageImpl.HeaderEntry entry = this.m_entry;
            if (entry != null && !HeaderImpl.headerNamesEqual((h = entry.getHeader()).getName(), header.getName())) {
                this.m_entry = null;
            }
            return header;
        }
    }

    static class General
    extends HeaderIteratorImpl {
        private LAST_OPERATION lastOperation = null;
        private MessageImpl.HeaderEntry currentHeaderEntry = null;

        General(MessageImpl.HeaderEntry entry, HeaderIteratorListener listener) {
            super(entry, listener);
        }

        @Override
        public boolean hasNext() {
            if (this.lastOperation == null || this.lastOperation == LAST_OPERATION.NEXT) {
                this.moveToNextParsableHeader();
            }
            this.lastOperation = LAST_OPERATION.HAS_NEXT;
            return this.currentHeaderEntry != null;
        }

        @Override
        public Header next() throws HeaderParseException, NoSuchElementException {
            if (this.lastOperation == null || this.lastOperation == LAST_OPERATION.NEXT) {
                this.moveToNextParsableHeader();
            }
            if (this.currentHeaderEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastOperation = LAST_OPERATION.NEXT;
            return this.currentHeaderEntry.getHeader();
        }

        private void moveToNextParsableHeader() {
            boolean foundParsableHeader = false;
            this.currentHeaderEntry = null;
            while (this.m_entry != null && !foundParsableHeader) {
                this.currentHeaderEntry = this.m_entry;
                this.m_entry = this.m_entry.getNext();
                try {
                    this.currentHeaderEntry.getHeader().parse();
                }
                catch (SipParseException e2) {
                    continue;
                }
                foundParsableHeader = true;
            }
        }

        @Override
        protected MessageImpl.HeaderEntry getCurrentEntry() {
            if (this.lastOperation == null) {
                return null;
            }
            return this.currentHeaderEntry;
        }

        private static enum LAST_OPERATION {
            HAS_NEXT,
            NEXT;

        }
    }
}

