/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.NameAddressHeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.ContactHeader;
import java.util.Date;

public class ContactHeaderImpl
extends NameAddressHeaderImpl
implements ContactHeader {
    private static final long serialVersionUID = 2721338566178208060L;
    public static final String CONTACT_ACTION = "action";
    public static final String CONTACT_EXPIRE = "expires";
    public static final String CONTACT_Q = "q";
    protected String m_comment;
    protected boolean m_wildCard;
    private final boolean m_compactForm;

    public ContactHeaderImpl() {
        this(false);
    }

    public ContactHeaderImpl(boolean compactForm) {
        this.m_compactForm = compactForm;
    }

    @Override
    public boolean isWildCard() {
        return this.m_wildCard;
    }

    @Override
    public void setWildCard() {
        this.m_wildCard = true;
    }

    @Override
    public String getComment() {
        return this.m_comment;
    }

    @Override
    public boolean hasComment() {
        return this.m_comment != null;
    }

    @Override
    public void setComment(String comment) throws IllegalArgumentException, SipParseException {
        if (comment == null) {
            throw new IllegalArgumentException("Contact: null comment");
        }
        this.m_comment = comment;
    }

    @Override
    public void removeComment() {
        this.m_comment = null;
    }

    @Override
    public void setQValue(float qValue) throws SipParseException {
        if ((double)qValue < 0.0) {
            throw new SipParseException("AcceptLangHeader: Q Value < 0", "");
        }
        if ((double)qValue > 1.0) {
            throw new SipParseException("AcceptLangHeader: Q value > 1.0", "");
        }
        this.setParameter(CONTACT_Q, "" + qValue);
    }

    @Override
    public float getQValue() {
        String q = this.getParameter(CONTACT_Q);
        if (q == null) {
            return -1.0f;
        }
        try {
            return Float.parseFloat(q);
        }
        catch (NumberFormatException e2) {
            return -1.0f;
        }
    }

    @Override
    public boolean hasQValue() {
        return this.hasParameter(CONTACT_Q);
    }

    @Override
    public void removeQValue() {
        this.removeParameter(CONTACT_Q);
    }

    @Override
    public void setAction(String action) throws IllegalArgumentException, SipParseException {
        if (action == null) {
            throw new IllegalArgumentException("Contact: null action");
        }
        this.setParameter(CONTACT_ACTION, action);
    }

    @Override
    public boolean hasAction() {
        return this.hasParameter(CONTACT_ACTION);
    }

    @Override
    public void removeAction() {
        this.removeParameter(CONTACT_ACTION);
    }

    @Override
    public String getAction() {
        return this.getParameter(CONTACT_ACTION);
    }

    @Override
    public void setExpires(long expiryDeltaSeconds) throws SipParseException {
        if (expiryDeltaSeconds < 0L) {
            throw new SipParseException("Contant: Expires value not legal", "");
        }
        this.setParameter(CONTACT_EXPIRE, "" + expiryDeltaSeconds);
    }

    @Override
    public void setExpires(Date expiryDate) throws IllegalArgumentException, SipParseException {
        if (expiryDate == null) {
            throw new IllegalArgumentException("Contact: Null date");
        }
        long expTime = expiryDate.getTime();
        long currentTime = new Date().getTime();
        long expiresDelta = (expTime - currentTime) / 1000L;
        this.setParameter(CONTACT_EXPIRE, "" + expiresDelta);
    }

    @Override
    public long getExpiresAsDeltaSeconds() {
        String delta = this.getParameter(CONTACT_EXPIRE);
        if (delta == null) {
            return -1L;
        }
        try {
            return Long.parseLong(delta);
        }
        catch (NumberFormatException e2) {
            return -1L;
        }
    }

    @Override
    public Date getExpiresAsDate() {
        long expiryDelta = -1L;
        String delta = this.getParameter(CONTACT_EXPIRE);
        if (delta == null) {
            return null;
        }
        try {
            expiryDelta = Long.parseLong(delta);
        }
        catch (NumberFormatException e2) {
            return null;
        }
        long currentTime = new Date().getTime();
        return new Date(currentTime + expiryDelta * 1000L);
    }

    @Override
    public boolean hasExpires() {
        return this.hasParameter(CONTACT_EXPIRE);
    }

    @Override
    public void removeExpires() {
        this.removeParameter(CONTACT_EXPIRE);
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        if (parser.LA(1) == '*') {
            char c;
            int i = 2;
            boolean isWildCard = true;
            while ((c = parser.LA(i)) != '\u0000') {
                if (c != ' ') {
                    isWildCard = false;
                    break;
                }
                ++i;
            }
            if (isWildCard) {
                this.setWildCard();
                return;
            }
        }
        super.parseValue(parser);
        if (parser.LA(1) == '(') {
            parser.match('(');
            this.setComment(parser.nextToken(')'));
            parser.match(')');
        }
    }

    @Override
    protected void encodeValue(CharsBuffer buffer) {
        if (this.m_wildCard) {
            buffer.append('*');
            return;
        }
        super.encodeValue(buffer);
        if (this.hasComment()) {
            buffer.append('(');
            buffer.append(this.m_comment);
            buffer.append(')');
        }
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!super.valueEquals(other)) {
            return false;
        }
        if (!(other instanceof ContactHeaderImpl)) {
            return false;
        }
        ContactHeaderImpl o = (ContactHeaderImpl)other;
        if (this.m_wildCard ? !o.m_wildCard : o.m_wildCard) {
            return false;
        }
        if (this.m_comment == null || this.m_comment.length() == 0) {
            return o.m_comment == null || o.m_comment.length() == 0;
        }
        if (o.m_comment == null || o.m_comment.length() == 0) {
            return false;
        }
        return this.m_comment.equals(o.m_comment);
    }

    @Override
    public String getName() {
        return "Contact";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return true;
    }

    @Override
    protected char getListSeparator() {
        return ';';
    }

    @Override
    protected char getParamSeparator() {
        return ';';
    }

    @Override
    public String getName(boolean isUseCompactHeaders) {
        if (isUseCompactHeaders) {
            return String.valueOf('m');
        }
        return this.getName();
    }

    @Override
    public boolean isCompactFormSupported() {
        return true;
    }

    @Override
    public boolean isCompactForm() {
        return this.m_compactForm;
    }
}

