/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.ref.WeakReference;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.ValueHolder;

public abstract class WeakLazyValueHolder<T>
implements ValueHolder<T> {
    private volatile WeakReference<T> reference;

    public static <V> Function<V, ValueHolder<V>> forValue() {
        return new Function<V, ValueHolder<V>>(){

            @Override
            public ValueHolder<V> apply(final V value) {
                return new WeakLazyValueHolder<V>(){

                    @Override
                    protected V computeValue() {
                        return value;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        WeakReference<T> reference = this.reference;
        T value = null;
        if (reference != null) {
            value = reference.get();
        }
        if (value != null) {
            return value;
        }
        WeakLazyValueHolder weakLazyValueHolder = this;
        synchronized (weakLazyValueHolder) {
            if (this.reference == reference) {
                T newValue = this.computeValue();
                this.reference = new WeakReference<T>(newValue);
            }
            return this.reference.get();
        }
    }

    @Override
    public T getIfPresent() {
        WeakReference<T> reference = this.reference;
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        WeakLazyValueHolder weakLazyValueHolder = this;
        synchronized (weakLazyValueHolder) {
            this.reference = null;
        }
    }

    protected abstract T computeValue();
}

