/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jfap.inbound.channel;

import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jfap.inbound.channel.CommsServerServiceFacade;
import com.ibm.ws.jfap.inbound.channel.InboundChain;
import com.ibm.ws.sib.jfapchannel.netty.NettyJMSHeartbeatHandler;
import com.ibm.ws.sib.jfapchannel.netty.NettyToWsBufferDecoder;
import com.ibm.ws.sib.jfapchannel.netty.WsBufferToNettyEncoder;
import com.ibm.ws.sib.jfapchannel.server.impl.NettyJMSServerHandler;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import io.openliberty.netty.internal.ChannelInitializerWrapper;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.ServerBootstrapExtended;
import io.openliberty.netty.internal.exception.NettyException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class NettyInboundChain
implements InboundChain {
    private static final TraceComponent tc = Tr.register(NettyInboundChain.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private boolean _isSecureChain = false;
    private boolean _isEnabled = false;
    private String _chainName;
    private final CommsServerServiceFacade _commsServerFacade;
    private String _endpointName;
    private EndPointMgr _endpointMgr;
    private NettyFramework _nettyFramework;
    private String _tcpName;
    private String _sslName;
    private String _jfapName;
    private volatile boolean _isChainStarted = false;
    private ChainConfiguration _currentConfig;
    private ServerBootstrapExtended bootstrap;
    private Channel serverChan;

    NettyInboundChain(CommsServerServiceFacade commsServer, boolean isSecureChain) {
        this._commsServerFacade = commsServer;
        this._isSecureChain = isSecureChain;
    }

    public InboundChain init(String endpointName, NettyFramework netty) {
        this._nettyFramework = netty;
        this._endpointMgr = netty.getEndpointManager();
        this._endpointName = endpointName;
        if (this._isSecureChain) {
            this._chainName = "InboundSecureMessaging";
            this._tcpName = this._endpointName;
            this._sslName = "SSL-" + this._endpointName;
            this._jfapName = "JFAP-" + this._endpointName;
        } else {
            this._chainName = "InboundBasicMessaging";
            this._tcpName = this._endpointName;
            this._jfapName = "JFAP-" + this._endpointName;
        }
        return this;
    }

    @Override
    public void enable(boolean enabled) {
        this._isEnabled = enabled;
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public boolean isRunning() {
        return this._isEnabled && this._isChainStarted;
    }

    private void quiesceListener(Channel channel) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"quiesceListener", (Object)channel);
            }
            try {
                if (this._isSecureChain) {
                    this._commsServerFacade.closeViaCommsMPConnections(3);
                } else {
                    this._commsServerFacade.closeViaCommsMPConnections(2);
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                SibTr.debug((TraceComponent)tc, (String)"Failed in stopping MP connections which are establised through COMMS: ", (Object)e);
            }
        }
        this._nettyFramework.stop(this.serverChan);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"quiesceListener");
        }
    }

    public void stopChannel(boolean closeGroups) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopChannel");
        }
        if (!this._isChainStarted) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Chain not started. Moving along");
            }
            return;
        }
        if (this.serverChan == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Netty channel not initialized. Setting chain stop");
            }
            this._isChainStarted = false;
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"stopChannel", (Object)("Stopping Channel " + this.serverChan + " --- " + this.serverChan.localAddress()));
        }
        try {
            this._nettyFramework.stop(this.serverChan, -1L);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Failed in successfully cleaning(i.e stopping/destorying/removing) chain: ", (Object)e);
            }
        }
        finally {
            this._isChainStarted = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopChannel");
        }
    }

    @Override
    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this.stopChannel(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    @Override
    public void update() {
        block15: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"update");
            }
            if (!this._isEnabled || FrameworkState.isStopping()) {
                return;
            }
            ChainConfiguration oldConfig = this._currentConfig;
            boolean validOldConfig = oldConfig == null ? false : oldConfig.isValidConfig;
            Map<String, Object> tcpOptions = this._commsServerFacade.getTcpOptions();
            Map<String, Object> sslOptions = this._isSecureChain ? this._commsServerFacade.getSslOptions() : null;
            ChainConfiguration newConfig = new ChainConfiguration(this._isSecureChain ? this._commsServerFacade.getSecurePort() : this._commsServerFacade.getBasicPort(), this._commsServerFacade.getHost(), tcpOptions, sslOptions);
            if (newConfig.configPort < 0 || !newConfig.complete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Stopping chain due to configuration " + newConfig));
                }
                this._currentConfig = newConfig;
                this.stopChannel(false);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"update");
                }
                return;
            }
            if (validOldConfig && newConfig.unchanged(oldConfig)) {
                if (newConfig.getActivePort() == oldConfig.getActivePort() && newConfig.getActivePort() != -1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Chain is already started " + oldConfig));
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Existing config must be started " + newConfig));
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("New/changed chain configuration " + newConfig));
            }
            try {
                if (validOldConfig) {
                    this.stopChannel(false);
                }
                this._currentConfig = newConfig;
                this._endpointMgr.defineEndPoint(this._endpointName, newConfig.configHost, newConfig.configPort);
                EndPointInfo ep = this._endpointMgr.getEndPoint(this._endpointName);
                ep = this._endpointMgr.defineEndPoint(this._endpointName, this._currentConfig.configHost, this._currentConfig.configPort);
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.putAll(this._currentConfig.tcpOptions);
                options.put("ExternalName", this._endpointName);
                this.bootstrap = this._nettyFramework.createTCPBootstrap(options);
                this.bootstrap.childHandler((ChannelHandler)new JMSServerInitializer(this.bootstrap.getBaseInitializer(), this));
                NettyInboundChain parent = this;
                this.serverChan = this._nettyFramework.start(this.bootstrap, ep.getHost(), ep.getPort(), f -> {
                    if (f.isCancelled() || !f.isSuccess()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Channel exception during connect: " + f.cause().getMessage()));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.entry((Object)parent, (TraceComponent)tc, (String)"destroy", (Object)((Exception)f.cause()));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((Object)parent, (TraceComponent)tc, (String)"destroy");
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.entry((Object)parent, (TraceComponent)tc, (String)"ready", (Object)f);
                        }
                        final Channel chan = f.channel();
                        f.addListener(innerFuture -> {
                            if (innerFuture.isCancelled() || !innerFuture.isSuccess()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Channel exception during connect. Couldn't add quiesce handler: " + f.cause().getMessage()));
                                }
                                this.quiesceListener(chan);
                            } else if (!this._isChainStarted) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Server Channel: " + this.serverChan + " will be closed because chain was disabled"));
                                }
                                this.quiesceListener(chan);
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.entry((Object)parent, (TraceComponent)tc, (String)"adding quiesce", (Object)f);
                                }
                                this._nettyFramework.registerEndpointQuiesce(chan, (Callable)new Callable<Void>(){

                                    @Override
                                    public Void call() throws Exception {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Server Channel: " + NettyInboundChain.this.serverChan + " received quiesce event so running close"));
                                        }
                                        NettyInboundChain.this.quiesceListener(chan);
                                        return null;
                                    }
                                });
                            }
                        });
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((Object)parent, (TraceComponent)tc, (String)"ready");
                        }
                    }
                });
                this._isChainStarted = true;
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Problem in starting the chain  " + newConfig), (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"update");
        }
    }

    private final class ChainConfiguration {
        final int configPort;
        final String configHost;
        final Map<String, Object> tcpOptions;
        final Map<String, Object> sslOptions;
        volatile int activePort = -1;
        boolean isValidConfig = false;

        ChainConfiguration(int port, String host, Map<String, Object> tcp, Map<String, Object> ssl) {
            this.tcpOptions = tcp;
            this.sslOptions = ssl;
            this.configPort = port;
            this.configHost = host;
        }

        public int getActivePort() {
            if (this.configPort < 0) {
                return -1;
            }
            return this.configPort;
        }

        @Trivial
        public boolean complete() {
            if (this.tcpOptions == null) {
                return false;
            }
            return !NettyInboundChain.this._isSecureChain || this.sslOptions != null;
        }

        protected boolean unchanged(ChainConfiguration other) {
            if (other == null) {
                return false;
            }
            if (NettyInboundChain.this._isSecureChain) {
                return this.configHost.equals(other.configHost) && this.configPort == other.configPort && this.tcpOptions == other.tcpOptions && this.sslOptions == other.sslOptions;
            }
            return this.configHost.equals(other.configHost) && this.configPort == other.configPort && this.tcpOptions == other.tcpOptions;
        }

        protected boolean tcpChanged(ChainConfiguration other) {
            if (other == null) {
                return false;
            }
            return !this.configHost.equals(other.configHost) || this.configPort != other.configPort || this.tcpOptions != other.tcpOptions;
        }

        protected boolean sslChanged(ChainConfiguration other) {
            if (other == null) {
                return false;
            }
            return this.sslOptions != other.sslOptions;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[host=" + this.configHost + ",port=" + this.configPort + ",listening=" + this.activePort + ",complete=" + this.complete() + "]";
        }
    }

    private class JMSServerInitializer
    extends ChannelInitializerWrapper {
        final ChannelInitializerWrapper parent;
        private final NettyInboundChain chain;

        public JMSServerInitializer(ChannelInitializerWrapper parent, NettyInboundChain chain) {
            this.parent = parent;
            this.chain = chain;
        }

        protected void initChannel(Channel ch) throws Exception {
            this.parent.init(ch);
            ChannelPipeline pipeline = ch.pipeline();
            ch.attr(NettyJMSServerHandler.CHAIN_ATTR_KEY).set((Object)NettyInboundChain.this._chainName);
            ch.attr(NettyJMSServerHandler.ATTR_KEY).set((Object)this.chain);
            if (NettyInboundChain.this._isSecureChain) {
                SslHandler handler;
                EndPointInfo ep = NettyInboundChain.this._endpointMgr.getEndPoint(NettyInboundChain.this._endpointName);
                String host = ep.getHost();
                String port = Integer.toString(ep.getPort());
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Create SSL handler", (Object)new Object[]{host, port, ((NettyInboundChain)NettyInboundChain.this)._currentConfig.sslOptions});
                }
                if ((handler = NettyInboundChain.this._commsServerFacade.getNettyTlsProvider().getInboundSSLContext(((NettyInboundChain)NettyInboundChain.this)._currentConfig.sslOptions, host, port, ch)) == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"initChannel", (Object)"Error adding TLS Support");
                    }
                    throw new NettyException("Problems creating SslHandler");
                }
                pipeline.addFirst("ssl", (ChannelHandler)handler);
            }
            pipeline.addLast("decoder", (ChannelHandler)new NettyToWsBufferDecoder());
            pipeline.addLast("encoder", (ChannelHandler)new WsBufferToNettyEncoder());
            pipeline.replace("inactivityTimeoutHandler", "heartBeatHandler", (ChannelHandler)new NettyJMSHeartbeatHandler(0));
            pipeline.addLast("jmsServerHandler", (ChannelHandler)new NettyJMSServerHandler());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Channel: " + ch + " handler names: " + pipeline.names()));
            }
        }
    }
}

