/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.client.internal.AttributeToSubjectExt;
import com.ibm.ws.security.openidconnect.client.internal.OidcClientConfigImpl;
import com.ibm.ws.security.openidconnect.client.jose4j.OidcTokenImpl;
import com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcClientAuthenticator {
    private static final TraceComponent tc = Tr.register(OidcClientAuthenticator.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    OidcClientUtil oidcClientUtil = new OidcClientUtil();
    private SSLSupport sslSupport;
    private OIDCClientAuthenticatorUtil authenticatorUtil = null;
    static final long serialVersionUID = -5449443864611447500L;

    public OidcClientAuthenticator() {
        this.authenticatorUtil = new OIDCClientAuthenticatorUtil();
    }

    public OidcClientAuthenticator(AtomicServiceReference<SSLSupport> sslSupportRef) {
        this.sslSupport = (SSLSupport)sslSupportRef.getService();
        this.authenticatorUtil = new OIDCClientAuthenticatorUtil(this.sslSupport);
    }

    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, OidcClientConfig clientConfig) {
        ProviderAuthenticationResult result = this.authenticatorUtil.authenticate(req, res, (ConvergedClientConfig)clientConfig);
        result = this.discoverOPAgain(result, clientConfig);
        result = OidcClientAuthenticator.fixSubject(result);
        result = this.invokeUserResolverSPI(result, clientConfig);
        return result;
    }

    private ProviderAuthenticationResult discoverOPAgain(ProviderAuthenticationResult result, OidcClientConfig clientConfig) {
        OidcClientConfigImpl oidcConfigImpl = (OidcClientConfigImpl)clientConfig;
        if (result.getStatus() != AuthResult.SUCCESS && oidcConfigImpl.isDiscoveryInUse() && System.currentTimeMillis() > oidcConfigImpl.getNextDiscoveryTime()) {
            oidcConfigImpl.handleDiscoveryEndpoint(oidcConfigImpl.getDiscoveryEndpointUrl());
        } else if (result.getStatus() == AuthResult.SUCCESS && oidcConfigImpl.isDiscoveryInUse()) {
            oidcConfigImpl.setNextDiscoveryTime();
        }
        return result;
    }

    private ProviderAuthenticationResult invokeUserResolverSPI(ProviderAuthenticationResult result, OidcClientConfig config) {
        if (result.getCustomProperties() == null) {
            return result;
        }
        OidcTokenImplBase idToken = (OidcTokenImplBase)result.getCustomProperties().get("id_token_object");
        if (idToken == null) {
            return result;
        }
        result.getCustomProperties().remove("id_token_object");
        AttributeToSubjectExt a2s = new AttributeToSubjectExt(config, idToken);
        if (!a2s.isTokenMappingSpi()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"token mapping SPI is not active", (Object[])new Object[0]);
            }
            return result;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"token mapping SPI is active, updating mapping.", (Object[])new Object[0]);
        }
        Hashtable customProperties = result.getCustomProperties();
        customProperties.remove("com.ibm.wsspi.security.cred.uniqueId");
        customProperties.remove("com.ibm.wsspi.security.cred.realm");
        customProperties.remove("com.ibm.wsspi.security.cred.groups");
        result = a2s.doMapping(result.getCustomProperties(), result.getSubject());
        return result;
    }

    public static ProviderAuthenticationResult fixSubject(ProviderAuthenticationResult result) {
        if (result.getSubject() == null) {
            return result;
        }
        Set<Object> creds = result.getSubject().getPrivateCredentials();
        Set<OidcTokenImplBase> oidcTokens = result.getSubject().getPrivateCredentials(OidcTokenImplBase.class);
        for (OidcTokenImplBase oidcToken : oidcTokens) {
            creds.remove(oidcToken);
            creds.add(new OidcTokenImpl(oidcToken));
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"idToken in subject is replaced with OidcTokenImpl", (Object[])new Object[0]);
        }
        return result;
    }
}

