/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Objects;
import org.apache.yoko.orb.OB.CharMapInfo;
import org.apache.yoko.orb.OB.CodeConverterBase;
import org.apache.yoko.orb.OB.CodeSetInfo;

final class CodeConverterImpl
extends CodeConverterBase {
    private final CharMapInfo fromMap;
    private final CharMapInfo toMap;
    private final boolean conversionRequired;

    CodeConverterImpl(CodeSetInfo fromSet, CodeSetInfo toSet) {
        super(fromSet, toSet);
        this.fromMap = fromSet.charMap;
        this.toMap = toSet.charMap;
        Objects.requireNonNull(this.fromMap);
        Objects.requireNonNull(this.toMap);
        this.conversionRequired = this.fromMap == CharMapInfo.CM_IDENTITY && this.toMap == CharMapInfo.CM_IDENTITY;
    }

    @Override
    public boolean conversionRequired() {
        return this.conversionRequired;
    }

    @Override
    public char convert(char v) {
        return this.convertFromJava(this.convertToJava(v));
    }

    private char convertFromJava(char v) {
        return this.toMap.convertFromJava(v);
    }

    private char convertToJava(char v) {
        return this.fromMap.convertToJava(v);
    }
}

