/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.trust.impl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.X509TrustManager;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustEngineX509TrustManager
implements X509TrustManager {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TrustEngineX509TrustManager.class);
    @Nullable
    private TrustEngine<? super X509Credential> tlsTrustEngine;
    @Nullable
    private CriteriaSet tlsCriteriaSet;

    public void setTLSTrustEngine(@Nullable TrustEngine<? super X509Credential> engine) {
        this.tlsTrustEngine = engine;
    }

    public void setTLSCriteriaSet(@Nullable CriteriaSet criteriaSet) {
        this.tlsCriteriaSet = criteriaSet;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        this.checkServerTrusted(arg0, arg1);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        if (arg0 == null || arg0.length < 1) {
            throw new CertificateException("Peer certificate array was null or empty");
        }
        if (this.tlsTrustEngine == null) {
            throw new CertificateException("TrustEngine was null");
        }
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        for (X509Certificate cert : arg0) {
            certChain.add(cert);
        }
        BasicX509Credential credential = new BasicX509Credential(arg0[0]);
        credential.setEntityCertificateChain(certChain);
        CriteriaSet criteriaSet = this.tlsCriteriaSet != null ? this.tlsCriteriaSet : new CriteriaSet(new Criterion[]{new UsageCriterion(UsageType.SIGNING)});
        try {
            if (!this.tlsTrustEngine.validate(credential, criteriaSet)) {
                this.log.debug("Credential evaluated as untrusted");
                throw new CertificateException("Trust engine could not establish trust of TLS credential");
            }
            this.log.debug("Credential evaluated as trusted");
        }
        catch (SecurityException e) {
            this.log.error("Trust engine error evaluating credential: {}", (Object)e.getMessage());
            throw new CertificateException("Trust engine error evaluating credential", e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

