/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.fips;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.crypto.CryptoUtils;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
public class FIPSInitializer
implements ServletContainerInitializer {
    protected static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = FIPSInitializer.class.getName();
    private static String MAC_ALGORITHM = "org.apache.myfaces.MAC_ALGORITHM";
    private static String SESSION_ALGORITHM = "org.apache.myfaces.ALGORITHM";
    private static String VIEWSTATE_ID_ALGORITHM = "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITM";
    private static String CSRF_SESSION_ALGORITHM = "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_ALGORITM";
    static final long serialVersionUID = 833055858013956857L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public FIPSInitializer() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.fips.FIPSInitializer", "<init>", new Object[0]);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.fips.FIPSInitializer", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void onStartup(Set<Class<?>> clazzes, ServletContext servletContext) throws ServletException {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.fips.FIPSInitializer", "onStartup", new Object[]{clazzes, servletContext});
        }
        if (CryptoUtils.isFips140_3EnabledWithBetaGuard()) {
            if (servletContext.getInitParameter(MAC_ALGORITHM) == null) {
                servletContext.setInitParameter(MAC_ALGORITHM, "HmacSHA256");
                this.log(MAC_ALGORITHM + " not found. Setting to HmacSHA256.");
            }
            if (servletContext.getInitParameter(SESSION_ALGORITHM) == null) {
                servletContext.setInitParameter(SESSION_ALGORITHM, "AES");
                this.log(SESSION_ALGORITHM + " not found. Setting to AES.");
            }
            if (servletContext.getInitParameter(VIEWSTATE_ID_ALGORITHM) == null) {
                servletContext.setInitParameter(VIEWSTATE_ID_ALGORITHM, "SHA256DRBG");
                this.log(VIEWSTATE_ID_ALGORITHM + " not found. Setting to SHA256DRBG.");
            }
            if (servletContext.getInitParameter(CSRF_SESSION_ALGORITHM) == null) {
                servletContext.setInitParameter(CSRF_SESSION_ALGORITHM, "SHA256DRBG");
                this.log(CSRF_SESSION_ALGORITHM + " not found. Setting to SHA256DRBG.");
            }
        } else {
            this.log("FIPS not enabled. Skipping FIPSInitializer setup");
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.fips.FIPSInitializer", "onStartup");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void log(String message) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.fips.FIPSInitializer", "log", new Object[]{message});
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "onStartup", message);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.fips.FIPSInitializer", "log");
        }
    }
}

