/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.binding;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.Cache;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.InitialRequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.UserData;
import com.ibm.ws.security.saml.sso20.metadata.AcsDOMMetadataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleKeyInfoReferenceEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.ChainingKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.CollectionKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.LocalKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.AgreementMethodKeyInfoProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.ECKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BasicMessageContext<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject> {
    public static final TraceComponent tc = Tr.register(BasicMessageContext.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    SsoConfig ssoConfig;
    SsoSamlService ssoService;
    IDPSSODescriptor idpSsoDescriptor;
    QName peerEntityRole;
    EntityDescriptor peerEntityMetadata;
    String inboundSAMLProtocol;
    Assertion validatedAssertion;
    Decrypter decrypter;
    String externalRelayState;
    SsoRequest samlRequest;
    HttpRequestInfo cachedRequestInfo;
    boolean bSetIDPSSODescriptor = false;
    Status logoutResponseStatus;
    String inResponseTo;
    AcsDOMMetadataProvider metadataProvider = null;
    HttpServletRequest request;
    HttpServletResponse response;
    InitialRequestUtil irUtil = new InitialRequestUtil();
    ChainingEncryptedKeyResolver encryptedKeyResolver;
    private final List<EncryptedKeyResolver> resolverChain;
    EncryptedKeyResolver inline = new InlineEncryptedKeyResolver();
    EncryptedKeyResolver encryptedelem = new EncryptedElementTypeEncryptedKeyResolver();
    EncryptedKeyResolver simple = new SimpleRetrievalMethodEncryptedKeyResolver();
    EncryptedKeyResolver simpleref = new SimpleKeyInfoReferenceEncryptedKeyResolver();
    SAMLPeerEntityContext samlPeerEntityContext = new SAMLPeerEntityContext();
    private MessageContext messageContext;
    private Endpoint peerEntityEndpoint;
    private String inboundMessageIssuer;
    private NameID subjectNameIdentifer;
    static final long serialVersionUID = 5103837256789663145L;

    public BasicMessageContext(SsoSamlService ssoService) {
        this.ssoService = ssoService;
        this.ssoConfig = ssoService.getConfig();
        this.resolverChain = Arrays.asList(this.inline, this.encryptedelem, this.simple, this.simpleref);
        this.encryptedKeyResolver = new ChainingEncryptedKeyResolver(this.resolverChain);
    }

    public BasicMessageContext(SsoSamlService ssoService, HttpServletRequest request, HttpServletResponse response) {
        this.ssoService = ssoService;
        this.ssoConfig = ssoService.getConfig();
        this.request = request;
        this.response = response;
        this.resolverChain = Arrays.asList(this.inline, this.encryptedelem, this.simple, this.simpleref);
        this.encryptedKeyResolver = new ChainingEncryptedKeyResolver(this.resolverChain);
    }

    public SsoSamlService getSsoService() {
        return this.ssoService;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public void setMetadataProvider(AcsDOMMetadataProvider acsIdpMetadataProvider) {
        this.metadataProvider = acsIdpMetadataProvider;
    }

    public AcsDOMMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public Status getSLOResponseStatus() {
        return this.logoutResponseStatus;
    }

    public void setSLOResponseStatus(Status status) {
        this.logoutResponseStatus = status;
    }

    public EntityDescriptor getPeerEntityMetadata() {
        if (!this.bSetIDPSSODescriptor) {
            this.setIDPSSODescriptor();
        }
        return this.peerEntityMetadata;
    }

    /*
     * WARNING - void declaration
     */
    void setIDPSSODescriptor() {
        this.bSetIDPSSODescriptor = true;
        SAMLObject samlMsg = null;
        if (this.getMessageContext() != null) {
            samlMsg = (SAMLObject)this.getMessageContext().getMessage();
        }
        if (samlMsg != null && (samlMsg instanceof Response || samlMsg instanceof LogoutResponse || samlMsg instanceof LogoutRequest)) {
            String issuer = null;
            if (samlMsg instanceof Response) {
                Response samlResponse = (Response)samlMsg;
                issuer = samlResponse.getIssuer().getValue();
            } else if (samlMsg instanceof LogoutResponse) {
                LogoutResponse sloResponse = (LogoutResponse)samlMsg;
                issuer = sloResponse.getIssuer().getValue();
            } else if (samlMsg instanceof LogoutRequest) {
                LogoutRequest sloRequest = (LogoutRequest)samlMsg;
                issuer = sloRequest.getIssuer().getValue();
            }
            if (this.metadataProvider != null) {
                EntityDescriptor entityDescriptor;
                block15: {
                    CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(issuer)});
                    entityDescriptor = null;
                    try {
                        entityDescriptor = this.metadataProvider.resolveSingle(criteriaSet);
                    }
                    catch (ResolverException resolverException) {
                        void e;
                        FFDCFilter.processException((Throwable)resolverException, (String)"com.ibm.ws.security.saml.sso20.binding.BasicMessageContext", (String)"209", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                        Tr.debug((TraceComponent)tc, (String)"ResolverException in setIDPSSODescriptor : ", (Object[])new Object[]{e});
                    }
                }
                if (entityDescriptor == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Can not find a valid IDP Metadata for issuer:" + issuer), (Object[])new Object[0]);
                    }
                } else {
                    this.peerEntityMetadata = entityDescriptor;
                    this.idpSsoDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"IdP metadata does not exist, fall back to local trust store.", (Object[])new Object[0]);
            }
        }
    }

    public Assertion getValidatedAssertion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getValidatedAssertion(mc):" + this.validatedAssertion), (Object[])new Object[0]);
        }
        return this.validatedAssertion;
    }

    public void setValidatedAssertion(Assertion validatedAssertion) {
        this.validatedAssertion = validatedAssertion;
    }

    public UserData getUserDataIfReady() throws SamlException {
        if (this.validatedAssertion != null) {
            return new UserData(this.validatedAssertion, this.ssoService.getProviderId());
        }
        return null;
    }

    public void setKeyDecrypter() throws SamlException {
        if (this.decrypter == null) {
            Credential decryptingCredential = RequestUtil.getDecryptingCredential(this.ssoService);
            Set<Credential> credentials = Collections.singleton(decryptingCredential);
            ArrayList<Object> keyInfoProviders = new ArrayList<Object>();
            keyInfoProviders.add(new RSAKeyValueProvider());
            keyInfoProviders.add(new DSAKeyValueProvider());
            keyInfoProviders.add(new ECKeyValueProvider());
            keyInfoProviders.add(new DEREncodedKeyValueProvider());
            keyInfoProviders.add(new InlineX509DataProvider());
            keyInfoProviders.add(new AgreementMethodKeyInfoProvider());
            CollectionKeyInfoCredentialResolver credresolver = new CollectionKeyInfoCredentialResolver(credentials);
            StaticKeyInfoCredentialResolver staticKeyInfoResolver = new StaticKeyInfoCredentialResolver(decryptingCredential);
            LocalKeyInfoCredentialResolver localKeyInfoResolver = new LocalKeyInfoCredentialResolver(keyInfoProviders, (CredentialResolver)credresolver);
            ChainingKeyInfoCredentialResolver kekResolver = new ChainingKeyInfoCredentialResolver(Arrays.asList(localKeyInfoResolver, staticKeyInfoResolver));
            this.decrypter = new Decrypter(null, (KeyInfoCredentialResolver)kekResolver, (EncryptedKeyResolver)this.encryptedKeyResolver);
            this.decrypter.setRootInNewDocument(true);
        }
    }

    public Decrypter getDecrypter() throws SamlException {
        if (this.decrypter == null) {
            this.setKeyDecrypter();
        }
        return this.decrypter;
    }

    /*
     * WARNING - void declaration
     */
    public void setAndRemoveCachedRequestInfo(String externalRelayState, SsoRequest samlRequest) throws SamlException {
        this.externalRelayState = externalRelayState;
        this.samlRequest = samlRequest;
        if (externalRelayState != null) {
            Cache cache = this.ssoService.getAcsCookieCache(samlRequest.getProviderName());
            String cacheKey = externalRelayState.substring("sp_initial_".length());
            this.cachedRequestInfo = (HttpRequestInfo)cache.get(cacheKey);
            if (this.cachedRequestInfo == null) {
                try {
                    if (!this.ssoService.getConfig().isDisableInitialRequestCookie()) {
                        this.cachedRequestInfo = this.irUtil.recreateHttpRequestInfo(externalRelayState, this.request, this.response, this.ssoService);
                    }
                }
                catch (SamlException samlException) {
                    void e;
                    FFDCFilter.processException((Throwable)samlException, (String)"com.ibm.ws.security.saml.sso20.binding.BasicMessageContext", (String)"330", (Object)this, (Object[])new Object[]{externalRelayState, samlRequest});
                    Tr.debug((TraceComponent)tc, (String)"cannot recreate HttpRequestInfo using InitialRequest cookie", (Object[])new Object[]{e.getMessage()});
                    throw e;
                }
                if (this.cachedRequestInfo == null) {
                    throw new SamlException("SAML20_POTENTIAL_REPLAY_ATTACK", null, new Object[]{externalRelayState});
                }
            } else {
                cache.remove((Object)cacheKey);
                this.irUtil.removeCookie(externalRelayState, this.request, this.response);
            }
        }
    }

    public void setCachedRequestInfo(HttpRequestInfo requestInfo) {
        this.cachedRequestInfo = requestInfo;
    }

    public HttpRequestInfo getCachedRequestInfo() {
        return this.cachedRequestInfo;
    }

    public String getExternalRelayState() {
        return this.externalRelayState;
    }

    public SsoConfig getSsoConfig() {
        return this.ssoConfig;
    }

    public void setInResponseTo(String id) {
        this.inResponseTo = id;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    public void setSubjectNameIdentifier(NameID nameID) {
        this.subjectNameIdentifer = nameID;
    }

    public void setPeerEntityEndpoint(Endpoint entityEndpoint) {
        this.peerEntityEndpoint = entityEndpoint;
    }

    public Endpoint getPeerEntityEndpoint() {
        return this.peerEntityEndpoint;
    }

    public void setInboundSamlMessageIssuer(String issuer) {
        this.inboundMessageIssuer = issuer;
    }

    public String getInboundSamlMessageIssuer() {
        return this.inboundMessageIssuer;
    }
}

