/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import com.google.common.base.Predicates;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.Predicate;

public class StrategyIndirectedPredicate<T1, T2>
implements Predicate<T1> {
    @Nonnull
    private final Function<T1, T2> objectLookupStrategy;
    @Nonnull
    private final java.util.function.Predicate<T2> predicate;

    public StrategyIndirectedPredicate(@ParameterName(name="objectStrategy") @Nonnull Function<T1, T2> objectStrategy, @ParameterName(name="pred") @Nonnull java.util.function.Predicate<T2> pred) {
        this.objectLookupStrategy = Constraint.isNotNull(objectStrategy, "Object lookup strategy cannot be null");
        this.predicate = Constraint.isNotNull(pred, "Predicate cannot be null");
    }

    public StrategyIndirectedPredicate(@ParameterName(name="objectStrategy") @Nonnull Function<T1, T2> objectStrategy, @ParameterName(name="collection") @Nonnull Collection<T2> collection) {
        this.objectLookupStrategy = Constraint.isNotNull(objectStrategy, "Object lookup strategy cannot be null");
        this.predicate = Predicates.in(collection);
    }

    @Override
    public boolean test(@Nullable T1 input) {
        return this.predicate.test(this.objectLookupStrategy.apply(input));
    }

    @Nonnull
    public static <T1, T2> StrategyIndirectedPredicate<T1, T2> forPredicate(@Nonnull Function<T1, T2> objectStrategy, @Nonnull java.util.function.Predicate<T2> pred) {
        return new StrategyIndirectedPredicate<T1, T2>(objectStrategy, pred);
    }

    @Nonnull
    public static <T1, T2> StrategyIndirectedPredicate<T1, T2> forCollection(@Nonnull Function<T1, T2> objectStrategy, @Nonnull Collection<T2> collection) {
        return new StrategyIndirectedPredicate<T1, T2>(objectStrategy, collection);
    }
}

