/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.InvalidTopicSyntaxException;
import com.ibm.ws.sib.matchspace.tools.TopicSyntaxChecker;
import com.ibm.ws.sib.matchspace.utils.NLS;

public class XPathTopicSyntaxChecker
implements TopicSyntaxChecker {
    @Override
    public boolean checkTopicSyntax(String topic) throws InvalidTopicSyntaxException {
        this.checkTopicNotNull(topic);
        char[] chars = topic.toCharArray();
        boolean acceptSeparator = true;
        boolean acceptDot = false;
        boolean acceptStar = true;
        boolean acceptOrdinary = true;
        boolean prevSeparator = false;
        boolean hasWild = false;
        for (int i = 0; i < chars.length; ++i) {
            char cand = chars[i];
            if (cand == '*') {
                if (acceptStar) {
                    hasWild = true;
                    acceptDot = false;
                    prevSeparator = false;
                    acceptOrdinary = false;
                    acceptStar = false;
                    acceptSeparator = true;
                    continue;
                }
                throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0001", (Object[])new Object[]{topic, new Integer(i + 1)}));
            }
            if (cand == '.') {
                if (acceptDot) {
                    acceptOrdinary = !prevSeparator;
                    acceptDot = false;
                    prevSeparator = false;
                    acceptStar = false;
                    acceptSeparator = true;
                    continue;
                }
                throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0002", (Object[])new Object[]{topic, new Integer(i + 1)}));
            }
            if (cand == '/') {
                if (acceptSeparator) {
                    if (i == chars.length - 1) {
                        throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0003", (Object[])new Object[]{topic, new Integer(i + 1)}));
                    }
                    if (prevSeparator) {
                        acceptSeparator = false;
                        hasWild = true;
                        acceptDot = true;
                        continue;
                    }
                    prevSeparator = true;
                    acceptOrdinary = true;
                    acceptStar = true;
                    acceptDot = true;
                    continue;
                }
                throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0003", (Object[])new Object[]{topic, new Integer(i + 1)}));
            }
            if (cand == ':') {
                throw new InvalidTopicSyntaxException(NLS.format((String)"TEMPORARY_CWSIH9999", (Object[])new Object[]{" ':' characters are not allowed in topics. A ':' was found at character " + (i + 1)}));
            }
            if (!acceptOrdinary) {
                throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0004", (Object[])new Object[]{topic, new Integer(i + 1)}));
            }
            prevSeparator = false;
            acceptStar = false;
            acceptDot = true;
            acceptSeparator = true;
        }
        return hasWild;
    }

    private final void checkTopicNotNull(String topic) throws InvalidTopicSyntaxException {
        if (topic == null) {
            throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0005", (Object[])new Object[]{topic}));
        }
    }

    @Override
    public void checkEventTopicSyntax(String topic) throws InvalidTopicSyntaxException {
        this.checkTopicNotNull(topic);
        char[] chars = topic.toCharArray();
        boolean acceptDot = false;
        boolean acceptOrdinary = true;
        boolean prevSeparator = false;
        for (int i = 0; i < chars.length; ++i) {
            char cand = chars[i];
            if (cand == '*') {
                throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0006", (Object[])new Object[]{topic}));
            }
            if (cand == '.') {
                if (acceptDot) {
                    acceptDot = false;
                    prevSeparator = false;
                    acceptOrdinary = true;
                    continue;
                }
                throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0006", (Object[])new Object[]{topic}));
            }
            if (cand == '/') {
                if (i == chars.length - 1) {
                    throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0006", (Object[])new Object[]{topic}));
                }
                if (prevSeparator) {
                    throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0006", (Object[])new Object[]{topic}));
                }
                prevSeparator = true;
                acceptOrdinary = true;
                acceptDot = false;
                continue;
            }
            if (cand == ':') {
                throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0006", (Object[])new Object[]{topic}));
            }
            if (!acceptOrdinary) {
                throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0006", (Object[])new Object[]{topic}));
            }
            prevSeparator = false;
            acceptDot = true;
        }
    }
}

