/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;

public abstract class AnnotationLiteral<T extends Annotation>
implements Annotation,
Serializable {
    private static final long serialVersionUID = -1885320698638161810L;
    private Class<T> annotationType = this.getAnnotationType(this.getClass());
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    protected AnnotationLiteral() {
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    private Class<T> getAnnotationType(Class<?> definedClazz) {
        Type superClazz = definedClazz.getGenericSuperclass();
        Class clazz = null;
        if (superClazz.equals(Object.class)) {
            throw new RuntimeException("Super class must be parametrized type!");
        }
        if (superClazz instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)superClazz;
            Type[] actualArgs = paramType.getActualTypeArguments();
            if (actualArgs.length == 1) {
                Type type = actualArgs[0];
                if (type instanceof Class) {
                    clazz = (Class)type;
                    return clazz;
                }
                throw new RuntimeException("Not class type!");
            }
            throw new RuntimeException("More than one parametric type!");
        }
        return this.getAnnotationType((Class)superClazz);
    }

    @Override
    public boolean equals(Object other) {
        Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AnnotationLiteral.this.annotationType.getDeclaredMethods();
            }
        });
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof Annotation) {
            Annotation annotOther = (Annotation)other;
            if (this.annotationType().equals(annotOther.annotationType())) {
                Method[] methodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    Object value = this.callMethod(this, method);
                    Object annotValue = this.callMethod(annotOther, method);
                    if (value == null && annotValue != null || value != null && annotValue == null) {
                        return false;
                    }
                    if (value != null || annotValue != null) {
                        Class<?> type;
                        Class<?> valueClass = value.getClass();
                        Class<?> annotValueClass = annotValue.getClass();
                        if (valueClass.isPrimitive() && annotValueClass.isPrimitive() ? (valueClass != Float.TYPE && annotValue != Float.TYPE || valueClass != Double.TYPE && annotValue != Double.TYPE) && value != annotValue : (valueClass.isArray() && annotValueClass.isArray() ? ((type = valueClass.getComponentType()).isPrimitive() ? (Long.TYPE == type ? !Arrays.equals((Object[])((Long[])value), (Object[])((Long[])annotValue)) : (Integer.TYPE == type ? !Arrays.equals((Object[])((Integer[])value), (Object[])((Integer[])annotValue)) : (Short.TYPE == type ? !Arrays.equals((Object[])((Short[])value), (Object[])((Short[])annotValue)) : (Double.TYPE == type ? !Arrays.equals((Object[])((Double[])value), (Object[])((Double[])annotValue)) : (Float.TYPE == type ? !Arrays.equals((Object[])((Float[])value), (Object[])((Float[])annotValue)) : (Boolean.TYPE == type ? !Arrays.equals((Object[])((Boolean[])value), (Object[])((Boolean[])annotValue)) : (Byte.TYPE == type ? !Arrays.equals((Object[])((Byte[])value), (Object[])((Byte[])annotValue)) : Character.TYPE == type && !Arrays.equals((Object[])((Character[])value), (Object[])((Character[])annotValue))))))))) : !Arrays.equals((Object[])value, (Object[])annotValue)) : value != null && annotValue != null && !value.equals(annotValue))) {
                            return false;
                        }
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    private Object callMethod(Object instance, Method method) {
        Object object;
        boolean access = method.isAccessible();
        try {
            if (!method.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction(){
                    AccessibleObject object;
                    boolean flag;

                    PrivilegedAction init(AccessibleObject o, boolean f) {
                        this.object = o;
                        this.flag = f;
                        return this;
                    }

                    public Object run() {
                        this.object.setAccessible(this.flag);
                        return null;
                    }
                }.init(method, true));
            }
            object = method.invoke(instance, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Exception in method call : " + method.getName());
            }
            catch (Throwable throwable) {
                AccessController.doPrivileged(new PrivilegedAction(){
                    AccessibleObject object;
                    boolean flag;

                    PrivilegedAction init(AccessibleObject o, boolean f) {
                        this.object = o;
                        this.flag = f;
                        return this;
                    }

                    public Object run() {
                        this.object.setAccessible(this.flag);
                        return null;
                    }
                }.init(method, access));
                throw throwable;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */.init(method, access));
        return object;
    }

    @Override
    public int hashCode() {
        Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AnnotationLiteral.this.annotationType.getDeclaredMethods();
            }
        });
        int hashCode = 0;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            int name = 127 * method.getName().hashCode();
            Object object = this.callMethod(this, method);
            int value = 0;
            if (object.getClass().isArray()) {
                Class<?> type = object.getClass().getComponentType();
                if (type.isPrimitive()) {
                    if (Long.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Long[])object));
                    } else if (Integer.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Integer[])object));
                    } else if (Short.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Short[])object));
                    } else if (Double.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Double[])object));
                    } else if (Float.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Float[])object));
                    } else if (Boolean.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Long[])object));
                    } else if (Byte.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Byte[])object));
                    } else if (Character.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Character[])object));
                    }
                } else {
                    value = Arrays.hashCode((Object[])object);
                }
            } else {
                value = object.hashCode();
            }
            hashCode += name ^ value;
            ++n2;
        }
        return hashCode;
    }

    @Override
    public String toString() {
        Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AnnotationLiteral.this.annotationType.getDeclaredMethods();
            }
        });
        StringBuilder sb = new StringBuilder("@" + this.annotationType().getName() + "(");
        int lenght = methods.length;
        int i = 0;
        while (i < lenght) {
            sb.append(methods[i].getName()).append("=");
            sb.append(this.callMethod(this, methods[i]));
            if (i < lenght - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }
}

