/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.context;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import graphql.ExecutionInput;
import graphql.ParseAndValidate;
import graphql.ParseAndValidateResult;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.SelectedField;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.execution.QueryCache;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SmallRyeContext
implements Context {
    private static Schema schema;
    private static final InheritableThreadLocal<SmallRyeContext> current;
    private final JsonObject jsonObject;
    private final DataFetchingEnvironment dfe;
    private final ExecutionInput executionInput;
    private final Supplier<Document> documentSupplier;
    private final Field field;
    private final QueryCache queryCache;
    private static final JsonBuilderFactory jsonbuilder;
    static final long serialVersionUID = 4441889531728625427L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void register(JsonObject jsonInput) {
        SmallRyeContext registry = new SmallRyeContext(jsonInput);
        current.set(registry);
    }

    public static void setSchema(Schema schema) {
        SmallRyeContext.schema = schema;
    }

    public static SmallRyeContext getContext() {
        return (SmallRyeContext)current.get();
    }

    public static void setContext(SmallRyeContext context) {
        current.set(context);
    }

    public SmallRyeContext withDataFromExecution(ExecutionInput executionInput) {
        return new SmallRyeContext(this.jsonObject, this.dfe, executionInput, this.queryCache, this.field);
    }

    public SmallRyeContext withDataFromExecution(ExecutionInput executionInput, QueryCache queryCache) {
        return new SmallRyeContext(this.jsonObject, this.dfe, executionInput, queryCache, this.field);
    }

    public SmallRyeContext withDataFromFetcher(DataFetchingEnvironment dfe, Field field) {
        return new SmallRyeContext(this.jsonObject, dfe, this.executionInput, this.queryCache, field);
    }

    public static void remove() {
        current.remove();
    }

    @Override
    public JsonObject getRequest() {
        return this.jsonObject;
    }

    @Override
    public <T> T unwrap(Class<T> wrappedType) {
        if (wrappedType.equals(DataFetchingEnvironment.class)) {
            return (T)this.dfe;
        }
        if (wrappedType.equals(ExecutionInput.class)) {
            return (T)this.executionInput;
        }
        if (wrappedType.equals(Document.class)) {
            return (T)(this.documentSupplier != null ? this.documentSupplier.get() : null);
        }
        throw SmallRyeGraphQLServerMessages.msg.unsupportedWrappedClass(wrappedType.getName());
    }

    @Override
    public Boolean hasArgument(String name) {
        if (this.dfe != null) {
            return this.dfe.containsArgument(name);
        }
        return null;
    }

    @Override
    public <T> T getArgument(String name) {
        if (this.dfe != null) {
            return (T)this.dfe.getArgument(name);
        }
        return null;
    }

    @Override
    public Map<String, Object> getArguments() {
        if (this.dfe != null) {
            return this.dfe.getArguments();
        }
        return null;
    }

    @Override
    public String getPath() {
        if (this.dfe != null) {
            return this.dfe.getExecutionStepInfo().getPath().toString();
        }
        return null;
    }

    @Override
    public String getExecutionId() {
        if (this.dfe != null) {
            return this.dfe.getExecutionId().toString();
        }
        if (this.executionInput != null) {
            return this.executionInput.getExecutionId().toString();
        }
        return null;
    }

    @Override
    public String getFieldName() {
        if (this.dfe != null) {
            return this.dfe.getField().getName();
        }
        return null;
    }

    @Override
    public <T> T getSource() {
        if (this.dfe != null) {
            return (T)this.dfe.getSource();
        }
        return null;
    }

    @Override
    public JsonArray getSelectedFields(boolean includeSourceFields) {
        if (this.dfe != null) {
            DataFetchingFieldSelectionSet selectionSet = this.dfe.getSelectionSet();
            LinkedHashSet<SelectedField> fields = new LinkedHashSet<SelectedField>(selectionSet.getFields());
            return this.toJsonArrayBuilder(fields, includeSourceFields).build();
        }
        return null;
    }

    @Override
    public String getOperationType() {
        if (this.dfe != null) {
            return this.getOperationTypeFromDefinition(this.dfe.getOperationDefinition());
        }
        return null;
    }

    @Override
    public List<String> getRequestedOperationTypes() {
        ArrayList<String> allRequestedTypes = new ArrayList<String>();
        if (this.documentSupplier != null) {
            Document document = this.documentSupplier.get();
            List definitions = document.getDefinitionsOfType(OperationDefinition.class);
            for (OperationDefinition definition : definitions) {
                String operationType = this.getOperationTypeFromDefinition(definition);
                if (allRequestedTypes.contains(operationType)) continue;
                allRequestedTypes.add(operationType);
            }
        }
        return allRequestedTypes;
    }

    @Override
    public Optional<String> getParentTypeName() {
        if (this.dfe != null) {
            return this.getName(this.dfe.getParentType());
        }
        return Optional.empty();
    }

    private Optional<String> getName(GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLNamedType) {
            return Optional.of(((GraphQLNamedType)graphQLType).getName());
        }
        if (graphQLType instanceof GraphQLNonNull) {
            return this.getName(((GraphQLNonNull)graphQLType).getWrappedType());
        }
        if (graphQLType instanceof GraphQLList) {
            return this.getName(((GraphQLList)graphQLType).getWrappedType());
        }
        return Optional.empty();
    }

    private String getOperationTypeFromDefinition(OperationDefinition definition) {
        return definition.getOperation().toString();
    }

    public SmallRyeContext(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
        this.dfe = null;
        this.executionInput = null;
        this.queryCache = null;
        this.documentSupplier = null;
        this.field = null;
    }

    public SmallRyeContext(JsonObject jsonObject, DataFetchingEnvironment dfe, ExecutionInput executionInput, QueryCache queryCache, Field field) {
        this.jsonObject = jsonObject;
        this.dfe = dfe;
        this.field = field;
        this.executionInput = executionInput;
        this.queryCache = queryCache;
        this.documentSupplier = new DocumentSupplier(executionInput, queryCache);
    }

    private JsonArrayBuilder toJsonArrayBuilder(Set<SelectedField> fields, boolean includeSourceFields) {
        JsonArrayBuilder builder = jsonbuilder.createArrayBuilder();
        for (SelectedField field : fields) {
            if (this.isFlattenScalar(field) || !includeSourceFields && this.isSourceField(field)) continue;
            if (this.isScalar(field)) {
                builder = builder.add(field.getName());
                continue;
            }
            builder = builder.add(this.toJsonObjectBuilder(field, includeSourceFields));
        }
        return builder;
    }

    private JsonObjectBuilder toJsonObjectBuilder(SelectedField selectedField, boolean includeSourceFields) {
        JsonObjectBuilder builder = jsonbuilder.createObjectBuilder();
        LinkedHashSet<SelectedField> fields = new LinkedHashSet<SelectedField>(selectedField.getSelectionSet().getFields());
        builder = builder.add(selectedField.getName(), this.toJsonArrayBuilder(fields, includeSourceFields));
        return builder;
    }

    private boolean isSourceField(SelectedField selectedField) {
        if (this.field.getReference().getType().equals((Object)ReferenceType.TYPE)) {
            Type type = schema.getTypes().get(this.field.getReference().getName());
            return type.hasOperation(selectedField.getName());
        }
        return false;
    }

    private boolean isScalar(SelectedField field) {
        List fieldDefinitions = field.getFieldDefinitions();
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            GraphQLType graphQLType = this.unwrapGraphQLType((GraphQLType)fieldDefinition.getType());
            if (!this.isScalar(graphQLType)) continue;
            return true;
        }
        return false;
    }

    private boolean isScalar(GraphQLType gqlt) {
        return GraphQLScalarType.class.isAssignableFrom(gqlt.getClass());
    }

    private GraphQLType unwrapGraphQLType(GraphQLType gqlt) {
        if (this.isNonNull(gqlt)) {
            GraphQLNonNull graphQLNonNull = (GraphQLNonNull)gqlt;
            return this.unwrapGraphQLType(graphQLNonNull.getWrappedType());
        }
        if (this.isList(gqlt)) {
            GraphQLList graphQLList = (GraphQLList)gqlt;
            return this.unwrapGraphQLType(graphQLList.getWrappedType());
        }
        return gqlt;
    }

    private boolean isNonNull(GraphQLType gqlt) {
        return GraphQLNonNull.class.isAssignableFrom(gqlt.getClass());
    }

    private boolean isList(GraphQLType gqlt) {
        return GraphQLList.class.isAssignableFrom(gqlt.getClass());
    }

    private boolean isFlattenScalar(SelectedField field) {
        return field.getQualifiedName().contains("/");
    }

    public String toString() {
        return "SmallRyeContext {\nexecutionId = " + this.getExecutionId() + ",\nrequest = " + this.getRequest() + ",\noperationName = " + (String)this.getOperationName().orElse(null) + ",\noperationTypes = " + this.getRequestedOperationTypes() + ",\nparentTypeName = " + (String)this.getParentTypeName().orElse(null) + ",\nvariables = " + this.getVariables().orElse(null) + ",\nquery = " + this.getQuery() + ",\nfieldName = " + this.getFieldName() + ",\nselectedFields = " + this.getSelectedFields() + ",\nsource = " + this.getSource() + ",\narguments = " + this.getArguments() + ",\nfieldName = " + this.getFieldName() + ",\npath = " + this.getPath() + "\n}";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.smallrye.graphql.execution.context.SmallRyeContext", SmallRyeContext.class, null, null);
        current = new InheritableThreadLocal();
        jsonbuilder = Json.createBuilderFactory(null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class DocumentSupplier
    implements Supplier<Document> {
        private final ExecutionInput executionInput;
        private final QueryCache queryCache;
        static final long serialVersionUID = 8294804152114389389L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DocumentSupplier(ExecutionInput executionInput, QueryCache queryCache) {
            this.executionInput = executionInput;
            this.queryCache = queryCache;
        }

        @Override
        public Document get() {
            if (this.queryCache == null) {
                ParseAndValidateResult parse = ParseAndValidate.parse((ExecutionInput)this.executionInput);
                return parse.isFailure() ? null : parse.getDocument();
            }
            PreparsedDocumentEntry documentEntry = this.queryCache.getDocument(this.executionInput, ei -> {
                ParseAndValidateResult parse = ParseAndValidate.parse((ExecutionInput)ei);
                return parse.isFailure() ? new PreparsedDocumentEntry(parse.getErrors()) : new PreparsedDocumentEntry(parse.getDocument());
            });
            return documentEntry.hasErrors() ? null : documentEntry.getDocument();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.smallrye.graphql.execution.context.SmallRyeContext$DocumentSupplier", DocumentSupplier.class, null, null);
        }
    }
}

