/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.monitor;

import com.ibm.websphere.monitor.annotation.Args;
import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.ProbeAtEntry;
import com.ibm.websphere.monitor.annotation.ProbeAtReturn;
import com.ibm.websphere.monitor.annotation.ProbeSite;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.annotation.This;
import com.ibm.websphere.monitor.meters.MeterCollection;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.HttpRequest;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import io.openliberty.http.monitor.HttpServerStats;
import io.openliberty.http.monitor.HttpStatAttributes;
import io.openliberty.http.monitor.metrics.MetricsManager;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.GenericServlet;

@Monitor(group={"HTTP"})
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpServerStatsMonitor
extends StatisticActions {
    private static final TraceComponent tc = Tr.register(HttpServerStatsMonitor.class, null, null);
    private static final ThreadLocal<HttpStatAttributes.Builder> tl_httpStatsBuilder = new ThreadLocal();
    private static final ThreadLocal<Long> tl_startNanos = new ThreadLocal();
    private static final ConcurrentHashMap<String, Set<String>> appNameToStat = new ConcurrentHashMap();
    private static HttpServerStatsMonitor instance;
    @PublishedMetric
    public MeterCollection<HttpServerStats> HttpConnByRoute;
    static final long serialVersionUID = -7409270469903259021L;

    public HttpServerStatsMonitor() {
        if (instance == null) {
            instance = this;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("Multiple attempts to create %s. We already have an instance", HttpServerStatsMonitor.class.getName()), (Object[])new Object[0]);
        }
        this.HttpConnByRoute = new MeterCollection("HttpMetrics", (Object)this);
    }

    public static HttpServerStatsMonitor getInstance() {
        if (instance != null) {
            return instance;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("No instance of %s found", HttpServerStatsMonitor.class.getName()), (Object[])new Object[0]);
        }
        return null;
    }

    @ProbeAtReturn
    @ProbeSite(clazz="com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink", method="sendResponse", args="com.ibm.wsspi.http.channel.values.StatusCodes,java.lang.String,java.lang.Exception,boolean")
    public void atSendResponseReturn(@This Object probedHttpDispatcherLinkObj) {
        long elapsedNanos = System.nanoTime() - tl_startNanos.get();
        HttpStatAttributes.Builder retrievedHttpStatAttributesBuilder = tl_httpStatsBuilder.get();
        if (retrievedHttpStatAttributesBuilder == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to retrieve HttpStatAttributes. Unable to record time.", (Object[])new Object[0]);
            }
            return;
        }
        this.updateHttpStatDuration(retrievedHttpStatAttributesBuilder, Duration.ofNanos(elapsedNanos), null);
    }

    private void resolveNetworkProtocolInfo(String protocolInfo, HttpStatAttributes.Builder httpStatsBuilder) {
        String[] networkInfo = protocolInfo.trim().split("/");
        String networkProtocolName = null;
        String networkVersion = "";
        if (networkInfo.length == 1) {
            networkProtocolName = networkInfo[0].toLowerCase();
        } else if (networkInfo.length == 2) {
            networkProtocolName = networkInfo[0];
            networkVersion = networkInfo[1];
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("More values than expected when parsing protocol information: [%s]", protocolInfo), (Object[])new Object[0]);
        }
        httpStatsBuilder.withNetworkProtocolName(networkProtocolName);
        httpStatsBuilder.withNetworkProtocolVersion(networkVersion);
    }

    /*
     * WARNING - void declaration
     */
    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink", method="sendResponse", args="com.ibm.wsspi.http.channel.values.StatusCodes,java.lang.String,java.lang.Exception,boolean")
    public void atSendResponse(@This Object probedHttpDispatcherLinkObj, @Args Object[] myargs) {
        tl_httpStatsBuilder.set(null);
        tl_startNanos.set(System.nanoTime());
        HttpStatAttributes.Builder builder = HttpStatAttributes.builder();
        boolean is4xxCode = false;
        if (myargs.length > 0) {
            if (myargs[0] != null && myargs[0] instanceof StatusCodes) {
                StatusCodes statCode = (StatusCodes)myargs[0];
                builder.withResponseStatus(statCode.getIntCode());
                boolean bl = is4xxCode = statCode.getIntCode() % 400 <= 99;
            }
            if (myargs[2] != null && myargs[2] instanceof Exception) {
                Exception exception = (Exception)myargs[2];
                builder.withException(exception);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Could not resolve response code", (Object[])new Object[0]);
        }
        if (probedHttpDispatcherLinkObj != null) {
            block12: {
                HttpDispatcherLink httpDispatcherLink = (HttpDispatcherLink)probedHttpDispatcherLinkObj;
                builder.withServerName(httpDispatcherLink.getRequestedHost());
                builder.withServerPort(httpDispatcherLink.getRequestedPort());
                try {
                    HttpRequest httpRequest = httpDispatcherLink.getRequest();
                    if (!is4xxCode) {
                        builder.withHttpRoute(httpRequest.getURI());
                    } else {
                        builder.withHttpRoute("/");
                    }
                    builder.withRequestMethod(httpRequest.getMethod());
                    builder.withScheme(httpRequest.getScheme());
                    this.resolveNetworkProtocolInfo(httpRequest.getVersion(), builder);
                }
                catch (Exception httpRequest) {
                    void e;
                    FFDCFilter.processException((Throwable)httpRequest, (String)"io.openliberty.http.monitor.HttpServerStatsMonitor", (String)"187", (Object)((Object)this), (Object[])new Object[]{probedHttpDispatcherLinkObj, myargs});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                    Tr.debug((TraceComponent)tc, (String)String.format("Exception occured %s" + e, new Object[0]), (Object[])new Object[0]);
                }
            }
            tl_httpStatsBuilder.set(builder);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Failed to obtain HttpDispatcherLink Object from probe", (Object[])new Object[0]);
        }
    }

    public void updateHttpStatDuration(HttpStatAttributes.Builder builder, Duration duration, String appName) {
        HttpStatAttributes httpStatsAttributes = builder.build();
        if (httpStatsAttributes == null) {
            return;
        }
        String keyID = httpStatsAttributes.getHttpStatID();
        HttpServerStats httpServerStats = (HttpServerStats)this.HttpConnByRoute.get(keyID);
        if (httpServerStats == null && (httpServerStats = this.initializeHttpStat(keyID, httpStatsAttributes, appName)) == null) {
            return;
        }
        httpServerStats.updateDuration(duration);
        if (MetricsManager.getInstance() != null) {
            MetricsManager.getInstance().updateHttpMetrics(httpStatsAttributes, duration);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No Available Metric runtimes to forward HTTP stats to.", (Object[])new Object[0]);
        }
    }

    private synchronized HttpServerStats initializeHttpStat(String key, HttpStatAttributes statAttri, String appName) {
        if (this.HttpConnByRoute.get(key) != null) {
            return (HttpServerStats)this.HttpConnByRoute.get(key);
        }
        HttpServerStats httpMetricStats = new HttpServerStats(statAttri);
        this.HttpConnByRoute.put(key, (Object)httpMetricStats);
        if (this.HttpConnByRoute.get(key) == null) {
            return null;
        }
        if (appName != null) {
            appNameToStat.compute(appName, (appNameKey, currValSet) -> {
                if (currValSet == null) {
                    HashSet<String> hs = new HashSet<String>();
                    hs.add(key);
                    return hs;
                }
                currValSet.add(key);
                return currValSet;
            });
        }
        return httpMetricStats;
    }

    public void removeStat(String appName) {
        Set<String> retSet = appNameToStat.get(appName);
        if (retSet != null) {
            for (String statName : retSet) {
                this.HttpConnByRoute.remove(statName);
            }
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.webcontainer.servlet.ServletWrapper", method="destroy")
    public void atServletDestroy(@This GenericServlet s) {
        String appName = (String)s.getServletContext().getAttribute("com.ibm.websphere.servlet.enterprise.application.name");
        this.removeStat(appName);
    }
}

