/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.ext.ReaderInterceptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.ProvidersContextRetainer;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.interception.jaxrs.ClientReaderInterceptorContext;
import org.jboss.resteasy.plugins.providers.sse.EventInput;
import org.jboss.resteasy.specimpl.AbstractBuiltResponse;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.MarshalledEntity;
import org.jboss.resteasy.spi.util.Types;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.InputStreamToByteArray;
import org.jboss.resteasy.util.ReadFromStream;
import org.reactivestreams.Publisher;

public abstract class ClientResponse
extends BuiltResponse {
    protected Map<String, Object> properties;
    protected ClientConfiguration configuration;
    protected RESTEasyTracingLogger tracingLogger;

    @Deprecated
    protected ClientResponse(ClientConfiguration configuration) {
        this.setClientConfiguration(configuration);
        this.tracingLogger = RESTEasyTracingLogger.empty();
    }

    protected ClientResponse(ClientConfiguration configuration, RESTEasyTracingLogger tracingLogger) {
        this.setClientConfiguration(configuration);
        this.tracingLogger = tracingLogger;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.metadata = new Headers();
        this.metadata.putAll(headers);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setClientConfiguration(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.processor = configuration;
    }

    @Override
    public synchronized Object getEntity() {
        this.abortIfClosed();
        Object entity = super.getEntity();
        if (entity != null) {
            return this.checkEntityReadAsInputStreamFullyConsumed(entity);
        }
        return this.checkEntityReadAsInputStreamFullyConsumed(this.getEntityStream());
    }

    private <T> T checkEntityReadAsInputStreamFullyConsumed(T entity) {
        if (this.bufferedEntity == null && entity instanceof InputStream && this.streamFullyRead) {
            throw new IllegalStateException();
        }
        return entity;
    }

    @Override
    public Class<?> getEntityClass() {
        Class classs = super.getEntityClass();
        if (classs != null) {
            return classs;
        }
        Object entity = null;
        try {
            entity = this.getEntity();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entity != null ? entity.getClass() : null;
    }

    @Override
    public boolean hasEntity() {
        this.abortIfClosed();
        return this.getInputStream() != null && (this.entity != null || this.getMediaType() != null);
    }

    public void noReleaseConnection() {
        this.isClosed = true;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        try {
            this.isClosed = true;
            this.releaseConnection();
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    @Override
    protected HeaderValueProcessor getHeaderValueProcessor() {
        return this.configuration;
    }

    @Override
    protected InputStream getEntityStream() {
        if (this.bufferedEntity != null) {
            return new ByteArrayInputStream(this.bufferedEntity);
        }
        if (this.isClosed()) {
            throw new ProcessingException(Messages.MESSAGES.streamIsClosed());
        }
        InputStream is = this.getInputStream();
        return is != null ? new AbstractBuiltResponse.InputStreamWrapper<ClientResponse>(is, this) : null;
    }

    @Override
    protected abstract void setInputStream(InputStream var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized <T> Object readFrom(Class<T> type, Type genericType, MediaType media, Annotation[] annotations) {
        Type useGeneric = genericType == null ? type : genericType;
        Class<Object> useType = type;
        media = media == null ? MediaType.WILDCARD_TYPE : media;
        annotations = annotations == null ? this.annotations : annotations;
        boolean isMarshalledEntity = false;
        if (type.equals(MarshalledEntity.class)) {
            isMarshalledEntity = true;
            ParameterizedType param = (ParameterizedType)useGeneric;
            useGeneric = param.getActualTypeArguments()[0];
            useType = Types.getRawType(useGeneric);
        }
        Providers current = ResteasyContext.getContextData(Providers.class);
        ResteasyContext.pushContext(Providers.class, this.configuration);
        Object obj = null;
        try {
            Object finalObj;
            InputStream is = this.getEntityStream();
            if (is == null) {
                throw new IllegalStateException(Messages.MESSAGES.inputStreamWasEmpty());
            }
            if (isMarshalledEntity) {
                is = new InputStreamToByteArray(is);
            }
            ReaderInterceptor[] readerInterceptors = this.configuration.getReaderInterceptors(null, null);
            long timestamp = this.tracingLogger.timestamp("RI_SUMMARY");
            ClientReaderInterceptorContext context = new ClientReaderInterceptorContext(readerInterceptors, this.configuration.getProviderFactory(), useType, useGeneric, annotations, media, this.getStringHeaders(), is, this.properties, this.tracingLogger);
            try {
                obj = finalObj = context.proceed();
            }
            catch (Throwable throwable) {
                this.tracingLogger.logDuration("RI_SUMMARY", timestamp, context.getProcessedInterceptorCount());
                throw throwable;
            }
            this.tracingLogger.logDuration("RI_SUMMARY", timestamp, context.getProcessedInterceptorCount());
            if (isMarshalledEntity) {
                InputStreamToByteArray isba = (InputStreamToByteArray)is;
                final byte[] bytes = isba.toByteArray();
                MarshalledEntity<Object> marshalledEntity = new MarshalledEntity<Object>(){

                    @Override
                    public byte[] getMarshalledBytes() {
                        return bytes;
                    }

                    @Override
                    public Object getEntity() {
                        return finalObj;
                    }
                };
                return marshalledEntity;
            }
            Object object = finalObj;
            return object;
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (Exception ex) {
            throw new ProcessingException((Throwable)ex);
        }
        finally {
            if (!Publisher.class.isAssignableFrom(type) && !EventInput.class.isAssignableFrom(type)) {
                ResteasyContext.popContextData(Providers.class);
                if (current != null) {
                    ResteasyContext.pushContext(Providers.class, current);
                }
                if (obj instanceof ProvidersContextRetainer) {
                    ((ProvidersContextRetainer)obj).setProviders(this.configuration);
                }
            }
        }
    }

    @Override
    public boolean bufferEntity() {
        this.abortIfClosed();
        if (this.bufferedEntity != null) {
            return true;
        }
        if (this.streamRead) {
            return false;
        }
        if (this.metadata.getFirst("Content-Type") == null) {
            return false;
        }
        InputStream is = this.getInputStream();
        if (is == null) {
            return false;
        }
        try {
            this.bufferedEntity = ReadFromStream.readFromStream(1024, is);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        finally {
            try {
                this.releaseConnection();
            }
            catch (IOException e) {
                throw new ProcessingException((Throwable)e);
            }
        }
        return true;
    }

    @Override
    public void abortIfClosed() {
        if (this.bufferedEntity == null) {
            super.abortIfClosed();
        }
    }
}

