/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.indirection.WrappingValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class ProtectedValueHolder
extends DatabaseValueHolder
implements WrappingValueHolder {
    protected transient ValueHolderInterface<?> wrappedValueHolder;
    protected transient DatabaseMapping mapping;

    public ProtectedValueHolder(ValueHolderInterface<?> attributeValue, DatabaseMapping mapping, AbstractSession cloningSession) {
        this.wrappedValueHolder = attributeValue;
        this.mapping = mapping;
        this.session = cloningSession;
    }

    @Override
    protected Object instantiate() throws DatabaseException {
        if (this.session == null) {
            throw ValidationException.instantiatingValueholderWithNullSession();
        }
        Integer refreshCascade = null;
        if (this.wrappedValueHolder instanceof QueryBasedValueHolder) {
            refreshCascade = ((QueryBasedValueHolder)this.getWrappedValueHolder()).getRefreshCascadePolicy();
        }
        Object clone = this.mapping.buildCloneForPartObject(this.wrappedValueHolder.getValue(), null, null, null, this.session, refreshCascade, true, true);
        if (this.wrappedValueHolder.isInstantiated() && refreshCascade != null) {
            ((QueryBasedValueHolder)this.getWrappedValueHolder()).setRefreshCascadePolicy(null);
        }
        return clone;
    }

    @Override
    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        throw ValidationException.operationNotSupported("instantiateForUnitOfWorkValueHolder");
    }

    @Override
    public boolean isPessimisticLockingValueHolder() {
        return false;
    }

    @Override
    public ValueHolderInterface<?> getWrappedValueHolder() {
        return this.wrappedValueHolder;
    }
}

