/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec.tokens;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.jakartasec.tokens.CloneClaimsAction;
import io.openliberty.security.jakartasec.tokens.JwtClaimsImpl;
import jakarta.security.enterprise.identitystore.openid.IdentityToken;
import jakarta.security.enterprise.identitystore.openid.JwtClaims;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IdentityTokenImpl
implements IdentityToken,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String tokenString;
    private final Map<String, Object> idTokenClaimsMap;
    private final JwtClaims jwtClaims;
    private final Long tokenMinValidityInMillis;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public IdentityTokenImpl(String tokenString, Map<String, Object> idTokenClaimsMap, Long tokenMinValidityInMillis) {
        this.tokenString = tokenString;
        this.idTokenClaimsMap = idTokenClaimsMap;
        this.jwtClaims = new JwtClaimsImpl(idTokenClaimsMap);
        this.tokenMinValidityInMillis = tokenMinValidityInMillis;
    }

    public String getToken() {
        return this.tokenString;
    }

    public JwtClaims getJwtClaims() {
        return this.jwtClaims;
    }

    public boolean isExpired() {
        Instant expirationInstant = (Instant)this.jwtClaims.getExpirationTime().get();
        Instant nowInstant = Instant.now();
        return nowInstant.isAfter(expirationInstant) || nowInstant.plusMillis(this.tokenMinValidityInMillis).isAfter(expirationInstant);
    }

    public Map<String, Object> getClaims() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CloneClaimsAction action = new CloneClaimsAction(result);
        this.idTokenClaimsMap.forEach(action);
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.jakartasec.tokens.IdentityTokenImpl", IdentityTokenImpl.class, (String)"OpenIdConnect", (String)"io.openliberty.security.jakartasec.internal.resources.JakartaSecurity30Messages");
    }
}

