/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.cmdline;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.feature.internal.cmdline.NLS;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import com.ibm.ws.kernel.feature.internal.generator.DefaultConfigurationList;
import com.ibm.ws.kernel.feature.internal.generator.FeatureList;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListOptions;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListUtils;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FeatureListAction
implements ActionHandler {
    static final long serialVersionUID = 7825029974159848973L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ReturnCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        FeatureListOptions options = new FeatureListOptions();
        String val = args.getOption("locale");
        if (val != null) {
            int index = val.indexOf(95);
            String lang = index == -1 ? val : val.substring(0, index);
            options.setLocale(index == -1 ? new Locale(lang) : new Locale(lang, val.substring(index + 1)));
        }
        if ((val = args.getOption("encoding")) != null) {
            options.setEncoding(val);
        }
        if ((val = args.getOption("productextension")) != null) {
            options.setProductName(val);
        }
        if ((val = args.getOption("includeinternals")) != null) {
            options.setIncludeInternals(Boolean.parseBoolean(val));
        }
        options.setOutputFile((String)args.getPositionalArguments().get(0));
        ManifestFileProcessor mfp = new ManifestFileProcessor();
        String productName = options.getProductName();
        boolean coreProduct = productName.equals("core");
        Map<String, ProvisioningFeatureDefinition> features = mfp.getFeatureDefinitions(productName);
        Map<String, ProvisioningFeatureDefinition> coreFeatures = coreProduct ? null : mfp.getFeatureDefinitions("core");
        String location = mfp.getProdFeatureLocation(productName);
        String productId = mfp.getProdFeatureId(productName);
        if (!coreProduct) {
            if (features == null) {
                if (location != null) {
                    System.out.println(MessageFormat.format(NLS.messages.getString("tool.product.ext.not.found"), productName, location));
                    return ReturnCode.PRODUCT_EXT_NOT_FOUND;
                }
                System.out.println(MessageFormat.format(NLS.messages.getString("tool.product.ext.not.defined"), productName));
                return ReturnCode.PRODUCT_EXT_NOT_DEFINED;
            }
            if (features.isEmpty()) {
                System.out.println(MessageFormat.format(NLS.messages.getString("tool.product.ext.features.not.found"), productName));
                return ReturnCode.PRODUCT_EXT_NO_FEATURES_FOUND;
            }
        }
        FeatureListUtils utils = new FeatureListUtils(options);
        FeatureList fl = new FeatureList(options, features, coreFeatures, utils);
        utils.writeStartDocument();
        utils.startFeatureInfo(options.getProductName(), location, productId);
        fl.writeFeatureList(mfp);
        DefaultConfigurationList dcl = new DefaultConfigurationList(options, features, utils);
        dcl.writeDefaultConfiguration(mfp);
        utils.endFeatureInfo();
        utils.writeEndDocument();
        FeatureListOptions.ReturnCode rc = options.getReturnCode();
        if (rc == FeatureListOptions.ReturnCode.OK) {
            return ReturnCode.OK;
        }
        if (rc == FeatureListOptions.ReturnCode.BAD_ARGUMENT) {
            return ReturnCode.BAD_ARGUMENT;
        }
        return ReturnCode.RUNTIME_EXCEPTION;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.cmdline.FeatureListAction", FeatureListAction.class, null, null);
    }
}

