/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.SslRefInfo;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.crypto.SecretKey;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SslRefInfoImpl
implements SslRefInfo {
    public static final TraceComponent tc = Tr.register(SslRefInfoImpl.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    SSLSupport sslSupport = null;
    String sslRef = null;
    JSSEHelper jsseHelper = null;
    String sslKeyStoreName = null;
    String sslTrustStoreName = null;
    private String keyAliasName = null;
    AtomicServiceReference<KeyStoreService> keyStoreServiceRef = null;
    static final long serialVersionUID = -7776680581627730651L;

    @ManualTrace
    public SslRefInfoImpl(SSLSupport sslSupport, AtomicServiceReference<KeyStoreService> keyStoreServiceRef, String sslRef, String keyAliasName) {
        String methodName = "<init>";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{sslSupport, keyStoreServiceRef, sslRef, keyAliasName});
        }
        this.sslSupport = sslSupport;
        this.sslRef = sslRef;
        this.keyStoreServiceRef = keyStoreServiceRef;
        this.keyAliasName = keyAliasName;
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    @Override
    @ManualTrace
    public String getTrustStoreName() throws MpJwtProcessingException {
        String methodName = "getTrustStoreName";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.sslTrustStoreName == null) {
            this.init();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.sslTrustStoreName);
        }
        return this.sslTrustStoreName;
    }

    @Override
    @ManualTrace
    public String getKeyStoreName() throws MpJwtProcessingException {
        String methodName = "getKeyStoreName";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.sslKeyStoreName == null) {
            this.init();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.sslKeyStoreName);
        }
        return this.sslKeyStoreName;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    void init() throws MpJwtProcessingException {
        String methodName = "init";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        this.setUpJsseHelper();
        if (this.jsseHelper == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName);
            }
            return;
        }
        Properties sslProps = null;
        try {
            sslProps = this.getSslPropertiesFromJsseHelper();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.mp.jwt.impl.SslRefInfoImpl", (String)"110", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_LOADING_SSL_PROPS", (Object[])new Object[]{e.getLocalizedMessage()});
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg, (Throwable)e);
        }
        this.setKeystoreAndTruststoreNames(sslProps);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    void setUpJsseHelper() {
        if (this.sslSupport == null) {
            return;
        }
        this.jsseHelper = this.sslSupport.getJSSEHelper();
    }

    Properties getSslPropertiesFromJsseHelper() throws SSLException {
        if (this.sslRef != null) {
            return this.getSslPropertiesFromSslRef();
        }
        return this.getSslPropertiesFromConnectionInfo();
    }

    Properties getSslPropertiesFromSslRef() throws SSLException {
        return this.jsseHelper.getProperties(this.sslRef);
    }

    @ManualTrace
    Properties getSslPropertiesFromConnectionInfo() throws SSLException {
        String methodName = "getSslPropertiesFromConnectionInfo";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        HashMap<String, String> connectionInfo = new HashMap<String, String>();
        connectionInfo.put("com.ibm.ssl.direction", "inbound");
        Properties props = this.jsseHelper.getProperties(null, connectionInfo, null, true);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)props);
        }
        return props;
    }

    void setKeystoreAndTruststoreNames(Properties sslProps) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sslConfig (" + this.sslRef + ") get: " + sslProps), (Object[])new Object[0]);
        }
        if (sslProps != null) {
            this.sslKeyStoreName = sslProps.getProperty("com.ibm.ssl.keyStoreName");
            this.sslTrustStoreName = sslProps.getProperty("com.ibm.ssl.trustStoreName");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sslTrustStoreName: " + this.sslTrustStoreName), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public HashMap<String, PublicKey> getPublicKeys() throws MpJwtProcessingException {
        String methodName = "getPublicKeys";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.jsseHelper == null) {
            this.init();
        }
        HashMap<String, PublicKey> publicKeys = new HashMap<String, PublicKey>();
        if (this.sslTrustStoreName == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, publicKeys);
            }
            return publicKeys;
        }
        try {
            publicKeys = this.getPublicKeysFromKeystore();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.mp.jwt.impl.SslRefInfoImpl", (String)"191", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"FAILED_TO_LOAD_PUBLIC_KEYS", (Object[])new Object[]{this.sslTrustStoreName, e.getLocalizedMessage()});
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg, (Throwable)e);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, publicKeys);
        }
        return publicKeys;
    }

    HashMap<String, PublicKey> getPublicKeysFromKeystore() throws MpJwtProcessingException {
        KeyStoreService keyStoreService = this.getKeyStoreService();
        return this.getPublicKeysFromTrustedCertAliases(keyStoreService);
    }

    KeyStoreService getKeyStoreService() throws MpJwtProcessingException {
        KeyStoreService keyStoreService = (KeyStoreService)this.keyStoreServiceRef.getService();
        if (keyStoreService == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"KEYSTORE_SERVICE_NOT_FOUND", (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg);
        }
        return keyStoreService;
    }

    HashMap<String, PublicKey> getPublicKeysFromTrustedCertAliases(KeyStoreService keyStoreService) throws MpJwtProcessingException {
        Collection<String> names = this.getTrustedCertAliases(keyStoreService);
        if (names == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Did not find any trusted certificate aliases in the keystore", (Object[])new Object[0]);
            }
            return new HashMap<String, PublicKey>();
        }
        return this.getPublicKeysFromAliasNames(keyStoreService, names);
    }

    /*
     * WARNING - void declaration
     */
    Collection<String> getTrustedCertAliases(KeyStoreService keyStoreService) throws MpJwtProcessingException {
        try {
            return keyStoreService.getTrustedCertEntriesInKeyStore(this.sslTrustStoreName);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.mp.jwt.impl.SslRefInfoImpl", (String)"232", (Object)this, (Object[])new Object[]{keyStoreService});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_LOADING_KEYSTORE_CERTIFICATES", (Object[])new Object[]{this.sslTrustStoreName, e.getLocalizedMessage()});
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg, (Throwable)e);
        }
    }

    @ManualTrace
    HashMap<String, PublicKey> getPublicKeysFromAliasNames(KeyStoreService keyStoreService, Collection<String> names) throws MpJwtProcessingException {
        String methodName = "getPublicKeysFromAliasNames";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        HashMap<String, PublicKey> publicKeys = new HashMap<String, PublicKey>();
        if (names == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, publicKeys);
            }
            return publicKeys;
        }
        for (String aliasName : names) {
            PublicKey publicKey = this.getPublicKeyFromAlias(keyStoreService, aliasName);
            publicKeys.put(aliasName, publicKey);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, publicKeys);
        }
        return publicKeys;
    }

    /*
     * WARNING - void declaration
     */
    PublicKey getPublicKeyFromAlias(KeyStoreService keyStoreService, String aliasName) throws MpJwtProcessingException {
        try {
            return keyStoreService.getCertificateFromKeyStore(this.sslTrustStoreName, aliasName).getPublicKey();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.mp.jwt.impl.SslRefInfoImpl", (String)"264", (Object)this, (Object[])new Object[]{keyStoreService, aliasName});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_LOADING_CERTIFICATE", (Object[])new Object[]{aliasName, this.sslTrustStoreName, e.getLocalizedMessage()});
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg, (Throwable)e);
        }
    }

    @Override
    @ManualTrace
    @FFDCIgnore(value={Exception.class})
    public PublicKey getPublicKey() throws MpJwtProcessingException {
        String methodName = "getPublicKey";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (this.jsseHelper == null) {
            this.init();
        }
        if (this.sslKeyStoreName == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, null);
            }
            return null;
        }
        try {
            PublicKey key = this.getKeyFromKeyAliasOrFirstAvailable();
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)key);
            }
            return key;
        }
        catch (Exception e) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"FAILED_TO_LOAD_PUBLIC_KEY", (Object[])new Object[]{this.sslKeyStoreName, e.getLocalizedMessage()});
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg, e);
        }
    }

    PublicKey getKeyFromKeyAliasOrFirstAvailable() throws MpJwtProcessingException {
        if (this.isKeyAliasConfigured()) {
            return this.getKeyFromKeyAlias();
        }
        return this.getFirstAvailableKey();
    }

    boolean isKeyAliasConfigured() {
        return this.keyAliasName != null && !this.keyAliasName.trim().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    PublicKey getKeyFromKeyAlias() throws MpJwtProcessingException {
        KeyStoreService keyStoreService = this.getKeyStoreService();
        try {
            return keyStoreService.getCertificateFromKeyStore(this.sslKeyStoreName, this.keyAliasName).getPublicKey();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.mp.jwt.impl.SslRefInfoImpl", (String)"318", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_LOADING_CERTIFICATE", (Object[])new Object[]{this.keyAliasName, this.sslTrustStoreName, e.getLocalizedMessage()});
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    PublicKey getFirstAvailableKey() throws MpJwtProcessingException {
        String methodName = "getFirstAvailableKey";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        Iterator<Map.Entry<String, PublicKey>> publicKeysIterator = null;
        try {
            publicKeysIterator = this.getPublicKeys().entrySet().iterator();
        }
        catch (MpJwtProcessingException mpJwtProcessingException) {
            void e;
            FFDCFilter.processException((Throwable)mpJwtProcessingException, (String)"com.ibm.ws.security.mp.jwt.impl.SslRefInfoImpl", (String)"334", (Object)this, (Object[])new Object[0]);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"FAILED_TO_LOAD_FIRST_AVAILABLE_KEY", (Object[])new Object[]{this.sslTrustStoreName, e.getLocalizedMessage()});
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw e;
        }
        if (publicKeysIterator.hasNext()) {
            PublicKey key = publicKeysIterator.next().getValue();
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)key);
            }
            return key;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, null);
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey() throws MpJwtProcessingException {
        return null;
    }

    @Override
    public SecretKey getSecretKey() throws MpJwtProcessingException {
        return null;
    }
}

