/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transaction.services;

import com.ibm.tx.config.RuntimeMetaDataProvider;
import com.ibm.tx.jta.embeddable.GlobalTransactionSettings;
import com.ibm.tx.jta.embeddable.TransactionSettingsProvider;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transaction.services.JTMConfigurationProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyRuntimeMetaDataProvider
implements RuntimeMetaDataProvider {
    private static final TraceComponent tc = Tr.register(LibertyRuntimeMetaDataProvider.class, (String)"transaction", (String)"com.ibm.ws.transaction.services.TransactionMessages");
    private final JTMConfigurationProvider _serverWideConfigProvider;
    static final long serialVersionUID = -5840226944083080184L;

    public LibertyRuntimeMetaDataProvider(JTMConfigurationProvider cp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LibertyRuntimeMetaDataProvider {0} {1}", (Object[])new Object[]{cp, this});
        }
        this._serverWideConfigProvider = cp;
    }

    public int getTransactionTimeout() {
        for (TransactionSettingsProvider s : this._serverWideConfigProvider.getTransactionSettingsProviders().services()) {
            if (s.isActive()) {
                GlobalTransactionSettings gts = s.getGlobalTransactionSettings();
                if (gts != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found a GlobalTransactionSettings", (Object[])new Object[0]);
                    }
                    return gts.getTransactionTimeout();
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"No GlobalTransactionSettings on this thread", (Object[])new Object[0]);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"Found the TransactionSettingsProvider but it was inactive", (Object[])new Object[0]);
        }
        return -1;
    }

    public boolean isClientSideJTADemarcationAllowed() {
        return false;
    }

    @Trivial
    public boolean isHeuristicHazardAccepted() {
        return this._serverWideConfigProvider.isAcceptHeuristicHazard();
    }

    public boolean isUserTransactionLookupPermitted(String arg0) {
        return true;
    }
}

