/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.semconv.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.internal.HttpConstants;
import io.opentelemetry.instrumentation.api.internal.HttpRouteState;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class HttpServerRouteBuilder<REQUEST> {
    final HttpServerAttributesGetter<REQUEST, ?> getter;
    Set<String> knownMethods = HttpConstants.KNOWN_METHODS;

    HttpServerRouteBuilder(HttpServerAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @CanIgnoreReturnValue
    public HttpServerRouteBuilder<REQUEST> setKnownMethods(Collection<String> knownMethods) {
        this.knownMethods = new HashSet<String>(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerRouteBuilder<REQUEST> setKnownMethods(Set<String> knownMethods) {
        return this.setKnownMethods((Collection<String>)knownMethods);
    }

    public ContextCustomizer<REQUEST> build() {
        HashSet<String> knownMethods = new HashSet<String>(this.knownMethods);
        return (context, request, startAttributes) -> {
            if (HttpRouteState.fromContextOrNull(context) != null) {
                return context;
            }
            String method = this.getter.getHttpRequestMethod(request);
            if (method == null || !knownMethods.contains(method)) {
                method = "HTTP";
            }
            return context.with(HttpRouteState.create(method, null, 0));
        };
    }
}

