/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import jakarta.faces.FacesException;
import jakarta.faces.application.ViewExpiredException;
import jakarta.faces.context.ExternalContext;
import jakarta.servlet.ServletContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.spi.SerialFactory;

public final class StateUtils {
    private static final Logger log = Logger.getLogger(StateUtils.class.getName());
    public static final String ZIP_CHARSET = "ISO-8859-1";
    public static final String DEFAULT_ALGORITHM = "AES";
    public static final String DEFAULT_ALGORITHM_PARAMS = "ECB/PKCS5Padding";
    public static final String INIT_PREFIX = "org.apache.myfaces.";
    public static final String USE_ENCRYPTION = "org.apache.myfaces.USE_ENCRYPTION";
    public static final String INIT_SECRET = "org.apache.myfaces.SECRET";
    public static final String INIT_ALGORITHM = "org.apache.myfaces.ALGORITHM";
    public static final String INIT_SECRET_KEY_CACHE = "org.apache.myfaces.SECRET.CACHE";
    public static final String INIT_ALGORITHM_IV = "org.apache.myfaces.ALGORITHM.IV";
    public static final String INIT_ALGORITHM_PARAM = "org.apache.myfaces.ALGORITHM.PARAMETERS";
    public static final String SERIAL_FACTORY = "org.apache.myfaces.SERIAL_FACTORY";
    public static final String COMPRESS_STATE_IN_CLIENT = "org.apache.myfaces.COMPRESS_STATE_IN_CLIENT";
    public static final String DEFAULT_MAC_ALGORITHM = "HmacSHA256";
    public static final String INIT_MAC_ALGORITHM = "org.apache.myfaces.MAC_ALGORITHM";
    public static final String INIT_MAC_SECRET = "org.apache.myfaces.MAC_SECRET";
    public static final String INIT_MAC_SECRET_KEY_CACHE = "org.apache.myfaces.MAC_SECRET.CACHE";

    private StateUtils() {
    }

    private static void testConfiguration(ExternalContext ctx) {
        String iv;
        String algorithmParams = ctx.getInitParameter(INIT_ALGORITHM_PARAM);
        if (algorithmParams != null && algorithmParams.startsWith("CBC") && (iv = ctx.getInitParameter(INIT_ALGORITHM_IV)) == null) {
            throw new FacesException("org.apache.myfaces.ALGORITHM.PARAMETERS parameter has been set with CBC mode, but no initialization vector has been set  with org.apache.myfaces.ALGORITHM.IV");
        }
    }

    public static Cipher createCipher(ExternalContext externalContext, int mode) throws Exception {
        SecretKey secretKey = StateUtils.getSecret(externalContext);
        String algorithm = StateUtils.findAlgorithm(externalContext);
        String algorithmParams = StateUtils.findAlgorithmParams(externalContext);
        byte[] iv = StateUtils.findInitializationVector(externalContext);
        Cipher cipher = Cipher.getInstance(algorithm + "/" + algorithmParams);
        if (iv != null) {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(mode, (Key)secretKey, ivSpec);
        } else {
            cipher.init(mode, secretKey);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("De/encrypting with " + algorithm + "/" + algorithmParams);
        }
        return cipher;
    }

    public static Mac createMac(ExternalContext externalContext) throws Exception {
        SecretKey macSecretKey = StateUtils.getMacSecret(externalContext);
        String macAlgorithm = StateUtils.findMacAlgorithm(externalContext);
        Mac mac = Mac.getInstance(macAlgorithm);
        mac.init(macSecretKey);
        return mac;
    }

    public static boolean enableCompression(ExternalContext externalContext) {
        Assert.notNull(externalContext, "externalContext");
        return "true".equals(externalContext.getInitParameter(COMPRESS_STATE_IN_CLIENT));
    }

    public static boolean isSecure(ExternalContext externalContext) {
        Assert.notNull(externalContext, "externalContext");
        return !"false".equals(externalContext.getInitParameter(USE_ENCRYPTION));
    }

    public static final String construct(Object object, ExternalContext ctx) {
        byte[] bytes = StateUtils.getAsByteArray(object, ctx);
        if (StateUtils.enableCompression(ctx)) {
            bytes = StateUtils.compress(bytes);
        }
        if (StateUtils.isSecure(ctx)) {
            bytes = StateUtils.encrypt(bytes, ctx);
        }
        bytes = StateUtils.encode(bytes);
        try {
            return new String(bytes, ZIP_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final byte[] getAsByteArray(Object object, ExternalContext ctx) {
        SerialFactory serialFactory = (SerialFactory)ctx.getApplicationMap().get(SERIAL_FACTORY);
        Assert.notNull(serialFactory, "serialFactory");
        try {
            return serialFactory.toByteArray(object);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static byte[] encrypt(byte[] insecure, ExternalContext externalContext) {
        Assert.notNull(externalContext, "externalContext");
        StateUtils.testConfiguration(externalContext);
        try {
            Mac mac = StateUtils.createMac(externalContext);
            Cipher cipher = StateUtils.createCipher(externalContext, 1);
            int macLenght = mac.getMacLength();
            byte[] secure = new byte[cipher.getOutputSize(insecure.length) + macLenght];
            int secureCount = cipher.doFinal(insecure, 0, insecure.length, secure);
            mac.update(secure, 0, secureCount);
            mac.doFinal(secure, secureCount);
            return secure;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static final byte[] compress(byte[] bytes) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzip = new GZIPOutputStream(baos);){
                gzip.write(bytes, 0, bytes.length);
                gzip.finish();
                gzip.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final byte[] encode(byte[] bytes) {
        return Base64.getEncoder().encode(bytes);
    }

    public static final Object reconstruct(String string, ExternalContext ctx) {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Processing state : " + string);
                log.fine("Processing serialized viewstate string with hashCode : " + string.hashCode());
            }
            byte[] bytes = string.getBytes(ZIP_CHARSET);
            bytes = StateUtils.decode(bytes);
            if (StateUtils.isSecure(ctx)) {
                bytes = StateUtils.decrypt(bytes, ctx);
            }
            if (StateUtils.enableCompression(ctx)) {
                bytes = StateUtils.decompress(bytes);
            }
            return StateUtils.getAsObject(bytes, ctx);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "View State cannot be reconstructed", e);
            }
            return null;
        }
    }

    public static final byte[] decode(byte[] bytes) {
        return Base64.getDecoder().decode(bytes);
    }

    public static final byte[] decompress(byte[] bytes) {
        byte[] byArray;
        Assert.notNull(bytes, "bytes");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                 GZIPInputStream gis = new GZIPInputStream(bais);){
                int length;
                byte[] buffer = new byte[bytes.length];
                while ((length = gis.read(buffer)) != -1) {
                    baos.write(buffer, 0, length);
                }
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }

    public static byte[] decrypt(byte[] secure, ExternalContext externalContext) {
        Assert.notNull(externalContext, "externalContext");
        StateUtils.testConfiguration(externalContext);
        try {
            Mac mac = StateUtils.createMac(externalContext);
            Cipher cipher = StateUtils.createCipher(externalContext, 2);
            int macLenght = mac.getMacLength();
            mac.update(secure, 0, secure.length - macLenght);
            byte[] signedDigestHash = mac.doFinal();
            boolean isMacEqual = true;
            for (int i = 0; i < signedDigestHash.length; ++i) {
                if (signedDigestHash[i] == secure[secure.length - macLenght + i]) continue;
                isMacEqual = false;
            }
            if (!isMacEqual) {
                throw new ViewExpiredException();
            }
            return cipher.doFinal(secure, 0, secure.length - macLenght);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final Object getAsObject(byte[] bytes, ExternalContext ctx) {
        SerialFactory serialFactory = (SerialFactory)ctx.getApplicationMap().get(SERIAL_FACTORY);
        Assert.notNull(serialFactory, "serialFactory");
        try {
            return serialFactory.toObject(bytes);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        byte[] bytes = StateUtils.encode(args[0].getBytes(ZIP_CHARSET));
        System.out.println(new String(bytes, ZIP_CHARSET));
    }

    private static byte[] findInitializationVector(ExternalContext ctx) {
        byte[] iv = null;
        String ivString = ctx.getInitParameter(INIT_ALGORITHM_IV);
        if (ivString != null) {
            iv = StateUtils.decode(ivString.getBytes());
        }
        return iv;
    }

    private static String findAlgorithmParams(ExternalContext ctx) {
        String algorithmParams = ctx.getInitParameter(INIT_ALGORITHM_PARAM);
        if (algorithmParams == null) {
            algorithmParams = DEFAULT_ALGORITHM_PARAMS;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using algorithm paramaters " + algorithmParams);
        }
        return algorithmParams;
    }

    private static String findAlgorithm(ExternalContext ctx) {
        String algorithm = ctx.getInitParameter(INIT_ALGORITHM);
        return StateUtils.findAlgorithm(algorithm);
    }

    private static String findAlgorithm(ServletContext ctx) {
        String algorithm = ctx.getInitParameter(INIT_ALGORITHM);
        return StateUtils.findAlgorithm(algorithm);
    }

    private static String findAlgorithm(String initParam) {
        if (initParam == null) {
            initParam = DEFAULT_ALGORITHM;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using algorithm " + initParam);
        }
        return initParam;
    }

    public static void initSecret(ServletContext servletContext) {
        String macCache;
        String cache;
        Assert.notNull(servletContext, "servletContext");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Storing SecretKey @ org.apache.myfaces.SECRET.CACHE");
        }
        if (!"false".equals(cache = servletContext.getInitParameter(INIT_SECRET_KEY_CACHE))) {
            String algorithm = StateUtils.findAlgorithm(servletContext);
            servletContext.setAttribute(INIT_SECRET_KEY_CACHE, (Object)new SecretKeySpec(StateUtils.findSecret(servletContext, algorithm), algorithm));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Storing SecretKey @ org.apache.myfaces.MAC_SECRET.CACHE");
        }
        if (!"false".equals(macCache = servletContext.getInitParameter(INIT_MAC_SECRET_KEY_CACHE))) {
            String macAlgorithm = StateUtils.findMacAlgorithm(servletContext);
            servletContext.setAttribute(INIT_MAC_SECRET_KEY_CACHE, (Object)new SecretKeySpec(StateUtils.findMacSecret(servletContext, macAlgorithm), macAlgorithm));
        }
    }

    private static SecretKey getSecret(ExternalContext ctx) {
        Object secretKey = ctx.getApplicationMap().get(INIT_SECRET_KEY_CACHE);
        if (secretKey == null) {
            String cache = ctx.getInitParameter(INIT_SECRET_KEY_CACHE);
            if ("false".equals(cache)) {
                String secret = ctx.getInitParameter(INIT_SECRET);
                if (secret == null) {
                    throw new NullPointerException("Could not find secret using key 'org.apache.myfaces.SECRET'");
                }
                String algorithm = StateUtils.findAlgorithm(ctx);
                secretKey = new SecretKeySpec(StateUtils.findSecret(ctx, algorithm), algorithm);
            } else {
                throw new NullPointerException("Could not find SecretKey in application scope using key 'org.apache.myfaces.SECRET.CACHE'");
            }
        }
        if (!(secretKey instanceof SecretKey)) {
            throw new ClassCastException("Did not find an instance of SecretKey in application scope using the key 'org.apache.myfaces.SECRET.CACHE'");
        }
        return (SecretKey)secretKey;
    }

    private static byte[] findSecret(ExternalContext ctx, String algorithm) {
        String secret = ctx.getInitParameter(INIT_SECRET);
        return StateUtils.findSecret(secret, algorithm);
    }

    private static byte[] findSecret(ServletContext ctx, String algorithm) {
        String secret = ctx.getInitParameter(INIT_SECRET);
        return StateUtils.findSecret(secret, algorithm);
    }

    private static byte[] findSecret(String secret, String algorithm) {
        byte[] bytes;
        block5: {
            bytes = null;
            if (secret == null) {
                try {
                    KeyGenerator kg = KeyGenerator.getInstance(algorithm);
                    bytes = kg.generateKey().getEncoded();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Generated random password of length " + bytes.length);
                    }
                    break block5;
                }
                catch (NoSuchAlgorithmException e) {
                    int length = 16;
                    bytes = new byte[length];
                    new Random().nextBytes(bytes);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Generated random password of length " + length);
                    }
                    break block5;
                }
            }
            bytes = StateUtils.decode(secret.getBytes());
        }
        return bytes;
    }

    private static String findMacAlgorithm(ExternalContext ctx) {
        String algorithm = ctx.getInitParameter(INIT_MAC_ALGORITHM);
        return StateUtils.findMacAlgorithm(algorithm);
    }

    private static String findMacAlgorithm(ServletContext ctx) {
        String algorithm = ctx.getInitParameter(INIT_MAC_ALGORITHM);
        return StateUtils.findMacAlgorithm(algorithm);
    }

    private static String findMacAlgorithm(String initParam) {
        if (initParam == null) {
            initParam = DEFAULT_MAC_ALGORITHM;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using algorithm " + initParam);
        }
        return initParam;
    }

    private static SecretKey getMacSecret(ExternalContext ctx) {
        Object secretKey = ctx.getApplicationMap().get(INIT_MAC_SECRET_KEY_CACHE);
        if (secretKey == null) {
            String cache = ctx.getInitParameter(INIT_MAC_SECRET_KEY_CACHE);
            if ("false".equals(cache)) {
                String secret = ctx.getInitParameter(INIT_MAC_SECRET);
                if (secret == null) {
                    throw new NullPointerException("Could not find secret using key 'org.apache.myfaces.MAC_SECRET'");
                }
                String macAlgorithm = StateUtils.findMacAlgorithm(ctx);
                secretKey = new SecretKeySpec(StateUtils.findMacSecret(ctx, macAlgorithm), macAlgorithm);
            } else {
                throw new NullPointerException("Could not find SecretKey in application scope using key 'org.apache.myfaces.MAC_SECRET.CACHE'");
            }
        }
        if (!(secretKey instanceof SecretKey)) {
            throw new ClassCastException("Did not find an instance of SecretKey in application scope using the key 'org.apache.myfaces.MAC_SECRET.CACHE'");
        }
        return (SecretKey)secretKey;
    }

    private static byte[] findMacSecret(ExternalContext ctx, String algorithm) {
        String secret = ctx.getInitParameter(INIT_MAC_SECRET);
        return StateUtils.findMacSecret(secret, algorithm);
    }

    private static byte[] findMacSecret(ServletContext ctx, String algorithm) {
        String secret = ctx.getInitParameter(INIT_MAC_SECRET);
        return StateUtils.findMacSecret(secret, algorithm);
    }

    private static byte[] findMacSecret(String secret, String algorithm) {
        byte[] bytes;
        block5: {
            bytes = null;
            if (secret == null) {
                try {
                    KeyGenerator kg = KeyGenerator.getInstance(algorithm);
                    bytes = kg.generateKey().getEncoded();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Generated random mac password of length " + bytes.length);
                    }
                    break block5;
                }
                catch (NoSuchAlgorithmException e) {
                    int length = 8;
                    bytes = new byte[length];
                    new Random().nextBytes(bytes);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Generated random mac password of length " + length);
                    }
                    break block5;
                }
            }
            bytes = StateUtils.decode(secret.getBytes());
        }
        return bytes;
    }
}

