/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.ApplicationProcessor;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(OpenAPIServlet.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ApplicationProcessor applicationProcessor = ApplicationProcessor.getInstance();
        if (request.getMethod().equals("GET")) {
            String formatParam;
            if (applicationProcessor == null) {
                PrintWriter writer = response.getWriter();
                ((Writer)writer).write("Failed to find OpenAPI application processor");
                response.setStatus(404);
            }
            String acceptHeader = "";
            acceptHeader = request.getHeader("Accept");
            String format = "yaml";
            if (acceptHeader != null && this.jsonRequested(acceptHeader)) {
                format = "json";
            }
            if ((formatParam = request.getParameter("format")) != null && formatParam.equals("json")) {
                format = "json";
            }
            response.setCharacterEncoding("UTF-8");
            if (format.equals("json")) {
                String document = applicationProcessor.getOpenAPIDocument(request, ApplicationProcessor.DocType.JSON);
                if (document != null) {
                    response.setContentType("application/json");
                    PrintWriter writer = response.getWriter();
                    ((Writer)writer).write(document);
                } else {
                    if (OpenAPIUtils.isEventEnabled((TraceComponent)tc)) {
                        Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Null document (json). Return 500.", (Object[])new Object[0]);
                    }
                    response.setStatus(500);
                }
            } else {
                String document = applicationProcessor.getOpenAPIDocument(request, ApplicationProcessor.DocType.YAML);
                if (document != null) {
                    response.setContentType("text/plain");
                    PrintWriter writer = response.getWriter();
                    ((Writer)writer).write(document);
                } else {
                    if (OpenAPIUtils.isEventEnabled((TraceComponent)tc)) {
                        Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Null document (yaml). Return 500.", (Object[])new Object[0]);
                    }
                    response.setStatus(500);
                }
            }
        } else {
            if (OpenAPIUtils.isEventEnabled((TraceComponent)tc)) {
                Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Invalid method. Return 405.", (Object[])new Object[0]);
            }
            response.setStatus(405);
        }
    }

    private boolean jsonRequested(String acceptHeader) {
        for (String acceptedType : acceptHeader.split(",")) {
            if (!acceptedType.trim().equals("application/json")) continue;
            return true;
        }
        return false;
    }
}

