/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChainGroupData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.wsspi.channelfw.ChannelFramework;
import java.util.Arrays;
import java.util.List;

public abstract class ChannelUtilsBase {
    static final String EOLN = System.getProperty("line.separator");

    protected final void traceChains(Object logTool, ChannelFramework cfw, Class<?> factory, String message, String prefix) {
        ChainData[] chains = null;
        String fstring = "(" + (factory == null ? "no factory specified" : factory.getName()) + ")";
        if (cfw == null) {
            this.debugTrace(logTool, prefix + " - No cfw to test factory " + fstring, new Object[0]);
            return;
        }
        try {
            chains = factory != null ? cfw.getAllChains(factory) : cfw.getAllChains();
        }
        catch (Exception e) {
            this.debugTrace(logTool, "Caught Exception while trying to display configured chains: ", e);
            return;
        }
        if (chains == null || chains.length <= 0) {
            this.debugTrace(logTool, prefix + " - No chains found for factory " + fstring, new Object[0]);
        } else {
            this.traceChains(logTool, Arrays.asList(chains), message, prefix);
        }
    }

    protected final void traceChains(Object logTool, ChannelFramework cfw, String groupName, String message, String prefix) {
        String gstring = "(" + (groupName == null ? "no group specified" : groupName) + ")";
        if (cfw == null) {
            this.debugTrace(logTool, prefix + " - No cfw to test group " + gstring, new Object[0]);
        } else if (groupName == null) {
            this.debugTrace(logTool, prefix + " - No group specified", new Object[0]);
        }
        if (cfw == null || groupName == null) {
            return;
        }
        ChainGroupData chainGroup = null;
        ChainData[] chains = null;
        try {
            chainGroup = cfw.getChainGroup(groupName);
            if (chainGroup != null) {
                chains = chainGroup.getChains();
            }
        }
        catch (Exception e) {
            this.debugTrace(logTool, "Caught Exception while trying to display configured chains: ", e);
            return;
        }
        if (chains == null || chains.length <= 0) {
            this.debugTrace(logTool, prefix + " - No chains defined for group " + gstring, new Object[0]);
        } else {
            this.traceChains(logTool, Arrays.asList(chains), message, prefix);
        }
    }

    protected final void traceChains(Object logTool, List<?> lchain, String message, String prefix) {
        if (lchain == null || lchain.size() <= 0) {
            this.debugTrace(logTool, prefix + " - Specified chain list is empty", new Object[0]);
            return;
        }
        StringBuilder traceMessage = new StringBuilder(300);
        traceMessage.append(message);
        traceMessage.append(EOLN);
        for (ChainData chain : lchain) {
            traceMessage.append(prefix + "-chain ");
            traceMessage.append(chain.getName());
            traceMessage.append(chain.getType().equals(FlowType.OUTBOUND) ? " - OUTBOUND" : " - INBOUND");
            traceMessage.append(EOLN);
            List<ChannelData> lchannel = Arrays.asList(chain.getChannelList());
            for (ChannelData channel : lchannel) {
                traceMessage.append(prefix + "-chain ");
                traceMessage.append(chain.getName());
                traceMessage.append(":       +  ");
                traceMessage.append(channel.getName());
                traceMessage.append(" - ");
                traceMessage.append(channel.getFactoryType());
                traceMessage.append(EOLN);
            }
        }
        this.debugTrace(logTool, traceMessage.toString(), new Object[0]);
    }

    protected final void traceChannels(Object logTool, ChannelFramework cfw, String message, String prefix) {
        if (cfw == null) {
            this.debugTrace(logTool, prefix + " - No cfw to trace channels", new Object[0]);
            return;
        }
        StringBuilder traceMessage = new StringBuilder(300);
        traceMessage.append(prefix + ": Configured Channels - ");
        if (message != null) {
            traceMessage.append(message);
        }
        traceMessage.append(EOLN);
        ChannelData[] channelList = cfw.getAllChannels();
        List<ChannelData> lchannel = Arrays.asList(channelList);
        for (ChannelData channel : lchannel) {
            traceMessage.append(prefix + ":    ");
            traceMessage.append(channel.getName());
            traceMessage.append(" - ");
            traceMessage.append(channel.getFactoryType());
            traceMessage.append(EOLN);
        }
        this.debugTrace(logTool, traceMessage.toString(), new Object[0]);
    }

    protected final void traceDebugStack(Object logTool, Throwable t, String message) {
        StackTraceElement[] stack = t.getStackTrace();
        if (stack != null) {
            StringBuilder stackTrace = new StringBuilder();
            for (int i = 0; i < stack.length; ++i) {
                stackTrace.append(EOLN);
                stackTrace.append(stack[i].toString());
            }
            this.debugTrace(logTool, message + EOLN + stackTrace.toString(), new Object[0]);
        }
    }

    public final void traceThreadStack(Object logTool, Thread thread) {
        StackTraceElement[] stack = thread.getStackTrace();
        if (stack != null) {
            StringBuilder stackTrace = new StringBuilder("TRACEBACK for Thread " + thread.getName() + ": ");
            for (int i = 0; i < stack.length; ++i) {
                stackTrace.append(EOLN);
                stackTrace.append(stack[i].toString());
            }
            this.debugTrace(logTool, EOLN + stackTrace.toString(), new Object[0]);
        }
    }

    protected abstract void debugTrace(Object var1, String var2, Object ... var3);
}

