/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.basic.internal;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.Trivial;

@Trivial
class BasicPassword {
    private final boolean isHashed;
    private final ProtectedString password;
    private final String hashedPassword;

    BasicPassword(@Sensitive String password) {
        this(password, false);
    }

    BasicPassword(@Sensitive String password, boolean isHashed) {
        this.isHashed = isHashed;
        if (isHashed) {
            this.password = null;
            this.hashedPassword = password;
        } else {
            ProtectedString ps = null;
            if (password != null && password.length() > 0) {
                ps = new ProtectedString(password.toCharArray());
            }
            this.password = ps;
            this.hashedPassword = null;
        }
    }

    boolean isHashed() {
        return this.isHashed;
    }

    ProtectedString getPassword() {
        return this.password;
    }

    String getHashedPassword() {
        return this.hashedPassword;
    }

    public String toString() {
        return "****";
    }
}

