/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.invokable;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

class CleanupActions
implements Consumer<Runnable> {
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();
    private final List<Instance.Handle<?>> dependentInstances = new ArrayList();

    CleanupActions() {
    }

    @Override
    public void accept(Runnable runnable) {
        this.cleanupTasks.add(runnable);
    }

    public void addInstanceHandle(Instance.Handle<?> handle) {
        if (handle.getBean().getScope().equals(Dependent.class)) {
            this.dependentInstances.add(handle);
        }
    }

    public void cleanup() {
        for (Runnable runnable : this.cleanupTasks) {
            runnable.run();
        }
        this.cleanupTasks.clear();
        for (Instance.Handle handle : this.dependentInstances) {
            handle.destroy();
        }
        this.dependentInstances.clear();
    }

    public static <R> R run(Throwable cause, R returnValue, CleanupActions cleanupActions) {
        cleanupActions.cleanup();
        return returnValue;
    }

    public static void run(Throwable cause, CleanupActions cleanupActions) {
        cleanupActions.cleanup();
    }
}

