/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.MarshalException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.attachment.AttachmentMarshaller;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBase;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;
import org.apache.cxf.jaxb.MarshallerEventHandler;
import org.apache.cxf.jaxb.attachment.JAXBAttachmentMarshaller;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.ws.commons.schema.XmlSchemaElement;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class DataWriterImpl<T>
extends JAXBDataBase
implements DataWriter<T> {
    private static final Logger LOG = LogUtils.getLogger(DataWriterImpl.class);
    ValidationEventHandler veventHandler;
    boolean setEventHandler;
    boolean noEscape;
    private JAXBDataBinding databinding;
    private Bus bus;
    static final long serialVersionUID = -7744514192352175155L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DataWriterImpl(Bus bus, JAXBDataBinding binding) {
        this(bus, binding, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "<init>", new Object[]{bus, binding});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DataWriterImpl(Bus bus, JAXBDataBinding binding, boolean noEsc) {
        super(binding.getContext());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "<init>", new Object[]{bus, binding, noEsc});
        }
        this.setEventHandler = true;
        this.databinding = binding;
        this.noEscape = noEsc;
        this.bus = bus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void write(Object obj, T output) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "write", new Object[]{obj, output});
        }
        this.write(obj, null, output);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "write");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProperty(String prop, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "setProperty", new Object[]{prop, value});
        }
        if (prop.equals(Message.class.getName())) {
            Message m = (Message)value;
            this.veventHandler = this.getValidationEventHandler(m, "jaxb-writer-validation-event-handler");
            if (this.veventHandler == null) {
                this.veventHandler = this.databinding.getValidationEventHandler();
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Validation event handler: " + (this.veventHandler != null ? this.veventHandler.getClass().getCanonicalName() : "null"));
            }
            this.setEventHandler = MessageUtils.getContextualBoolean((Message)m, (String)"set-jaxb-validation-event-handler", (boolean)true);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "setProperty");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Marshaller createMarshaller(Object elValue, MessagePartInfo part) {
        Marshaller marshaller;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "createMarshaller", new Object[]{elValue, part});
        }
        boolean isLoggableFinest = LOG.isLoggable(Level.FINEST);
        try {
            marshaller = this.databinding.getJAXBMarshaller(this.noEscape, this.setEventHandler, this.bus, this.veventHandler);
            marshaller.setSchema(this.schema);
            AttachmentMarshaller atmarsh = this.getAttachmentMarshaller();
            if (isLoggableFinest) {
                LOG.finest("Setting AttachmentMarshaller: " + (atmarsh != null ? atmarsh.getClass().getName() : "null"));
            }
            marshaller.setAttachmentMarshaller(atmarsh);
            if (this.schema != null && atmarsh instanceof JAXBAttachmentMarshaller) {
                if (isLoggableFinest) {
                    LOG.finest("Setting MtomValidationHandler on marshaller.");
                }
                marshaller.setEventHandler((ValidationEventHandler)new MtomValidationHandler(marshaller.getEventHandler(), (JAXBAttachmentMarshaller)atmarsh));
            }
        }
        catch (MarshalException ex) {
            org.apache.cxf.common.i18n.Message faultMessage = new org.apache.cxf.common.i18n.Message("MARSHAL_ERROR", LOG, new Object[]{ex.getLinkedException().getMessage()});
            throw new Fault(faultMessage, (Throwable)ex);
        }
        catch (JAXBException ex) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("MARSHAL_ERROR", LOG, new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        for (XmlAdapter<?, ?> adapter : this.databinding.getConfiguredXmlAdapters()) {
            marshaller.setAdapter(adapter);
        }
        Marshaller marshaller2 = marshaller;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            marshaller2 = marshaller2;
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "createMarshaller", marshaller2);
        }
        return marshaller2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void setContextualNamespaceDecls(Object mapper, Map<String, String> nsctxt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "setContextualNamespaceDecls", new Object[]{mapper, nsctxt});
        }
        try {
            Method m = ReflectionUtil.getDeclaredMethod(mapper.getClass(), (String)"setContextualNamespaceDecls", (Class[])new Class[]{String[].class});
            String[] args = new String[nsctxt.size() * 2];
            int ai = 0;
            for (Map.Entry<String, String> nsp : nsctxt.entrySet()) {
                args[ai++] = nsp.getValue();
                args[ai++] = nsp.getKey();
            }
            m.invoke(mapper, new Object[]{args});
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to set the contextual namespace map", e);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "setContextualNamespaceDecls");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void write(Object obj, MessagePartInfo part, T output) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "write", new Object[]{obj, part, output});
        }
        boolean honorJaxbAnnotation = this.honorJAXBAnnotations(part);
        if (part != null && !part.isElement() && part.getTypeClass() != null) {
            honorJaxbAnnotation = true;
        }
        this.checkPart(part, obj);
        Marshaller marshaller = null;
        if (obj != null || !(part.getXmlSchema() instanceof XmlSchemaElement)) {
            if (obj instanceof Exception && part != null && Boolean.TRUE.equals(part.getProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION"))) {
                marshaller = this.createMarshaller(obj, part);
                JAXBEncoderDecoder.marshallException(marshaller, (Exception)obj, part, output);
                this.onCompleteMarshalling();
            } else {
                Annotation[] anns = this.getJAXBAnnotation(part);
                if (!honorJaxbAnnotation || anns.length == 0) {
                    marshaller = this.createMarshaller(obj, part);
                    JAXBEncoderDecoder.marshall(marshaller, obj, part, output);
                    this.onCompleteMarshalling();
                } else if (honorJaxbAnnotation && anns.length > 0) {
                    JAXBEncoderDecoder.marshalWithBridge(part.getConcreteName(), part.getTypeClass(), anns, this.databinding.getContextClasses(), obj, output, this.getAttachmentMarshaller());
                }
            }
        } else if (this.needToRender(part)) {
            marshaller = this.createMarshaller(null, part);
            JAXBEncoderDecoder.marshallNullElement(marshaller, output, part);
            this.onCompleteMarshalling();
        }
        this.databinding.releaseJAXBMarshaller(marshaller, this.noEscape);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "write");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void checkPart(MessagePartInfo part, Object object) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "checkPart", new Object[]{part, object});
        }
        if (part == null || part.getTypeClass() == null || object == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "checkPart");
            }
            return;
        }
        Class typeClass = part.getTypeClass();
        if (typeClass == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "checkPart");
            }
            return;
        }
        if (typeClass.isPrimitive()) {
            if (typeClass == Long.TYPE) {
                typeClass = Long.class;
            } else if (typeClass == Integer.TYPE) {
                typeClass = Integer.class;
            } else if (typeClass == Short.TYPE) {
                typeClass = Short.class;
            } else if (typeClass == Byte.TYPE) {
                typeClass = Byte.class;
            } else if (typeClass == Character.TYPE) {
                typeClass = Character.class;
            } else if (typeClass == Double.TYPE) {
                typeClass = Double.class;
            } else if (typeClass == Float.TYPE) {
                typeClass = Float.class;
            } else if (typeClass == Boolean.TYPE) {
                typeClass = Boolean.class;
            }
        } else if (typeClass.isArray() && object instanceof Collection) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "checkPart");
            }
            return;
        }
        if (!typeClass.isInstance(object)) {
            throw new IllegalArgumentException("Part " + part.getName() + " should be of type " + typeClass.getName() + ", not " + object.getClass().getName());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "checkPart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean needToRender(MessagePartInfo part) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "needToRender", new Object[]{part});
        }
        if (part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)part.getXmlSchema();
            boolean bl = element.isNillable() && element.getMinOccurs() > 0L;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "needToRender", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "needToRender", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void onCompleteMarshalling() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.io.DataWriterImpl", "onCompleteMarshalling", new Object[0]);
        }
        if (this.setEventHandler && this.veventHandler instanceof MarshallerEventHandler) {
            try {
                ((MarshallerEventHandler)this.veventHandler).onMarshalComplete();
            }
            catch (MarshalException e) {
                if (e.getLinkedException() != null) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("MARSHAL_ERROR", LOG, new Object[]{e.getLinkedException().getMessage()}), (Throwable)e);
                }
                throw new Fault(new org.apache.cxf.common.i18n.Message("MARSHAL_ERROR", LOG, new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.io.DataWriterImpl", "onCompleteMarshalling");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class MtomValidationHandler
    implements ValidationEventHandler {
        ValidationEventHandler origHandler;
        JAXBAttachmentMarshaller marshaller;
        static final long serialVersionUID = 724280149791600595L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        MtomValidationHandler(ValidationEventHandler v, JAXBAttachmentMarshaller m) {
            this.origHandler = v;
            this.marshaller = m;
        }

        public boolean handleEvent(ValidationEvent event) {
            String msg = event.getMessage();
            if ((msg.startsWith("cvc-type.3.1.2") || msg.startsWith("cvc-complex-type.2.2")) && msg.contains(this.marshaller.getLastMTOMElementName().getLocalPart())) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Event message starts with cvc, returning true: " + msg);
                }
                return true;
            }
            if (this.origHandler != null) {
                return this.origHandler.handleEvent(event);
            }
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.io.DataWriterImpl$MtomValidationHandler", MtomValidationHandler.class, null, null);
        }
    }
}

