/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.websphere.logging.hpel.reader.AbstractRemoteRepositoryReader;
import com.ibm.websphere.logging.hpel.reader.LogRepositoryException;
import com.ibm.websphere.logging.hpel.reader.LogRepositoryRuntimeException;
import com.ibm.websphere.logging.hpel.reader.RemoteInstanceDetails;
import com.ibm.websphere.logging.hpel.reader.RemoteInstanceResult;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecordHeader;
import com.ibm.websphere.logging.hpel.reader.RepositoryPointer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class RemoteLogRecordIterator
implements Iterator<RepositoryLogRecord> {
    private final AbstractRemoteRepositoryReader reader;
    private final RemoteInstanceDetails indicator;
    private final Locale locale;
    private final ArrayList<RepositoryLogRecord> logRecordList = new ArrayList();
    private int curPos = 0;
    private int leftToRead;
    private RepositoryPointer pointer;
    private int offset = 0;

    public RemoteLogRecordIterator(AbstractRemoteRepositoryReader reader, RemoteInstanceDetails indicator, RepositoryPointer pointer, int offset, int length, Locale locale) {
        this.reader = reader;
        this.indicator = indicator;
        this.pointer = pointer;
        this.offset = offset;
        this.leftToRead = length;
        this.locale = locale;
    }

    @Override
    public boolean hasNext() {
        if (this.curPos >= this.logRecordList.size()) {
            this.loadNext();
        }
        return this.curPos < this.logRecordList.size();
    }

    @Override
    public RepositoryLogRecord next() {
        RepositoryLogRecordHeader result = null;
        if (this.curPos >= this.logRecordList.size()) {
            this.loadNext();
        }
        if (this.curPos < this.logRecordList.size()) {
            result = this.logRecordList.get(this.curPos++);
        }
        this.pointer = result == null ? null : result.getRepositoryPointer();
        return result;
    }

    private void loadNext() {
        boolean hadRecords = !this.logRecordList.isEmpty();
        this.logRecordList.clear();
        this.curPos = 0;
        if (this.leftToRead != 0) {
            RemoteInstanceResult remoteResult;
            try {
                int read;
                boolean firstRead = true;
                while ((remoteResult = this.reader.readLogRecords(this.indicator, this.pointer, this.offset, read = this.reader.getMaxRecords() > 0 && (this.leftToRead < 0 || this.reader.getMaxRecords() < this.leftToRead) ? this.reader.getMaxRecords() : this.leftToRead, this.locale)).getLogList().size() <= 0 && this.leftToRead != read && this.reader.getMaxRecords() > 0) {
                    if (this.offset < 0) {
                        if (this.offset + read >= 0) {
                            break;
                        }
                    } else if (this.leftToRead < 0) {
                        RemoteInstanceResult temp;
                        if (hadRecords || (temp = this.reader.readLogRecords(this.indicator, null, -1, 1, null)).getLogList().size() == 0) break;
                        if (firstRead) {
                            int tmpRead;
                            int tmpOffset;
                            for (tmpOffset = this.offset; tmpOffset > 0 && (temp = this.reader.readLogRecords(this.indicator, null, tmpOffset - (tmpRead = tmpOffset < this.reader.getMaxRecords() ? tmpOffset : this.reader.getMaxRecords()), tmpRead, null)).getLogList().size() <= 0; tmpOffset -= this.reader.getMaxRecords()) {
                            }
                            if (tmpOffset <= 0) break;
                        }
                    }
                    if (this.leftToRead >= read) {
                        this.leftToRead -= read;
                    } else if (this.leftToRead >= 0) break;
                    this.offset += read;
                    firstRead = false;
                }
                this.indicator.setCache(remoteResult.getCache());
            }
            catch (LogRepositoryException e) {
                throw new LogRepositoryRuntimeException(e);
            }
            ArrayList<RepositoryLogRecord> newList = remoteResult.getLogList();
            if (newList != null && newList.size() > 0) {
                this.leftToRead -= newList.size();
                this.logRecordList.addAll(newList);
            } else {
                this.leftToRead = 0;
            }
            if (this.offset < 0 && this.indicator.getCache().isComplete()) {
                this.offset += this.indicator.getCache().getSize();
                if (this.offset < 0) {
                    this.leftToRead += this.offset;
                    if (this.leftToRead < 0) {
                        this.leftToRead = 0;
                    }
                }
            }
            this.offset = 0;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Method is not applicable to this class");
    }
}

