/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.beans;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.cdi.beans.Utils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.credential.UsernamePasswordCredential;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import javax.security.auth.Subject;

@Default
@ApplicationScoped
@LoginToContinue
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FormAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final TraceComponent tc = Tr.register(FormAuthenticationMechanism.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
    private final Utils utils;
    static final long serialVersionUID = -5280336320657973224L;

    public FormAuthenticationMechanism() {
        this.utils = new Utils();
    }

    protected FormAuthenticationMechanism(Utils utils) {
        this.utils = utils;
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        Subject clientSubject = httpMessageContext.getClientSubject();
        AuthenticationParameters authParams = httpMessageContext.getAuthParameters();
        Credential cred = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AuthenticationParameters : " + authParams), (Object[])new Object[0]);
        }
        if (authParams != null) {
            cred = authParams.getCredential();
        }
        if (cred != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Credential is found.", (Object[])new Object[0]);
            }
            status = this.utils.handleAuthenticate(this.getCDI(), "defaultRealm", cred, clientSubject, httpMessageContext);
        } else {
            HttpServletRequest req = httpMessageContext.getRequest();
            HttpServletResponse rsp = httpMessageContext.getResponse();
            String username = null;
            String password = null;
            String uri = req.getRequestURI();
            if (uri.contains("/j_security_check")) {
                username = req.getParameter("j_username");
                password = req.getParameter("j_password");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("URI : " + uri + ", j_username : " + username), (Object[])new Object[0]);
            }
            if (httpMessageContext.isAuthenticationRequest()) {
                status = username != null && password != null ? this.handleFormLogin(username, password, rsp, clientSubject, httpMessageContext) : AuthenticationStatus.SEND_CONTINUE;
            } else if (username == null || password == null) {
                if (!httpMessageContext.isProtected()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"both isAuthenticationRequest and isProtected returns false. returing NOT_DONE,", (Object[])new Object[0]);
                    }
                    status = AuthenticationStatus.NOT_DONE;
                } else {
                    status = AuthenticationStatus.SEND_CONTINUE;
                }
            } else {
                status = this.handleFormLogin(username, password, rsp, clientSubject, httpMessageContext);
            }
        }
        return status;
    }

    public AuthenticationStatus secureResponse(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        return AuthenticationStatus.SUCCESS;
    }

    public void cleanSubject(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) {
    }

    private AuthenticationStatus handleFormLogin(String username, @Sensitive String password, HttpServletResponse rsp, Subject clientSubject, HttpMessageContext httpMessageContext) throws AuthenticationException {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        UsernamePasswordCredential credential = new UsernamePasswordCredential(username, password);
        status = this.utils.validateUserAndPassword(this.getCDI(), "defaultRealm", clientSubject, credential, httpMessageContext);
        if (status == AuthenticationStatus.SUCCESS) {
            Map messageInfoMap = httpMessageContext.getMessageInfo().getMap();
            messageInfoMap.put("jakarta.servlet.http.authType", "FORM");
            messageInfoMap.put("jakarta.servlet.http.registerSession", Boolean.TRUE.toString());
            httpMessageContext.getResponse().setStatus(200);
        } else if (status == AuthenticationStatus.NOT_DONE) {
            httpMessageContext.getResponse().setStatus(200);
        } else {
            httpMessageContext.responseUnauthorized();
        }
        return status;
    }

    @FFDCIgnore(value={IllegalStateException.class})
    protected CDI getCDI() {
        try {
            return CDI.current();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

