/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import java.io.InputStream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class StaticFileProcessor {
    private static final TraceComponent tc = Tr.register(StaticFileProcessor.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = 4248964287779987491L;

    @Trivial
    public static OpenApiStaticFile getOpenAPIFile(Container container) {
        OpenApiStaticFile staticFile = null;
        Format format = Format.YAML;
        Entry openAPIFileEntry = container.getEntry("/META-INF/openapi.yaml");
        if (openAPIFileEntry == null) {
            openAPIFileEntry = container.getEntry("/WEB-INF/classes/META-INF/openapi.yaml");
        }
        if (openAPIFileEntry == null) {
            openAPIFileEntry = container.getEntry("/META-INF/openapi.yml");
        }
        if (openAPIFileEntry == null) {
            openAPIFileEntry = container.getEntry("/WEB-INF/classes/META-INF/openapi.yml");
        }
        if (openAPIFileEntry == null) {
            openAPIFileEntry = container.getEntry("/META-INF/openapi.json");
            format = Format.JSON;
        }
        if (openAPIFileEntry == null) {
            openAPIFileEntry = container.getEntry("/WEB-INF/classes/META-INF/openapi.json");
            format = Format.JSON;
        }
        if (openAPIFileEntry != null) {
            InputStream is = StaticFileProcessor.entryToInputStream(openAPIFileEntry);
            if (is != null) {
                staticFile = new OpenApiStaticFile(is, format);
            }
        } else if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)"No static file was found", (Object[])new Object[0]);
        }
        return staticFile;
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    public static InputStream entryToInputStream(Entry entry) {
        if (entry == null) {
            return null;
        }
        try {
            InputStream is = (InputStream)entry.adapt(InputStream.class);
            return is;
        }
        catch (UnableToAdaptException e) {
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"Unable to adapt {0} to InputStream", (Object[])new Object[]{entry.getName()});
            }
            return null;
        }
    }
}

