/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health30.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.health.HealthCheckResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheck30HttpResponseBuilder {
    private static final TraceComponent tc = Tr.register(HealthCheck30HttpResponseBuilder.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    private static final JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(null);
    protected HealthCheckResponse.Status overallStatus = HealthCheckResponse.Status.UP;
    protected final JsonArrayBuilder checks = jsonBuilderFactory.createArrayBuilder();
    static final long serialVersionUID = -5300881976616012401L;

    public void addResponses(Set<HealthCheckResponse> hcResponseSet) {
        for (HealthCheckResponse hcResponse : hcResponseSet) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addResponse(): hcResponse = " + hcResponse), (Object[])new Object[0]);
            }
            this.setChecks(hcResponse);
        }
    }

    public void setHttpResponse(HttpServletResponse httpResponse) {
        httpResponse.setHeader("Content-Type", "application/json; charset=UTF-8");
        JsonObjectBuilder payload = jsonBuilderFactory.createObjectBuilder();
        httpResponse.setStatus(this.overallStatus == HealthCheckResponse.Status.UP ? 200 : 503);
        payload.add("status", this.overallStatus.name());
        payload.add("checks", this.checks);
        this.setJSONPayload(payload.build(), httpResponse);
    }

    public void handleUndeterminedResponse(HttpServletResponse httpResponse) {
        httpResponse.setStatus(500);
    }

    protected void setChecks(HealthCheckResponse response) {
        Optional dataMap;
        JsonObjectBuilder check = jsonBuilderFactory.createObjectBuilder();
        check.add("name", response.getName());
        HealthCheckResponse.Status checkStatus = response.getStatus();
        check.add("status", checkStatus == null ? null : checkStatus.name());
        if (checkStatus != null) {
            if (checkStatus.equals((Object)HealthCheckResponse.Status.DOWN)) {
                this.overallStatus = HealthCheckResponse.Status.DOWN;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setChecks(): checkStatus is null", (Object[])new Object[0]);
            }
            this.overallStatus = HealthCheckResponse.Status.DOWN;
        }
        if ((dataMap = response.getData()) != null && dataMap.isPresent()) {
            JsonObjectBuilder data = jsonBuilderFactory.createObjectBuilder();
            for (Map.Entry entry : ((Map)dataMap.get()).entrySet()) {
                Object value = entry.getValue();
                if (value == null) {
                    data.add((String)entry.getKey(), JsonValue.NULL);
                    continue;
                }
                if (value instanceof String) {
                    data.add((String)entry.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    data.add((String)entry.getKey(), ((Boolean)value).booleanValue());
                    continue;
                }
                data.add((String)entry.getKey(), ((Long)value).longValue());
            }
            check.add("data", (JsonValue)data.build());
        }
        this.checks.add(check);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setChecks(): checks = " + this.checks), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setJSONPayload(JsonObject payload, HttpServletResponse httpResponse) {
        try {
            httpResponse.getOutputStream().write(payload.toString().getBytes());
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.microprofile.health30.internal.HealthCheck30HttpResponseBuilder", (String)"135", (Object)this, (Object[])new Object[]{payload, httpResponse});
            if (tc.isEventEnabled()) {
                void e;
                Tr.event((TraceComponent)tc, (String)"Unexpected IOException while writing out POJO response", (Object[])new Object[]{e});
            }
            httpResponse.setStatus(500);
        }
    }

    public void setOverallStatus(HealthCheckResponse.Status status) {
        this.overallStatus = status;
    }
}

