/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.HomeInternal;
import com.ibm.ejs.container.HomeRecord;
import com.ibm.ejs.container.activator.ActivationStrategy;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSIRuntimeException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.StatefulSessionKey;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.failover.SfFailoverKey;
import com.ibm.ws.ejbcontainer.runtime.EJBRuntime;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class BeanId
implements EJBKey {
    private static final TraceComponent tc = Tr.register(BeanId.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.BeanId";
    boolean _isHome;
    Serializable pkey;
    J2EEName j2eeName;
    ByteArray byteArray;
    HomeInternal home;
    private ActivationStrategy activationStrategy;
    int hashValue;
    private SfFailoverKey ivFailoverKey;
    private static final byte HOME_BEAN = 0;
    private static final byte STATELESS_BEAN = 1;
    private static final byte STATEFUL_BEAN = 2;
    private static final byte ENTITY_BEAN = 3;
    private static final byte MESSAGEDRIVEN_BEAN = 4;
    private static final byte SINGLETON_BEAN = 5;
    private static final byte USES_BEAN_MANAGED_TX = 16;
    private static final byte MODULE_VERSION_CAPABLE = 32;
    private static final byte[] TYPE_TO_TYPE_ID_MAP = new byte[8];
    private static final byte SERIALIZED_PKEY = 0;
    private static final byte INTEGER_PKEY = 1;
    private static final byte STRING_PKEY = 3;
    private static final byte LONG_PKEY = 4;
    private static final byte BYTE_ARRAY_PKEY = 8;
    private static final int BEAN_TYPE_LEN = 1;
    private static final int J2EE_NAME_LEN = 4;
    private static final int PKEY_TYPE_LEN = 1;
    private static final byte[] header;
    private static final int HEADER_LEN;
    private static final ByteArrayOutputStream[] svBAOSs;
    private static int svBAOSsSize;

    public final SfFailoverKey getFailoverKey() {
        if (this.ivFailoverKey == null) {
            this.ivFailoverKey = EJSContainer.getDefaultContainer().getEJBRuntime().createFailoverKey(this);
        }
        return this.ivFailoverKey;
    }

    BeanId() {
        this.pkey = null;
        this.j2eeName = null;
        this._isHome = false;
    }

    public BeanId(HomeInternal home, Serializable pkey) {
        this(home, pkey, false);
    }

    public BeanId(HomeInternal home, Serializable pkey, boolean isHome) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BeanId", (Object[])new Object[]{home, pkey, isHome});
        }
        if (home == null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Home given for BeanId is null, this is most likely an internal PM or container issue", (Object[])new Object[0]);
            }
            throw new CSIRuntimeException("Home given for BeanId is null, this is most likely an internal PM or container issue");
        }
        this.home = home;
        this._isHome = isHome;
        this.j2eeName = home.getJ2EEName();
        this.pkey = pkey;
        this.hashValue = BeanId.computeHashValue(this.j2eeName, pkey, this._isHome);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"BeanId");
        }
    }

    public BeanId(J2EEName j2eeName, Serializable pkey, boolean isHome) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("BeanId : " + j2eeName + " : " + pkey), (Object[])new Object[0]);
        }
        this.home = null;
        this._isHome = isHome;
        this.j2eeName = j2eeName;
        this.pkey = pkey;
        this.hashValue = BeanId.computeHashValue(j2eeName, pkey, this._isHome);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("BeanId : " + this));
        }
    }

    public final String getJNDIName() {
        return this.home.getJNDIName(this.pkey);
    }

    public BeanId getInitializedBeanId() throws ClassNotFoundException, IOException {
        if (this.home == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getInitializedBeanId: initializing " + this), (Object[])new Object[0]);
            }
            EJSContainer container2 = EJSContainer.getDefaultContainer();
            return BeanId.getBeanId(this.getByteArray(), container2);
        }
        return this;
    }

    public final HomeInternal getHome() {
        return this.home;
    }

    public final BeanMetaData getBeanMetaData() {
        return this.home.getBeanMetaData(this);
    }

    public final Serializable getPrimaryKey() {
        return this.pkey;
    }

    public final J2EEName getJ2EEName() {
        return this._isHome ? (J2EEName)this.pkey : this.j2eeName;
    }

    public final ActivationStrategy getActivationStrategy() {
        if (this.activationStrategy == null) {
            this.activationStrategy = this.home.getActivationStrategy();
        }
        return this.activationStrategy;
    }

    public final int hashCode() {
        return this.hashValue;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BeanId) {
            BeanId e = (BeanId)o;
            if (e.hashValue == this.hashValue) {
                if (this._isHome) {
                    return this.pkey == e.pkey || this.pkey != null && this.pkey.equals(e.pkey);
                }
                return (this.j2eeName == e.j2eeName || this.j2eeName.equals(e.j2eeName)) && (this.pkey == e.pkey || this.pkey != null && this.pkey.equals(e.pkey));
            }
        }
        return false;
    }

    public final boolean equals(BeanId beanId) {
        if (this == beanId) {
            return true;
        }
        if (beanId != null && beanId.hashValue == this.hashValue) {
            if (this._isHome) {
                return this.pkey == beanId.pkey || this.pkey != null && this.pkey.equals(beanId.pkey);
            }
            return (this.j2eeName == beanId.j2eeName || this.j2eeName.equals(beanId.j2eeName)) && (this.pkey == beanId.pkey || this.pkey != null && this.pkey.equals(beanId.pkey));
        }
        return false;
    }

    public final boolean equals(HomeInternal compareHome, Serializable comparePkey, boolean isHome) {
        if (isHome) {
            return this.pkey == comparePkey || this.pkey != null && this.pkey.equals(comparePkey);
        }
        J2EEName compareJ2EEName = compareHome.getJ2EEName();
        return (this.j2eeName == compareJ2EEName || this.j2eeName.equals(compareJ2EEName)) && (this.pkey == comparePkey || this.pkey != null && this.pkey.equals(comparePkey));
    }

    public String toString() {
        return "BeanId(" + this.j2eeName + ", " + this.pkey + ")";
    }

    public final String getIdString() {
        return this.j2eeName + ":" + this.pkey;
    }

    public final ByteArray getByteArray() {
        if (this.byteArray != null) {
            return this.byteArray;
        }
        this.getByteArrayBytes();
        return this.byteArray;
    }

    public final byte[] getByteArrayBytes() {
        if (this.byteArray != null) {
            return this.byteArray.getBytes();
        }
        try {
            BeanMetaData bmd = this.getBeanMetaDataInternal();
            ByteArrayOutputStream baos = this.getByteArrayStream();
            baos.write(header);
            baos.write(BeanId.getBeanType(bmd, this._isHome));
            byte[] j2eeNameBytes = this.getJ2EENameBytes(bmd, this._isHome);
            int j2eeNameBytesLength = j2eeNameBytes.length;
            if (EJSPlatformHelper.isZOS()) {
                baos.write((byte)(j2eeNameBytesLength >> 24));
                baos.write((byte)(j2eeNameBytesLength >> 16));
                baos.write((byte)(j2eeNameBytesLength >> 8));
                baos.write((byte)j2eeNameBytesLength);
            } else {
                for (int i = 0; i < 4; ++i) {
                    baos.write(j2eeNameBytesLength >> i * 8);
                }
            }
            baos.write(j2eeNameBytes);
            this.writePKeyBytes(baos, bmd);
            byte[] serialized = baos.toByteArray();
            this.byteArray = new ByteArray(serialized);
            this.freeByteArrayStream(baos);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.BeanId.getByteArrayBytes", (String)"550", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unable to serialize primary key for bean", (Object[])new Object[]{this, ex});
            }
            return null;
        }
        return this.byteArray.getBytes();
    }

    private BeanMetaData getBeanMetaDataInternal() {
        J2EEName beanName;
        J2EEName j2EEName = beanName = this._isHome ? (J2EEName)this.pkey : this.j2eeName;
        if (this.home == null) {
            HomeRecord hr = EJSContainer.homeOfHomes.getHomeRecord(beanName);
            return hr == null ? null : hr.bmd;
        }
        return this.home.getBeanMetaData(beanName);
    }

    private byte[] getJ2EENameBytes(BeanMetaData bmd, boolean isHome) {
        if (!isHome && bmd.ivUnversionedJ2eeName != null) {
            return bmd.ivUnversionedJ2eeName.getBytes();
        }
        return this.j2eeName.getBytes();
    }

    private static byte getBeanType(BeanMetaData bmd, boolean isHome) {
        if (isHome) {
            if (bmd != null && bmd._moduleMetaData.isVersionedModule()) {
                return 32;
            }
            return 0;
        }
        byte typeId = TYPE_TO_TYPE_ID_MAP[bmd.type];
        if (bmd.usesBeanManagedTx) {
            typeId = (byte)(typeId | 0x10);
        }
        if (bmd._moduleMetaData.isVersionedModule()) {
            typeId = (byte)(typeId | 0x20);
        }
        return typeId;
    }

    public static BeanId getBeanId(ByteArray byteArray, EJSContainer container2) throws IOException, ClassNotFoundException {
        BeanId id = null;
        Serializable pkey = null;
        boolean isHome = false;
        J2EEName j2eeName = null;
        byte[] bytes = byteArray.getBytes();
        for (int i = 0; i < HEADER_LEN; ++i) {
            if (bytes[i] == header[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Header mismatch, bytes do not represent a BeanId.", (Object[])new Object[0]);
            }
            throw new IOException("Invalid BeanId header '" + new String(bytes) + "', bytes not a BeanId");
        }
        byte typeId = bytes[HEADER_LEN];
        boolean isVersionCapable = (typeId & 0x20) != 0;
        switch (typeId & 0xFFFFFFDF) {
            case 0: {
                isHome = true;
            }
            case 2: 
            case 3: 
            case 18: {
                byte[] j2eeNameBytes = BeanId.readJ2EENameBytes(bytes);
                j2eeName = container2.getJ2EENameFactory().create(j2eeNameBytes);
                if (!isHome && isVersionCapable) {
                    j2eeName = EJSContainer.homeOfHomes.getVersionedJ2EEName(j2eeName);
                }
                int pkeyIndex = HEADER_LEN + 1 + 4 + j2eeNameBytes.length;
                pkey = BeanId.readPKey(bytes, pkeyIndex, j2eeName);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 17: 
            case 20: 
            case 21: {
                byte[] j2eeNameBytes = BeanId.readJ2EENameBytes(bytes);
                j2eeName = container2.getJ2EENameFactory().create(j2eeNameBytes);
                if (!isVersionCapable) break;
                j2eeName = EJSContainer.homeOfHomes.getVersionedJ2EEName(j2eeName);
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unable to parse bean id: unsupported EJB type: " + bytes[HEADER_LEN]), (Object[])new Object[0]);
                }
                throw new IOException("Unsupported EJB Type: " + bytes[HEADER_LEN]);
            }
        }
        HomeInternal home = container2.getHomeOfHomes().getHome(j2eeName);
        if (home == null) {
            Tr.warning((TraceComponent)tc, (String)"HOME_NOT_FOUND_CNTR0092W", (Object[])new Object[]{j2eeName.toString()});
            throw new EJBNotFoundException(j2eeName.toString());
        }
        if (home.isStatefulSessionHome()) {
            pkey = EJSContainer.sessionKeyFactory.create((byte[])pkey);
        }
        if (isHome) {
            if (home != EJSContainer.homeOfHomes && home != EJSContainer.homeOfHomes.ivEJBFactoryHome) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("invalid home bean type id for " + j2eeName), (Object[])new Object[]{byteArray});
                }
                throw new IOException("Invalid home bean type id");
            }
            pkey = container2.getJ2EENameFactory().create((byte[])pkey);
            if (isVersionCapable) {
                pkey = EJSContainer.homeOfHomes.getVersionedJ2EEName((J2EEName)pkey);
            }
        } else if (BeanId.getBeanType(home.getBeanMetaData(j2eeName), false) != typeId) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("invalid bean type id for " + j2eeName), (Object[])new Object[]{byteArray});
            }
            throw new IOException("Invalid bean type id");
        }
        id = new BeanId(home, pkey, isHome);
        id.byteArray = byteArray;
        return id;
    }

    private static byte[] readJ2EENameBytes(byte[] bytes) throws CSIException {
        int j2eeNameLength = 0;
        int j2eeNameIndex = HEADER_LEN + 1;
        if ((j2eeNameIndex += 4) + (j2eeNameLength = EJSPlatformHelper.isZOS() ? (bytes[j2eeNameIndex + 0] & 0xFF) << 24 | (bytes[j2eeNameIndex + 1] & 0xFF) << 16 | (bytes[j2eeNameIndex + 2] & 0xFF) << 8 | bytes[j2eeNameIndex + 3] & 0xFF : bytes[j2eeNameIndex + 0] & 0xFF | (bytes[j2eeNameIndex + 1] & 0xFF) << 8 | (bytes[j2eeNameIndex + 2] & 0xFF) << 16 | (bytes[j2eeNameIndex + 3] & 0xFF) << 24) > bytes.length) {
            int j2eeNameLengthReversed;
            String message = "Invalid J2EEName length: " + j2eeNameLength + " + " + j2eeNameIndex + " > " + bytes.length;
            if (j2eeNameLength >= 0x1000000 && j2eeNameIndex + (j2eeNameLengthReversed = Integer.reverseBytes(j2eeNameLength)) < 0x1000000) {
                message = message + " (length " + j2eeNameLengthReversed + " written in a different byte order?)";
            }
            throw new CSIException(message);
        }
        byte[] temp = new byte[j2eeNameLength];
        System.arraycopy(bytes, j2eeNameIndex, temp, 0, j2eeNameLength);
        return temp;
    }

    private static Serializable readPKey(byte[] bytes, int pkeyIndex, J2EEName j2eeName) throws IOException, ClassNotFoundException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readPKey", (Object[])new Object[]{pkeyIndex, j2eeName});
        }
        Object pkey = null;
        int pkeyLen = bytes.length - pkeyIndex - 1;
        int index = pkeyIndex++;
        byte type = bytes[index++];
        switch (type) {
            case 0: {
                pkey = BeanId.readSerializedPKey(bytes, pkeyIndex, pkeyLen, j2eeName);
                break;
            }
            case 1: {
                int ivalue = 0;
                for (int i = 3; i >= 0; --i) {
                    ivalue ^= bytes[index + i] & 0xFF;
                    if (i <= 0) continue;
                    ivalue <<= 8;
                }
                pkey = ivalue;
                break;
            }
            case 4: {
                long lvalue = 0L;
                for (int i = 7; i >= 0; --i) {
                    lvalue ^= (long)bytes[index + i] & 0xFFL;
                    if (i <= 0) continue;
                    lvalue <<= 8;
                }
                pkey = lvalue;
                break;
            }
            case 3: {
                pkey = new String(bytes, pkeyIndex, pkeyLen);
                break;
            }
            case 8: {
                byte[] b = new byte[pkeyLen];
                System.arraycopy(bytes, pkeyIndex, b, 0, pkeyLen);
                pkey = b;
                break;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readPKey", (Object)pkey);
        }
        return pkey;
    }

    private static Serializable readSerializedPKey(byte[] bytes, int start, int len, J2EEName j2eeName) throws IOException, ClassNotFoundException {
        Serializable pkey;
        block3: {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes, start, len);
            ClassLoader loader = EJSContainer.getClassLoader(j2eeName);
            EJBRuntime ejbRuntime = EJSContainer.getDefaultContainer().getEJBRuntime();
            final ObjectInputStream objIstream = ejbRuntime.createObjectInputStream(bais, loader);
            pkey = null;
            try {
                pkey = (Serializable)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws ClassNotFoundException, IOException {
                        return objIstream.readObject();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.BeanId.readSerializedPKey", (String)"863");
                Exception e2 = e.getException();
                if (e2 instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)e2;
                }
                if (!(e2 instanceof IOException)) break block3;
                throw (IOException)e2;
            }
        }
        return pkey;
    }

    protected static byte[] getJ2EENameBytes(byte[] bytes) throws CSIException {
        boolean isHome = false;
        byte[] j2eeNameBytes = null;
        for (int i = 0; i < HEADER_LEN; ++i) {
            if (bytes[i] == header[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Header mismatch, attempting to deserialize BeanId", (Object[])new Object[0]);
            }
            throw new CSIException("Parser Error: header mismatch");
        }
        switch (bytes[HEADER_LEN]) {
            case 0: {
                isHome = true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                j2eeNameBytes = BeanId.readJ2EENameBytes(bytes);
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unable to parse bean id: unsupported EJB type: " + bytes[HEADER_LEN]), (Object[])new Object[0]);
                }
                throw new CSIException("Unsupported EJB Type: " + bytes[HEADER_LEN]);
            }
        }
        if (isHome) {
            try {
                int pkeyIndex = HEADER_LEN + 1 + 4 + j2eeNameBytes.length;
                j2eeNameBytes = (byte[])BeanId.readPKey(bytes, pkeyIndex, null);
            }
            catch (Throwable th) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unable to parse bean id: home j2eeName: " + th), (Object[])new Object[0]);
                }
                throw new CSIException("Unable to read j2eeName bytes", th);
            }
        }
        return j2eeNameBytes;
    }

    protected static Serializable getPrimaryKey(byte[] bytes) throws CSIException {
        boolean isStateful = false;
        Serializable pkey = null;
        byte[] j2eeNameBytes = null;
        J2EEName j2eeName = null;
        for (int i = 0; i < HEADER_LEN; ++i) {
            if (bytes[i] == header[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Header mismatch, attempting to deserialize BeanId", (Object[])new Object[0]);
            }
            throw new CSIException("Parser Error: header mismatch");
        }
        switch (bytes[HEADER_LEN]) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 17: 
            case 20: 
            case 21: {
                break;
            }
            case 2: 
            case 18: {
                isStateful = true;
            }
            case 3: {
                j2eeNameBytes = BeanId.readJ2EENameBytes(bytes);
                j2eeName = EJSContainer.getDefaultContainer().getJ2EENameFactory().create(j2eeNameBytes);
                int pkeyIndex = HEADER_LEN + 1 + 4 + j2eeNameBytes.length;
                try {
                    pkey = BeanId.readPKey(bytes, pkeyIndex, j2eeName);
                    break;
                }
                catch (Throwable th) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Unable to parse bean id: primary key: " + th), (Object[])new Object[0]);
                    }
                    throw new CSIException("Unable to read primary key", th);
                }
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unable to parse bean id: unsupported EJB type: " + bytes[HEADER_LEN]), (Object[])new Object[0]);
                }
                throw new CSIException("Unsupported EJB Type: " + bytes[HEADER_LEN]);
            }
        }
        if (isStateful) {
            pkey = EJSContainer.sessionKeyFactory.create((byte[])pkey);
        }
        return pkey;
    }

    public final String getMethodName(int id) {
        return this.home.getMethodName(this.pkey, id, this._isHome);
    }

    public final boolean isHome() {
        return this._isHome;
    }

    public final String getEnterpriseBeanClassName() {
        return this.home.getEnterpriseBeanClassName(this.pkey);
    }

    protected static int computeHashValue(J2EEName j2eeName, Serializable pkey, boolean isHome) {
        return j2eeName.hashCode() + (pkey == null ? 0 : pkey.hashCode()) + (isHome ? 1 : 0);
    }

    public final boolean useLSD() {
        if (this._isHome) {
            return true;
        }
        BeanMetaData bmd = this.home.getBeanMetaData(this.j2eeName);
        return bmd.type == 6 || bmd.type == 2 || bmd.type == 3 || bmd.type == 5 || bmd.ivSFSBFailover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteArrayOutputStream getByteArrayStream() {
        ByteArrayOutputStream rtnBaos = null;
        ByteArrayOutputStream[] byteArrayOutputStreamArray = svBAOSs;
        synchronized (svBAOSs) {
            if (svBAOSsSize > 0) {
                rtnBaos = svBAOSs[--svBAOSsSize];
                BeanId.svBAOSs[BeanId.svBAOSsSize] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (rtnBaos == null) {
                rtnBaos = new ByteArrayOutputStream();
            } else {
                rtnBaos.reset();
            }
            return rtnBaos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void freeByteArrayStream(ByteArrayOutputStream baos) {
        ByteArrayOutputStream[] byteArrayOutputStreamArray = svBAOSs;
        synchronized (svBAOSs) {
            if (svBAOSsSize < svBAOSs.length) {
                BeanId.svBAOSs[BeanId.svBAOSsSize] = baos;
                ++svBAOSsSize;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final void writePKeyBytes(ByteArrayOutputStream baos, BeanMetaData bmd) throws IOException {
        if (this.pkey != null) {
            if (this._isHome) {
                baos.write(8);
                if (bmd != null && bmd.ivUnversionedJ2eeName != null) {
                    baos.write(bmd.ivUnversionedJ2eeName.getBytes());
                } else {
                    baos.write(((J2EEName)this.pkey).getBytes());
                }
            } else if (this.home.isStatefulSessionHome()) {
                baos.write(8);
                baos.write(((StatefulSessionKey)this.pkey).getBytes());
            } else if (this.pkey.getClass().getName().startsWith("java.lang")) {
                if (this.pkey instanceof Integer) {
                    baos.write(1);
                    int value = (Integer)this.pkey;
                    for (int i = 0; i < 4; ++i) {
                        baos.write(value >> i * 8);
                    }
                } else if (this.pkey instanceof Long) {
                    baos.write(4);
                    long value = (Long)this.pkey;
                    for (int i = 0; i < 8; ++i) {
                        baos.write((byte)(value >> i * 8));
                    }
                } else if (this.pkey instanceof String) {
                    baos.write(3);
                    baos.write(((String)((Object)this.pkey)).getBytes());
                } else {
                    this.writeSerializedPKey(baos);
                }
            } else {
                this.writeSerializedPKey(baos);
            }
        }
    }

    private final void writeSerializedPKey(ByteArrayOutputStream baos) throws IOException {
        baos.write(0);
        ObjectOutputStream objOstream = new ObjectOutputStream(baos);
        objOstream.writeObject(this.pkey);
        objOstream.flush();
    }

    static {
        BeanId.TYPE_TO_TYPE_ID_MAP[2] = 5;
        BeanId.TYPE_TO_TYPE_ID_MAP[3] = 1;
        BeanId.TYPE_TO_TYPE_ID_MAP[4] = 2;
        BeanId.TYPE_TO_TYPE_ID_MAP[5] = 3;
        BeanId.TYPE_TO_TYPE_ID_MAP[6] = 3;
        BeanId.TYPE_TO_TYPE_ID_MAP[7] = 4;
        header = new byte[]{-84, -84, 0, 2, 0, 1};
        HEADER_LEN = header.length;
        svBAOSs = new ByteArrayOutputStream[50];
        svBAOSsSize = 0;
    }
}

